/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.customfield;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.RenderingLocation;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.service.denormalizedfield.DenormalizedFieldValueManager;

public class DenormalizedFieldHelper<X extends DenormalizedFieldHolder> {
    private DenormalizedFieldValueManager dcufFinder;
    private Collection<RenderingLocation> locations;
    private List<CustomField> customFields;
    private List<DenormalizedFieldValue> values;
    private final Collection<X> entities;

    public DenormalizedFieldHelper(X entity) {
        this.entities = new ArrayList<X>();
        this.entities.add(entity);
    }

    public DenormalizedFieldHelper(Collection<X> entities) {
        this.entities = entities;
    }

    public void setDenormalizedFieldValueFinder(DenormalizedFieldValueManager finder) {
        this.dcufFinder = finder;
    }

    public DenormalizedFieldHelper<X> setRenderingLocations(RenderingLocation ... locations) {
        this.locations = Arrays.asList(locations);
        return this;
    }

    public DenormalizedFieldHelper<X> setRenderingLocations(Collection<RenderingLocation> locations) {
        this.locations = locations;
        return this;
    }

    public List<CustomField> getCustomFieldConfiguration() {
        if (!this.isInited()) {
            this.init();
        }
        return this.customFields;
    }

    public List<DenormalizedFieldValue> getDenormalizedFieldValues() {
        if (!this.isInited()) {
            this.init();
        }
        return this.values;
    }

    protected void init() {
        if (!this.entities.isEmpty()) {
            this.findValues();
            this.extractCustomFields();
        } else {
            this.values = Collections.emptyList();
            this.customFields = Collections.emptyList();
        }
    }

    private void findValues() {
        this.values = this.dcufFinder.findAllForEntities(this.entities, this.locations);
    }

    private void extractCustomFields() {
        HashMap<String, CustomField> cfMap = new HashMap<String, CustomField>();
        for (DenormalizedFieldValue dfv : this.values) {
            if (cfMap.get(dfv.getCode()) != null) continue;
            CustomField customField = new CustomField(dfv.getInputType());
            customField.setCode(dfv.getCode());
            customField.setLabel(dfv.getLabel());
            cfMap.put(customField.getCode(), customField);
        }
        this.customFields = new ArrayList(cfMap.values());
    }

    private boolean isInited() {
        return this.customFields != null;
    }
}

