/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.quicktestnote;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.quicktest.QuickTest;
import org.squashtest.tm.domain.quicktest.QuickTestNote;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.internal.display.dto.sprint.QuickTestNoteDto;
import org.squashtest.tm.service.internal.repository.QuickTestDao;
import org.squashtest.tm.service.internal.repository.QuickTestNoteDao;
import org.squashtest.tm.service.quicktestnote.QuickTestNoteCreationService;

@Service
@Transactional
public class QuickTestNoteCreationServiceImpl
implements QuickTestNoteCreationService {
    private final QuickTestDao quickTestDao;
    private final QuickTestNoteDao quickTestNoteDao;

    public QuickTestNoteCreationServiceImpl(QuickTestDao quickTestDao, QuickTestNoteDao quickTestNoteDao) {
        this.quickTestDao = quickTestDao;
        this.quickTestNoteDao = quickTestNoteDao;
    }

    @Override
    @CheckEntityExists(entityType=QuickTest.class)
    public QuickTestNoteDto createQuickTestNote(@Id long quickTestId, QuickTestNote note) {
        QuickTest quickTest = (QuickTest)this.quickTestDao.getReferenceById(quickTestId);
        QuickTestNote quickTestNote = new QuickTestNote();
        quickTestNote.setQuickTest(quickTest);
        quickTestNote.setContent(note.getContent());
        this.quickTestNoteDao.save(quickTestNote);
        return new QuickTestNoteDto(quickTestNote.getId(), quickTestNote.getQuickTest().getId(), quickTestNote.getContent());
    }
}

