/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.query;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Wildcard;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import org.hibernate.Session;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.query.QueryFilterColumn;
import org.squashtest.tm.service.internal.query.InternalQueryModel;
import org.squashtest.tm.service.internal.query.QueryBuilder;
import org.squashtest.tm.service.internal.query.ScopePlanner;
import org.squashtest.tm.service.query.ConfiguredQuery;
import org.squashtest.tm.service.query.QueryProcessingService;

@Component
public class QueryProcessingServiceImpl
implements QueryProcessingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryProcessingServiceImpl.class);
    @Inject
    Provider<ScopePlanner> scopePlannerProvider;
    @PersistenceContext
    private EntityManager em;

    @Override
    public ExtendedHibernateQuery<Tuple> prepareQuery(ConfiguredQuery configuredQuery) {
        InternalQueryModel internalQueryModel = new InternalQueryModel(configuredQuery);
        ExtendedHibernateQuery<?> detachedQuery = new QueryBuilder(internalQueryModel).createQuery();
        ScopePlanner scopePlanner = (ScopePlanner)this.scopePlannerProvider.get();
        scopePlanner.setQueryModel(internalQueryModel);
        scopePlanner.setHibernateQuery(detachedQuery);
        scopePlanner.setScope((List)internalQueryModel.getScope());
        scopePlanner.appendScope();
        if (internalQueryModel.getPaging() != null) {
            Pageable page = internalQueryModel.getPaging();
            detachedQuery.offset(page.getOffset());
            detachedQuery.limit((long)page.getPageSize());
        }
        return detachedQuery;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Tuple> executeQuery(ConfiguredQuery configuredQuery) {
        ExtendedHibernateQuery<Tuple> detachedQuery = this.prepareQuery(configuredQuery);
        List tags = configuredQuery.getQueryModel().getFilterColumns();
        if (!tags.isEmpty() && ((QueryFilterColumn)tags.getFirst()).getOperation() == Operation.AND) {
            long tagCount = ((QueryFilterColumn)configuredQuery.getQueryModel().getFilterColumns().getFirst()).getValues().size();
            detachedQuery.having((Predicate)Wildcard.count.eq((Object)tagCount));
        }
        ExtendedHibernateQuery finalQuery = (ExtendedHibernateQuery)detachedQuery.clone((Session)this.em.unwrap(Session.class));
        try {
            return finalQuery.fetch();
        }
        catch (Exception ex) {
            LOGGER.error("attempted to execute a chart query and failed : ", new Object[0]);
            LOGGER.error(finalQuery.toString(), new Object[0]);
            throw new RuntimeException(ex);
        }
    }
}

