/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import java.util.List;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandler;

@Component
public class FilterHandlers {
    private List<FilterHandler> filterHandlers;

    public FilterHandlers(List<FilterHandler> filterHandlers) {
        this.filterHandlers = filterHandlers;
    }

    public boolean isHandledOutOfQueryEngine(GridFilterValue filter) {
        List<FilterHandler> handlers = this.findHandlers(filter);
        if (handlers.size() > 1) {
            throw new RuntimeException("There can be only one special filter handler for a filter value");
        }
        return handlers.size() == 1;
    }

    private List<FilterHandler> findHandlers(GridFilterValue filter) {
        return this.filterHandlers.stream().filter(filterHandler -> filterHandler.canHandleFilter(filter)).toList();
    }

    public void handleFiltersOutOfQueryEngine(ExtendedHibernateQuery<?> query, GridRequest gridRequest) {
        gridRequest.getFilterValues().stream().filter(this::isHandledOutOfQueryEngine).forEach(filter -> {
            List<FilterHandler> handlers = this.findHandlers((GridFilterValue)filter);
            handlers.get(0).handleFilter(query, (GridFilterValue)filter, gridRequest);
        });
    }
}

