/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.campaign.export.CampaignExportFull;
import org.squashtest.tm.service.campaign.export.dao.CampaignExportFullDao;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.campaign.export.AbstractCampaignExport;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportHeader;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportMode;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportRows;
import org.squashtest.tm.service.internal.campaign.export.dao.AbstractCampaignExportDao;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.filemanagement.writer.WriterFactory;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;

@Service
@Transactional
public class CampaignExportFullImpl
extends AbstractCampaignExport
implements CampaignExportFull {
    private final CampaignExportFullDao campaignExportFullDao;

    public CampaignExportFullImpl(FeatureManager featureManager, WriterFactory writerFactory, CampaignExportFullDao campaignExportFullDao) {
        super(featureManager, writerFactory);
        this.campaignExportFullDao = campaignExportFullDao;
    }

    @Override
    public void doExport(Appendable appendable, Long campaignId) {
        this.doExport(appendable, campaignId, CampaignExportMode.FULL);
    }

    @Override
    protected Map<BindableEntity, List<String>> getCufHeader(Long campaignId, List<BindableEntity> bindableEntities) {
        return this.campaignExportFullDao.getCufHeaderQuery(campaignId, bindableEntities);
    }

    @Override
    protected ResultQuery<Record> getQuery(Long campaignId) {
        return this.campaignExportFullDao.getQuery(campaignId);
    }

    @Override
    protected List<BindableEntity> getBindableEntities() {
        return List.of(BindableEntity.CAMPAIGN, BindableEntity.ITERATION, BindableEntity.TEST_CASE, BindableEntity.EXECUTION, BindableEntity.EXECUTION_STEP);
    }

    @Override
    protected Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> getCufProcessors(Long campaignId) {
        return this.campaignExportFullDao.getCufProcessors(campaignId);
    }

    @Override
    protected Map<String, String> exportData(Record record, CampaignExportRows campaignExportRows, boolean milestonesEnabled, AbstractCampaignExport.CalculateOrder calculateOrder, Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessor, Map<BindableEntity, List<CustomFieldValueDto>> cufStorage) {
        this.addCampaign(record, campaignExportRows);
        this.addIteration(record, campaignExportRows, milestonesEnabled);
        this.addTestPlanItem(record, campaignExportRows);
        this.addTestCase(record, campaignExportRows, milestonesEnabled);
        this.addTestSuite(record, campaignExportRows);
        this.addExecution(record, campaignExportRows);
        this.addStep(record, campaignExportRows, calculateOrder);
        this.addCufs(record, campaignExportRows, cufProcessor, cufStorage);
        return campaignExportRows.getRow();
    }

    private void addCufs(Record record, CampaignExportRows campaignExportRows, Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessor, Map<BindableEntity, List<CustomFieldValueDto>> cufStorage) {
        this.addCufValue(record, (Field<Long>)Tables.CAMPAIGN.CLN_ID, campaignExportRows, BindableEntity.CAMPAIGN, cufProcessor, cufStorage);
        this.addCufValue(record, (Field<Long>)Tables.ITERATION.ITERATION_ID, campaignExportRows, BindableEntity.ITERATION, cufProcessor, cufStorage);
        this.addCufValue(record, (Field<Long>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, campaignExportRows, BindableEntity.TEST_CASE, cufProcessor, cufStorage);
        this.addCufValue(record, (Field<Long>)Tables.EXECUTION.EXECUTION_ID, campaignExportRows, BindableEntity.EXECUTION, cufProcessor, cufStorage);
        this.addCufValue(record, (Field<Long>)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, campaignExportRows, BindableEntity.EXECUTION_STEP, cufProcessor, cufStorage);
    }

    private void addCampaign(Record record, CampaignExportRows campaignExportRows) {
        campaignExportRows.addValue(CampaignExportHeader.CPG_SCHEDULED_START_ON, (Date)record.get((Field)Tables.CAMPAIGN.SCHEDULED_START_DATE));
        campaignExportRows.addValue(CampaignExportHeader.CPG_SCHEDULED_END_ON, (Date)record.get((Field)Tables.CAMPAIGN.SCHEDULED_END_DATE));
        campaignExportRows.addValue(CampaignExportHeader.CPG_ACTUAL_START_ON, (Date)record.get((Field)Tables.CAMPAIGN.ACTUAL_START_DATE));
        campaignExportRows.addValue(CampaignExportHeader.CPG_ACTUAL_END_ON, (Date)record.get((Field)Tables.CAMPAIGN.ACTUAL_END_DATE));
    }

    private void addIteration(Record record, CampaignExportRows campaignExportRows, boolean milestonesEnabled) {
        campaignExportRows.addValue(CampaignExportHeader.IT_ID, record.get((Field)Tables.ITERATION.ITERATION_ID));
        campaignExportRows.addOrderValue(CampaignExportHeader.IT_NUM, (Integer)record.get((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER));
        campaignExportRows.addValue(CampaignExportHeader.IT_NAME, (String)record.get((Field)Tables.ITERATION.NAME));
        campaignExportRows.addValue(CampaignExportHeader.IT_SCHEDULED_START_ON, (Date)record.get((Field)Tables.ITERATION.SCHEDULED_START_DATE));
        campaignExportRows.addValue(CampaignExportHeader.IT_SCHEDULED_END_ON, (Date)record.get((Field)Tables.ITERATION.SCHEDULED_END_DATE));
        campaignExportRows.addValue(CampaignExportHeader.IT_ACTUAL_START_ON, (Date)record.get((Field)Tables.ITERATION.ACTUAL_START_DATE));
        campaignExportRows.addValue(CampaignExportHeader.IT_ACTUAL_END_ON, (Date)record.get((Field)Tables.ITERATION.ACTUAL_END_DATE));
        if (milestonesEnabled) {
            campaignExportRows.addValue(CampaignExportHeader.IT_MILESTONE, (String)record.get((Field)Tables.MILESTONE.LABEL));
        }
    }

    private void addTestPlanItem(Record record, CampaignExportRows campaignExportRows) {
        campaignExportRows.addValue(CampaignExportHeader.EXEC_STATUS, (String)record.get((Field)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS));
        campaignExportRows.addValueOrEmpty(CampaignExportHeader.EXEC_LOGIN, record.get((Field)Tables.CORE_USER.LOGIN));
        campaignExportRows.addValue(CampaignExportHeader.EXECUTION_DATE, (Date)record.get((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON));
    }

    private void addTestCase(Record record, CampaignExportRows campaignExportRows, boolean milestonesEnabled) {
        campaignExportRows.addValue(CampaignExportHeader.TC_ID, record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID));
        campaignExportRows.addValue(CampaignExportHeader.TC_NAME, (String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME));
        campaignExportRows.addValue(CampaignExportHeader.TC_PROJECT_ID, record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID));
        campaignExportRows.addValue(CampaignExportHeader.TC_PROJECT, (String)record.get((Field)Tables.PROJECT.NAME));
        campaignExportRows.addValue(CampaignExportHeader.TC_WEIGHT, (String)record.get((Field)Tables.TEST_CASE.IMPORTANCE));
        campaignExportRows.addValue(CampaignExportHeader.TC_REF, (String)record.get((Field)Tables.TEST_CASE.REFERENCE));
        campaignExportRows.addValue(CampaignExportHeader.TC_NATURE, (String)record.get(AbstractCampaignExportDao.TC_NATURE_CODE));
        campaignExportRows.addValue(CampaignExportHeader.TC_TYPE, (String)record.get(AbstractCampaignExportDao.TC_TYPE_CODE));
        campaignExportRows.addValue(CampaignExportHeader.TC_STATUS, (String)record.get((Field)Tables.TEST_CASE.TC_STATUS));
        campaignExportRows.addValue(CampaignExportHeader.COUNT_TC_COVERAGE, record.get(AbstractCampaignExportDao.TC_COVERAGE_COUNT));
        campaignExportRows.addValueOrEmpty(CampaignExportHeader.DATASET, record.get((Field)Tables.DATASET.NAME));
        if (milestonesEnabled) {
            campaignExportRows.addValue(CampaignExportHeader.TC_MILESTONE, (String)record.get(AbstractCampaignExportDao.TC_MILESTONE_LABELS));
        }
    }

    private void addTestSuite(Record record, CampaignExportRows campaignExportRows) {
        campaignExportRows.addValueOrEmpty(CampaignExportHeader.TEST_SUITE, record.get(AbstractCampaignExportDao.SUITE_NAMES));
    }

    private void addExecution(Record record, CampaignExportRows campaignExportRows) {
        campaignExportRows.addValue(CampaignExportHeader.COUNT_EXECUTIONS, record.get(AbstractCampaignExportDao.EXECUTION_COUNT));
        campaignExportRows.addValue(CampaignExportHeader.COUNT_EXEC_ISSUES, record.get(AbstractCampaignExportDao.EXECUTION_ISSUE_COUNT));
    }

    private void addStep(Record record, CampaignExportRows campaignExportRows, AbstractCampaignExport.CalculateOrder calculateOrder) {
        campaignExportRows.addValue(CampaignExportHeader.STEP_NUM, calculateOrder.getNextStep((Long)record.get((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)));
        campaignExportRows.addValue(CampaignExportHeader.COUNT_STEP_COVERAGE, record.get(AbstractCampaignExportDao.TS_COVERAGE_COUNT));
        if (Objects.nonNull(record.get((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID))) {
            campaignExportRows.addValue(CampaignExportHeader.STEP_ID, record.get((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID));
            campaignExportRows.addValue(CampaignExportHeader.EXEC_STEP_STATUS, (String)record.get((Field)Tables.EXECUTION_STEP.EXECUTION_STATUS));
            campaignExportRows.addValue(CampaignExportHeader.EXEC_STEP_DATE, (Date)record.get((Field)Tables.EXECUTION_STEP.LAST_EXECUTED_ON));
            campaignExportRows.addValueOrEmpty(CampaignExportHeader.EXEC_STEP_USER, record.get((Field)Tables.EXECUTION_STEP.LAST_EXECUTED_BY));
            campaignExportRows.addValue(CampaignExportHeader.COUNT_EXEC_STEP_ISSUES, record.get(AbstractCampaignExportDao.EXECUTION_STEP_ISSUE_COUNT));
            campaignExportRows.addValueLongText(CampaignExportHeader.EXEC_STEP_COMMENT, (String)record.get((Field)Tables.EXECUTION_STEP.COMMENT));
        }
    }
}

