/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.domain.bdd.SupportedLanguage;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.artificialintelligence.testcasegeneration.AiTestCaseGenerationViewService;
import org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration.AiTestCaseGenerationViewServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration.RequirementTranslationService;
import org.squashtest.tm.service.internal.display.dto.PromptDto;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.display.PromptDisplayDao;
import org.squashtest.tm.service.internal.templaterenderer.HandlebarsTemplateRenderer;

@Service
@Transactional
public class AiTestCaseGenerationViewServiceImpl
implements AiTestCaseGenerationViewService {
    protected static final String CATEGORY = "category";
    protected static final String CRITICALITY = "criticality";
    protected static final String NATURE = "nature";
    protected static final String HIGH_LEVEL = "HIGH_LEVEL";
    protected static final String CLASSIC = "CLASSIC";
    private static final String REQUIREMENT = "requirement";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String REFERENCE = "reference";
    private final PromptDisplayDao promptDisplayDao;
    private final RequirementVersionDao requirementVersionDao;
    private final GenericProjectDao projectDao;
    private final RequirementTranslationService translationService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public AiTestCaseGenerationViewServiceImpl(PromptDisplayDao promptDisplayDao, RequirementVersionDao requirementVersionDao, GenericProjectDao projectDao, RequirementTranslationService translationService) {
        this.promptDisplayDao = promptDisplayDao;
        this.requirementVersionDao = requirementVersionDao;
        this.projectDao = projectDao;
        this.translationService = translationService;
    }

    @Override
    @IsUltimateLicenseAvailable
    public List<PromptDto> findAllPromptsByRequirementVersionId(Long requirementVersionId) {
        List<PromptDto> prompts = this.promptDisplayDao.findAllForClassicTcGenerationByReqVersionId(requirementVersionId);
        RequirementVersion requirementVersion = (RequirementVersion)this.requirementVersionDao.findById(requirementVersionId).orElseThrow();
        Long projectId = this.requirementVersionDao.findProjectIdByRequirementVersionId(requirementVersionId);
        SupportedLanguage aiPromptLanguage = SupportedLanguage.valueOf((String)this.projectDao.findAiPromptLanguageByProjectId(projectId));
        Map<String, Object> variableValueByPlaceholder = this.getVariableValueByPlaceholder(requirementVersion, aiPromptLanguage);
        prompts.forEach(prompt -> {
            PromptDto promptDto = prompt;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, (Object)promptDto);
            Object[] objectArray = new Object[]{promptDto, joinPoint};
            AiTestCaseGenerationViewServiceImpl$AjcClosure1 aiTestCaseGenerationViewServiceImpl$AjcClosure1 = new AiTestCaseGenerationViewServiceImpl$AjcClosure1(objectArray);
            String userPromptWithRealValues = HandlebarsTemplateRenderer.renderTemplate((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(aiTestCaseGenerationViewServiceImpl$AjcClosure1.linkClosureAndJoinPoint(16)), variableValueByPlaceholder);
            prompt.setUserPromptTemplate(userPromptWithRealValues);
        });
        return prompts;
    }

    private Map<String, Object> getVariableValueByPlaceholder(RequirementVersion requirementVersion, SupportedLanguage aiPromptLanguage) {
        String criticalityKey = requirementVersion.getCriticality().name();
        String categoryKey = requirementVersion.getCategory().getCode();
        String natureKey = requirementVersion.getRequirement().isHighLevel() ? HIGH_LEVEL : CLASSIC;
        String requirementDescription = "<br><br>" + requirementVersion.getDescription();
        HashMap<String, Object> requirementMap = new HashMap<String, Object>();
        requirementMap.put(NAME, requirementVersion.getName());
        requirementMap.put(CRITICALITY, this.translationService.translate(aiPromptLanguage, CRITICALITY, criticalityKey));
        requirementMap.put(CATEGORY, this.translationService.translate(aiPromptLanguage, CATEGORY, categoryKey));
        requirementMap.put(NATURE, this.translationService.translate(aiPromptLanguage, NATURE, natureKey));
        requirementMap.put(DESCRIPTION, requirementDescription);
        HashMap<String, Object> variableValueByPlaceholder = new HashMap<String, Object>();
        variableValueByPlaceholder.put(REQUIREMENT, requirementMap);
        String reference = requirementVersion.getReference();
        if (reference != null && !reference.isBlank()) {
            variableValueByPlaceholder.put(REFERENCE, reference);
        }
        return variableValueByPlaceholder;
    }

    static {
        AiTestCaseGenerationViewServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ String getUserPromptTemplate_aroundBody0(PromptDto promptDto, JoinPoint joinPoint) {
        return promptDto.getUserPromptTemplate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AiTestCaseGenerationViewServiceImpl.java", AiTestCaseGenerationViewServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getUserPromptTemplate", "org.squashtest.tm.service.internal.display.dto.PromptDto", "", "", "", "java.lang.String"), 86);
    }
}

