/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.service.AiServices;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.promptset.Prompt;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerAuthenticationErrorException;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerNoCredentialsException;
import org.squashtest.tm.service.artificialintelligence.AiChatClientProvider;
import org.squashtest.tm.service.internal.artificialintelligence.AiAssistant;
import org.squashtest.tm.service.internal.artificialintelligence.AiChatClient;
import org.squashtest.tm.service.internal.artificialintelligence.AiServerSecurityService;
import org.squashtest.tm.service.internal.artificialintelligence.server.ChatModelProviderHelper;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerDto;
import org.squashtest.tm.service.internal.repository.PromptDao;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

@Service
@Transactional
public class AiChatClientProviderImpl
implements AiChatClientProvider {
    private final StoredCredentialsManager credentialsManager;
    private final PromptDao promptDao;
    private final AiServerSecurityService aiServerSecurityService;

    public AiChatClientProviderImpl(StoredCredentialsManager credentialsManager, PromptDao promptDao, AiServerSecurityService aiServerSecurityService) {
        this.credentialsManager = credentialsManager;
        this.promptDao = promptDao;
        this.aiServerSecurityService = aiServerSecurityService;
    }

    @Override
    public AiChatClient createAiChatClientAdminSide(AiServerDto aiServerDto, String systemPrompt) {
        return this.doCreateAiChatClientAdminSide(aiServerDto, systemPrompt);
    }

    private AiChatClient doCreateAiChatClientAdminSide(AiServerDto aiServerDto, String prompt) {
        TokenAuthCredentials credentials = (TokenAuthCredentials)this.credentialsManager.unsecuredFindAppLevelCredentials(aiServerDto.getId());
        if (credentials == null) {
            throw new AiServerNoCredentialsException(aiServerDto.getName());
        }
        return this.buildAiChatClient(aiServerDto, prompt, credentials);
    }

    @Override
    public AiChatClient createAiChatClientUserSide(AiServerDto aiServerDto, Long promptId) {
        Prompt prompt = (Prompt)this.promptDao.findById(promptId).orElseThrow(() -> new IllegalArgumentException("Prompt not found"));
        return this.doCreateAiChatClientUserSide(aiServerDto, prompt.getSystemPromptTemplate());
    }

    private AiChatClient doCreateAiChatClientUserSide(AiServerDto aiServerDto, String prompt) {
        TokenAuthCredentials credentials = (TokenAuthCredentials)this.credentialsManager.unsecuredFindAppLevelCredentials(aiServerDto.getId());
        if (credentials == null) {
            throw new AiServerAuthenticationErrorException();
        }
        return this.buildAiChatClient(aiServerDto, prompt, credentials);
    }

    private AiChatClient buildAiChatClient(AiServerDto aiServerDto, String prompt, TokenAuthCredentials credentials) {
        ChatModel model = ChatModelProviderHelper.buildChatModelForAiServer(aiServerDto, credentials);
        AiAssistant aiAssistant = (AiAssistant)AiServices.builder(AiAssistant.class).systemMessageProvider(chatMemoryId -> prompt).chatModel(model).build();
        return new AiChatClient(aiAssistant, this.aiServerSecurityService, aiServerDto);
    }
}

