/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd.robot;

import java.util.Arrays;
import java.util.List;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.service.internal.testcase.bdd.TextGridFormatter;
import org.squashtest.tm.service.internal.testcase.bdd.robot.RobotSyntaxHelpers;
import org.squashtest.tm.service.internal.testcase.bdd.robot.SectionBuilderHelpers;
import org.squashtest.tm.service.internal.testcase.bdd.robot.keywords.RetrieveDatasetKeywordBuilder;
import org.squashtest.tm.service.internal.testcase.bdd.robot.keywords.RetrieveDatatablesKeywordBuilder;
import org.squashtest.tm.service.internal.testcase.bdd.robot.keywords.RetrieveDocstringsKeywordBuilder;

public final class KeywordSectionBuilder {
    private static final String DOLLAR_PARAM_FORMAT = "$%s";
    private static final String IS_NOT_NONE_FORMAT = "%s is not None";
    private static final String IF_KEYWORD = "IF";
    private static final String END_KEYWORD = "END";
    private static final String RUN_KEYWORD_KEYWORD = "Run Keyword";
    private static final String GET_VARIABLE_VALUE_KEYWORD = "Get Variable Value";
    private static final String TEST_SETUP = "TEST_SETUP";
    private static final String TEST_SETUP_VALUE = "TEST_SETUP_VALUE";
    private static final String TEST_SPECIFIC_SETUP_FORMAT = "TEST_%s_SETUP";
    private static final String TEST_TEARDOWN = "TEST_TEARDOWN";
    private static final String TEST_TEARDOWN_VALUE = "TEST_TEARDOWN_VALUE";
    private static final String TEST_SPECIFIC_TEARDOWN_FORMAT = "TEST_%s_TEARDOWN";
    private static final List<String> SETUP_DOCUMENTATION_FORMATS = Arrays.asList("test setup", "You can define the %1$s variable with a keyword for setting up all your tests.", "You can define the %2$s variable with a keyword for setting up this specific test.", "If both are defined, %2$s will be run after %1$s.");
    private static final List<String> TEARDOWN_DOCUMENTATION_FORMATS = Arrays.asList("test teardown", "You can define the %1$s variable with a keyword for tearing down all your tests.", "You can define the %2$s variable with a keyword for tearing down this specific test.", "If both are defined, %1$s will be run after %2$s.");

    private KeywordSectionBuilder() {
        throw new UnsupportedOperationException("This class is not meant to be instantiated.");
    }

    public static String buildKeywordsSection(KeywordTestCase keywordTestCase) {
        Long testCaseId = keywordTestCase.getId();
        SectionBuilderHelpers.MultiLineStringBuilder stringBuilder = new SectionBuilderHelpers.MultiLineStringBuilder();
        stringBuilder.appendLine("*** Keywords ***").append(KeywordSectionBuilder.buildSetupDefinition(testCaseId)).append(KeywordSectionBuilder.buildTeardownDefinition(testCaseId)).append(RetrieveDatasetKeywordBuilder.buildRetrieveDataset(keywordTestCase)).append(RetrieveDatatablesKeywordBuilder.buildRetrieveDatatables(keywordTestCase)).append(RetrieveDocstringsKeywordBuilder.buildRetrieveDocstrings(keywordTestCase));
        return stringBuilder.toString();
    }

    private static String buildSetupDefinition(Long testCaseId) {
        SectionBuilderHelpers.MultiLineStringBuilder stringBuilder = new SectionBuilderHelpers.MultiLineStringBuilder().appendLine("Test Setup");
        String testSpecificSetup = String.format(TEST_SPECIFIC_SETUP_FORMAT, testCaseId);
        String testSpecificSetupValue = String.format("%s_VALUE", testSpecificSetup);
        KeywordSectionBuilder.appendSetupDocumentation(stringBuilder, testSpecificSetup);
        KeywordSectionBuilder.appendSetupValues(stringBuilder, testSpecificSetup, testSpecificSetupValue);
        KeywordSectionBuilder.appendSetupCalls(stringBuilder, testSpecificSetup, testSpecificSetupValue);
        return stringBuilder.appendNewLine().toString();
    }

    private static void appendSetupDocumentation(SectionBuilderHelpers.MultiLineStringBuilder stringBuilder, String testSpecificSetup) {
        stringBuilder.append(SectionBuilderHelpers.formatDocumentationSettingLines(SETUP_DOCUMENTATION_FORMATS.stream().map(f -> String.format(f, RobotSyntaxHelpers.scalarVariable(TEST_SETUP), RobotSyntaxHelpers.scalarVariable(testSpecificSetup))).toList())).appendNewLine();
    }

    private static void appendSetupValues(SectionBuilderHelpers.MultiLineStringBuilder stringBuilder, String testSpecificSetup, String testSpecificSetupValue) {
        stringBuilder.append(new TextGridFormatter().addRow(RobotSyntaxHelpers.assignment(RobotSyntaxHelpers.scalarVariable(TEST_SETUP_VALUE)), GET_VARIABLE_VALUE_KEYWORD, RobotSyntaxHelpers.scalarVariable(TEST_SETUP)).addRow(RobotSyntaxHelpers.assignment(RobotSyntaxHelpers.scalarVariable(testSpecificSetupValue)), GET_VARIABLE_VALUE_KEYWORD, RobotSyntaxHelpers.scalarVariable(testSpecificSetup)).format(TextGridFormatter.withRowPrefix("    ")));
    }

    private static void appendSetupCalls(SectionBuilderHelpers.MultiLineStringBuilder stringBuilder, String testSpecificSetup, String testSpecificSetupValue) {
        KeywordSectionBuilder.appendRunKeywordIfBlock(stringBuilder, TEST_SETUP_VALUE, TEST_SETUP);
        KeywordSectionBuilder.appendRunKeywordIfBlock(stringBuilder, testSpecificSetupValue, testSpecificSetup);
    }

    private static String buildTeardownDefinition(Long testCaseId) {
        SectionBuilderHelpers.MultiLineStringBuilder stringBuilder = new SectionBuilderHelpers.MultiLineStringBuilder().appendLine("Test Teardown");
        String testSpecificTeardown = String.format(TEST_SPECIFIC_TEARDOWN_FORMAT, testCaseId);
        String testSpecificTeardownValue = String.format("%s_VALUE", testSpecificTeardown);
        KeywordSectionBuilder.appendTeardownDocumentation(stringBuilder, testSpecificTeardown);
        KeywordSectionBuilder.appendTeardownValues(stringBuilder, testSpecificTeardown, testSpecificTeardownValue);
        KeywordSectionBuilder.appendTeardownCalls(stringBuilder, testSpecificTeardown, testSpecificTeardownValue);
        return stringBuilder.toString();
    }

    private static void appendTeardownDocumentation(SectionBuilderHelpers.MultiLineStringBuilder stringBuilder, String formattedTestSpecificTeardown) {
        stringBuilder.append(SectionBuilderHelpers.formatDocumentationSettingLines(TEARDOWN_DOCUMENTATION_FORMATS.stream().map(f -> String.format(f, RobotSyntaxHelpers.scalarVariable(TEST_TEARDOWN), RobotSyntaxHelpers.scalarVariable(formattedTestSpecificTeardown))).toList())).appendNewLine();
    }

    private static void appendTeardownValues(SectionBuilderHelpers.MultiLineStringBuilder stringBuilder, String testSpecificTeardown, String testSpecificTeardownValue) {
        stringBuilder.append(new TextGridFormatter().addRow(RobotSyntaxHelpers.assignment(RobotSyntaxHelpers.scalarVariable(testSpecificTeardownValue)), GET_VARIABLE_VALUE_KEYWORD, RobotSyntaxHelpers.scalarVariable(testSpecificTeardown)).addRow(RobotSyntaxHelpers.assignment(RobotSyntaxHelpers.scalarVariable(TEST_TEARDOWN_VALUE)), GET_VARIABLE_VALUE_KEYWORD, RobotSyntaxHelpers.scalarVariable(TEST_TEARDOWN)).format(TextGridFormatter.withRowPrefix("    ")));
    }

    private static void appendTeardownCalls(SectionBuilderHelpers.MultiLineStringBuilder stringBuilder, String testSpecificTeardown, String testSpecificTeardownValue) {
        KeywordSectionBuilder.appendRunKeywordIfBlock(stringBuilder, testSpecificTeardownValue, testSpecificTeardown);
        KeywordSectionBuilder.appendRunKeywordIfBlock(stringBuilder, TEST_TEARDOWN_VALUE, TEST_TEARDOWN);
    }

    private static void appendRunKeywordIfBlock(SectionBuilderHelpers.MultiLineStringBuilder stringBuilder, String condition, String keywordToRun) {
        stringBuilder.appendLine("    IF    " + String.format(IS_NOT_NONE_FORMAT, String.format(DOLLAR_PARAM_FORMAT, condition))).appendLine("        Run Keyword    " + RobotSyntaxHelpers.scalarVariable(keywordToRun)).appendLine("    END");
    }
}

