/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.service.annotation.EmptyCollectionGuard;

public interface TestPlanItemDao
extends JpaRepository<TestPlanItem, Long> {
    @Query(value="select itpi from TestPlanItem  itpi join fetch itpi.referencedTestCase where itpi.id = :id")
    public TestPlanItem findByIdWithTestCase(@Param(value="id") long var1);

    @EmptyCollectionGuard
    public List<TestPlanItem> findAllByIdIn(Collection<Long> var1);

    @EmptyCollectionGuard
    @Query(value="select item.id\nfrom Iteration i\njoin i.testPlan testPlan\njoin testPlan.testPlanItems item\nwhere item.id in :testPlanIds\norder by item.itemOrder")
    public List<Long> findAllByIdsOrderedByIterationTestPlan(@Param(value="testPlanIds") List<Long> var1);

    @Query(value="select item.id from Iteration it join it.testPlan.testPlanItems item where it.id = :id")
    public List<Long> findAllByIterationId(@Param(value="id") Long var1);

    @Query(value="select tpi\nfrom TestPlanItem tpi\nleft join fetch tpi.referencedTestCase\nleft join fetch tpi.referencedDataset\nleft join fetch tpi.executions\njoin fetch tpi.testPlan tp\nwhere tpi.id = :id\n")
    public TestPlanItem findForExecutionCreation(@Param(value="id") Long var1);

    @Query(value="    select tpi\n    from TestPlanItem tpi\n    left join fetch tpi.executions\n    where tpi.referencedTestCase.id in :testCaseIds\n")
    public List<TestPlanItem> findByReferencedTestCasesWithExecutions(@Param(value="testCaseIds") List<Long> var1);

    @Query(value="    select tpi\n    from TestPlanItem tpi\n    left join fetch tpi.executions\n    where tpi.id = :testPlanItemId\n")
    public TestPlanItem findByIdWithExecutions(@Param(value="testPlanItemId") long var1);

    @Query(value="    select tpi.id, exec.id\n    from TestPlanItem tpi\n    join tpi.executions exec\n    where exec.id in :executionIds\n    group by tpi.id, exec.id\n")
    public List<Object[]> getTestPlanItemAndExecutionPairs(@Param(value="executionIds") List<Long> var1);

    default public Map<Long, List<Long>> findTestPlanItemIdsByExecutionIds(List<Long> executionIds) {
        List<Object[]> results = this.getTestPlanItemAndExecutionPairs(executionIds);
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>();
        for (Object[] result : results) {
            Long tpiId = (Long)result[0];
            Long execId = (Long)result[1];
            resultMap.computeIfAbsent(tpiId, k -> new ArrayList()).add(execId);
        }
        return resultMap;
    }

    @Query(value="    select tpi\n    from TestPlanItem tpi\n    left join fetch tpi.testSuites\n    left join fetch tpi.exploratorySessionOverview\n    where tpi.exploratorySessionOverview.id = :exploratorySessionOverviewId\n")
    public TestPlanItem findByOverviewIdWithTestSuites(@Param(value="exploratorySessionOverviewId") Long var1);

    @Query(value="    select distinct tpi.id\n    from TestPlanItem tpi\n    inner join tpi.executions exec\n    where tpi.id in :testPlanItemIds and size(tpi.executions) > 0\n")
    public List<Long> filterItemsWithExecutions(@Param(value="testPlanItemIds") Collection<Long> var1);

    @Modifying
    @Query(value="    update TestPlanItem tpi\n    set tpi.executionStatus = 'READY'\n    where tpi.id in :ids\n")
    public void resetExecutionStatusForAllByIdIn(@Param(value="ids") Collection<Long> var1);

    @Modifying
    @Query(value="    update TestPlanItem t\n       set t.lastExecutedBy = null,\n           t.lastExecutedOn = null\n     where t.id in :ids\n")
    public void resetLastExecutionInfoForAllByIdIn(@Param(value="ids") List<Long> var1);
}

