/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.service.internal.repository.CustomExecutionDao;

public interface ExecutionDao
extends JpaRepository<Execution, Long>,
CustomExecutionDao {
    public static final String EXECUTION_ID = "executionId";

    @Query
    public List<ExecutionStep> findSteps(@Param(value="executionId") long var1);

    @Query
    public List<ActionTestStep> findOriginalSteps(@Param(value="executionId") long var1);

    @Query
    public List<Long> findOriginalStepIds(@Param(value="executionIds") List<Long> var1);

    @Query(value="select count(exSteps.executionStatus)\nfrom Execution as execution\njoin execution.steps as exSteps\nwhere execution.id =:execId and exSteps.executionStatus=:status")
    public long countStatus(@Param(value="execId") long var1, @Param(value="status") ExecutionStatus var3);

    @Query
    public List<Long> findExecutionIdsHavingStepStatus(@Param(value="projectId") Long var1, @Param(value="status") ExecutionStatus var2);

    @Modifying
    @Query(value="    update ExecutionStep es\n    set es.executionStatus = :newStatus\n    where es.executionStatus = :oldStatus\n    and es.id in (\n        select estep.id\n        from ExecutionStep estep\n        where estep.execution.testPlanItem.testPlan.parentIteration.campaign.project.id = :projectId\n    )\n")
    public void replaceExecutionStepStatus(@Param(value="projectId") long var1, @Param(value="oldStatus") ExecutionStatus var3, @Param(value="newStatus") ExecutionStatus var4);

    @Modifying
    @Query(value="    update TestPlanItem itpi\n    set itpi.executionStatus = :newStatus\n    where itpi.executionStatus = :oldStatus\n    and itpi.id in (\n        select itplanitem.id\n        from TestPlanItem itplanitem\n        where itplanitem.testPlan.parentIteration.campaign.project.id = :projectId\n    )\n")
    public void replaceTestPlanStatus(@Param(value="projectId") long var1, @Param(value="oldStatus") ExecutionStatus var3, @Param(value="newStatus") ExecutionStatus var4);

    @Query
    public long countSteps(@Param(value="executionId") long var1);
}

