/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.user;

import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.project.ProjectPermission;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.domain.users.UsersGroup;
import org.squashtest.tm.exception.user.ApiTokenFetchingException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.display.user.UserDisplayService;
import org.squashtest.tm.service.internal.display.dto.ProfileDto;
import org.squashtest.tm.service.internal.display.dto.ProjectPermissionDto;
import org.squashtest.tm.service.internal.display.dto.UserAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.UserAdminViewTeamDto;
import org.squashtest.tm.service.internal.display.dto.UsersGroupDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.administration.UserGrid;
import org.squashtest.tm.service.internal.display.grid.useraccount.PersonalApiTokenGrid;
import org.squashtest.tm.service.internal.dto.AccessPermission;
import org.squashtest.tm.service.internal.dto.DetailedUserDto;
import org.squashtest.tm.service.internal.repository.CustomTeamDao;
import org.squashtest.tm.service.internal.repository.CustomUserDao;
import org.squashtest.tm.service.internal.repository.ProfileDao;
import org.squashtest.tm.service.internal.repository.display.UserDisplayDao;
import org.squashtest.tm.service.internal.security.AuthenticationProviderContext;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.project.ProjectsPermissionFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.AuthenticatedUser;
import org.squashtest.tm.service.user.UserManagerService;

@Service
@Transactional
public class UserDisplayServiceImpl
implements UserDisplayService {
    private final DSLContext dsl;
    private final CustomUserDao userDao;
    private final UserDisplayDao userDisplayDao;
    private final UserManagerService userManagerService;
    private final ProjectsPermissionFinder permissionFinder;
    private final PermissionEvaluationService permissionEvaluationService;
    private final CustomTeamDao teamDao;
    private final AuthenticationProviderContext authenticationProviderContext;
    private final PluginFinderService pluginFinderService;
    private final ProfileDao profileDao;
    private final UltimateLicenseAvailabilityService ultimateLicenseService;

    @Inject
    public UserDisplayServiceImpl(DSLContext dsl, @Qualifier(value="userDaoImpl") CustomUserDao userDao, UserDisplayDao userDisplayDao, UserManagerService userManagerService, ProjectsPermissionFinder permissionFinder, PermissionEvaluationService permissionEvaluationService, @Qualifier(value="teamDaoImpl") CustomTeamDao teamDao, AuthenticationProviderContext authenticationProviderContext, PluginFinderService pluginFinderService, ProfileDao profileDao, UltimateLicenseAvailabilityService ultimateLicenseService) {
        this.dsl = dsl;
        this.userDao = userDao;
        this.userDisplayDao = userDisplayDao;
        this.userManagerService = userManagerService;
        this.permissionFinder = permissionFinder;
        this.permissionEvaluationService = permissionEvaluationService;
        this.teamDao = teamDao;
        this.authenticationProviderContext = authenticationProviderContext;
        this.pluginFinderService = pluginFinderService;
        this.profileDao = profileDao;
        this.ultimateLicenseService = ultimateLicenseService;
    }

    @Override
    public DetailedUserDto findCurrentUser() {
        DetailedUserDto detailedUserDto = this.fetchBasicUser();
        this.appendRoles(detailedUserDto);
        this.appendTeams(detailedUserDto);
        this.appendAccessPermissions(detailedUserDto);
        this.patchCanDeleteFromFront(detailedUserDto);
        return detailedUserDto;
    }

    private void appendAccessPermissions(DetailedUserDto detailedUserDto) {
        if (!detailedUserDto.isAdmin()) {
            Set<AccessPermission> accessPermissions = this.permissionEvaluationService.findAccessPermissions(detailedUserDto.getPartyIds());
            this.doAppendAccessPermissions(detailedUserDto, accessPermissions);
        }
    }

    private void doAppendAccessPermissions(DetailedUserDto detailedUserDto, Set<AccessPermission> accessPermissions) {
        if (accessPermissions.isEmpty()) {
            return;
        }
        if (accessPermissions.contains((Object)AccessPermission.WRITE_AS_AUTOMATION)) {
            detailedUserDto.setAutomationProgrammer(true);
        }
        if (accessPermissions.contains((Object)AccessPermission.WRITE_AS_FUNCTIONAL)) {
            detailedUserDto.setFunctionalTester(true);
        }
        if (accessPermissions.contains((Object)AccessPermission.MANAGE_PROJECT)) {
            detailedUserDto.setProjectManager(true);
            if (accessPermissions.contains((Object)AccessPermission.MANAGE_MILESTONE)) {
                detailedUserDto.setMilestoneManager(true);
            }
            if (accessPermissions.contains((Object)AccessPermission.MANAGE_PROJECT_CLEARANCE)) {
                detailedUserDto.setClearanceManager(true);
            }
        }
        if (accessPermissions.contains((Object)AccessPermission.READ)) {
            detailedUserDto.setHasAnyReadPermission(true);
        }
    }

    private void patchCanDeleteFromFront(DetailedUserDto detailedUserDto) {
        boolean isPremium = this.pluginFinderService.isPremiumPluginInstalled();
        if (!isPremium) {
            detailedUserDto.setCanDeleteFromFront(true);
        }
    }

    private void appendTeams(DetailedUserDto detailedUserDto) {
        List<Long> teamIds = this.teamDao.findTeamIds(detailedUserDto.getUserId());
        detailedUserDto.setTeamIds(teamIds);
    }

    private void appendRoles(DetailedUserDto detailedUserDto) {
        detailedUserDto.setAdmin(this.permissionEvaluationService.hasRole("ROLE_ADMIN"));
    }

    private DetailedUserDto fetchBasicUser() {
        String username = UserContextHolder.getUsername();
        DetailedUserDto detailedUserDto = (DetailedUserDto)this.dsl.select((SelectField)Tables.CORE_USER.PARTY_ID.as("USER_ID"), (SelectField)Tables.CORE_USER.FIRST_NAME, (SelectField)Tables.CORE_USER.LAST_NAME, (SelectField)Tables.CORE_USER.CAN_DELETE_FROM_FRONT).from((TableLike)Tables.CORE_USER).where(Tables.CORE_USER.LOGIN.eq((Object)username)).fetchOneInto(DetailedUserDto.class);
        detailedUserDto.setUsername(username);
        return detailedUserDto;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public GridResponse findAll(GridRequest request) {
        UserGrid userGrid = new UserGrid();
        return userGrid.getRows(request, this.dsl);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=User.class)
    public UserAdminViewDto getUserView(@Id long userId) {
        UserAdminViewDto user = this.userDisplayDao.getUserById(userId);
        this.appendUsersGroups(user);
        user.checkIsNotFromInfrastructureAdmin();
        this.appendProfiles(user);
        user.setProjectPermissions(this.getProjectPermissions(userId));
        user.setTeams(this.userDisplayDao.getTeamsByUser(userId));
        user.setCanManageLocalPassword(this.authenticationProviderContext.isInternalProviderEnabled());
        return user;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<ProjectPermissionDto> getProjectPermissions(Long userId) {
        return this.getDirectProjectPermissionsUnsecured(userId);
    }

    @Override
    public List<ProjectPermissionDto> getDirectProjectPermissionsUnsecured(Long userId) {
        List<ProjectPermission> projectPermissions = this.permissionFinder.findProjectPermissionByParty(userId);
        return this.getProjectPermissionDtos(projectPermissions);
    }

    @Override
    public List<ProjectPermissionDto> getAllProjectPermissionsUnsecured(String login) {
        List<ProjectPermission> projectPermissions = this.permissionFinder.findProjectPermissionByUserLogin(login);
        return this.getProjectPermissionDtos(projectPermissions);
    }

    private List<ProjectPermissionDto> getProjectPermissionDtos(List<ProjectPermission> projectPermissions) {
        return projectPermissions.stream().map(projectPermission -> {
            ProjectPermissionDto dto = new ProjectPermissionDto();
            dto.setProjectId(projectPermission.getProject().getId());
            dto.setProjectName(projectPermission.getProject().getName());
            dto.setPermissionGroup(projectPermission.getPermissionGroup());
            return dto;
        }).toList();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<UserAdminViewTeamDto> getAssociatedTeams(Long userId) {
        return this.userDisplayDao.getTeamsByUser(userId);
    }

    @Override
    public List<NamedReference> getUsersWhoCanAccessProjects(List<Long> projectIds) {
        List<Long> partyIds = this.userDisplayDao.findPartyIdsCanAccessProject(projectIds);
        List<User> allAdmins = this.userDao.findAllAdmin();
        Set allIds = allAdmins.stream().map(Party::getId).collect(Collectors.toSet());
        allIds.addAll(partyIds);
        return this.userDisplayDao.findUserLoginsByPartyIds(new ArrayList<Long>(allIds));
    }

    private void appendUsersGroups(UserAdminViewDto user) {
        List<UsersGroup> usersGroups = this.userManagerService.findUsersGroupsOrderedByQualifiedName(UsersGroup.MODIFIABLE_USER_GROUPS);
        ArrayList<UsersGroupDto> usersGroupDto = new ArrayList<UsersGroupDto>();
        usersGroups.forEach(group -> {
            UsersGroupDto groupDto = new UsersGroupDto();
            groupDto.setQualifiedName(group.getQualifiedName());
            usersGroupDto.add(groupDto);
        });
        user.setUsersGroups(usersGroupDto);
    }

    @Override
    public GridResponse findTestAutoServerApiTokens(long userId, GridRequest request) {
        AuthenticatedUser targetUser = this.userManagerService.findUserById(userId);
        if ("squashtest.authz.group.tm.TechnicalAccount".equals(targetUser.getGroup().getQualifiedName())) {
            return new PersonalApiTokenGrid(userId).getRows(request, this.dsl);
        }
        throw new ApiTokenFetchingException("Cannot access the personal API tokens of a user.");
    }

    private void appendProfiles(UserAdminViewDto user) {
        List profiles = this.profileDao.findAll();
        boolean isUltimateAvailable = this.ultimateLicenseService.isAvailable();
        ArrayList<ProfileDto> profileDtos = new ArrayList<ProfileDto>();
        profiles.forEach(profile -> {
            ProfileDto profileDto = new ProfileDto(profile.getId(), profile.getQualifiedName(), profile.isActive());
            if (profileDto.isActive() && (isUltimateAvailable || profileDto.isSystem())) {
                profileDtos.add(profileDto);
            }
        });
        user.setProfiles(profileDtos);
    }
}

