/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.filters;

import java.util.List;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.filters.GridFilterConditionBuilder;

public class InConditionBuilder
implements GridFilterConditionBuilder {
    public static final String SQUASH_TM_NULL_VALUE_IN_FILTERS = "SQUASH_TM_2_0_FRONT_END_NULL_VALUE_IN_LIST_FILTERS_TOKEN-885a4cf1-063f-4062-9a15-9b6fda0308e0";
    private final Field<?> field;
    private final GridFilterValue gridFilterValue;

    InConditionBuilder(Field<?> field, GridFilterValue gridFilterValue) {
        Objects.requireNonNull(field);
        Objects.requireNonNull(gridFilterValue);
        this.field = field;
        this.gridFilterValue = gridFilterValue;
    }

    @Override
    public Condition build() {
        List<String> values = this.gridFilterValue.getValues();
        if (values.isEmpty()) {
            return DSL.val((int)1).eq((Object)1);
        }
        boolean hasEmptyFilter = values.stream().anyMatch(SQUASH_TM_NULL_VALUE_IN_FILTERS::equals);
        boolean hasValue = values.stream().anyMatch(v -> !Objects.equals(SQUASH_TM_NULL_VALUE_IN_FILTERS, v));
        Condition condition = hasEmptyFilter && hasValue ? this.field.cast(String.class).in(values).or(this.field.isNull()) : (!hasEmptyFilter && hasValue ? this.field.cast(String.class).in(values) : this.field.isNull());
        return condition;
    }
}

