/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customfield;

import jakarta.inject.Inject;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.customfield.CustomFieldValueChangerService;
import org.squashtest.tm.service.internal.repository.BoundEntityDao;
import org.squashtest.tm.service.internal.repository.CustomFieldValueDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.plugin.ConfigurablePluginManager;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class PrivateCustomFieldValueChangerServiceImpl
implements CustomFieldValueChangerService {
    @Inject
    private CustomFieldValueDao customFieldValueDao;
    @Inject
    private ConfigurablePluginManager configurablePluginManager;
    @Inject
    private RequirementVersionDao requirementVersionDao;
    @Inject
    private BoundEntityDao boundEntityDao;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private AuditModificationService auditModificationService;
    @Inject
    private SprintDisplayDao sprintDisplayDao;

    @Override
    public void changeValue(long customFieldValueId, RawValue newValue) {
        CustomFieldValue changedValue = (CustomFieldValue)this.customFieldValueDao.getReferenceById(customFieldValueId);
        BoundEntity boundEntity = this.boundEntityDao.findBoundEntity(changedValue);
        this.checkIfCufIsSynchronized(boundEntity.getBoundEntityType(), boundEntity.getBoundEntityId(), changedValue.getBinding().getCustomField().getCode());
        this.checkParentSprintStatus(boundEntity);
        if (!this.permissionService.hasMoreThanRead(boundEntity)) {
            throw new AccessDeniedException("access is denied");
        }
        newValue.setValueFor(changedValue);
        this.auditModificationService.updateRelatedToCustomFieldAuditableEntity(boundEntity);
    }

    @Override
    public void checkIfCufIsSynchronized(BindableEntity entityType, Long entityId, String customFieldCode) {
        if (BindableEntity.REQUIREMENT_VERSION.equals((Object)entityType)) {
            RequirementVersion reqVersion = (RequirementVersion)this.requirementVersionDao.getReferenceById(entityId);
            this.configurablePluginManager.checkIfFieldIsSynchronized(reqVersion, customFieldCode);
        }
    }

    private void checkParentSprintStatus(BoundEntity boundEntity) {
        SprintStatus sprintStatus;
        if (BindableEntity.EXECUTION.equals((Object)boundEntity.getBoundEntityType()) ? SprintStatus.CLOSED.equals((Object)(sprintStatus = this.sprintDisplayDao.getSprintStatusByExecutionId(boundEntity.getBoundEntityId()))) : BindableEntity.EXECUTION_STEP.equals((Object)boundEntity.getBoundEntityType()) && SprintStatus.CLOSED.equals((Object)(sprintStatus = this.sprintDisplayDao.getSprintStatusByExecutionStepId(boundEntity.getBoundEntityId())))) {
            throw new SprintClosedException();
        }
    }
}

