/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export.dao;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Record5;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectHavingStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.campaign.export.dao.CampaignExportFullDao;
import org.squashtest.tm.service.internal.campaign.export.dao.AbstractCampaignExportDao;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

@Repository
public class CampaignExportFullDaoImpl
extends AbstractCampaignExportDao
implements CampaignExportFullDao {
    private final Field<Long> testCaseHolderIdField = DSL.field((Name)DSL.name((String)"test_case_holder_id"), Long.class);
    private final Field<String> stepPathField = DSL.field((String)"step_path", String.class);

    public CampaignExportFullDaoImpl(DSLContext dsl) {
        super(dsl);
    }

    @Override
    public Map<BindableEntity, List<String>> getCufHeaderQuery(Long campaignId, List<BindableEntity> bindableEntities) {
        return super.getCufHeaderQuery(campaignId, bindableEntities);
    }

    @Override
    public Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> getCufProcessors(Long campaignId) {
        return Map.of(BindableEntity.CAMPAIGN, this.getCufProcessor(this.getCampaignCufQuery(campaignId)), BindableEntity.ITERATION, this.getCufProcessor(this.getIterationCufQuery(campaignId)), BindableEntity.TEST_CASE, this.getCufProcessor(this.getTestCaseCufQuery(campaignId)), BindableEntity.EXECUTION, this.getCufProcessor(this.getExecutionCufQuery(campaignId)), BindableEntity.EXECUTION_STEP, this.getCufProcessor(this.getExecutionStepCufQuery(campaignId)));
    }

    @Override
    public ResultQuery<Record> getQuery(Long campaignId) {
        CommonTableExpression<? extends Record> cte = this.getCampaignExportCte(campaignId);
        Table<Record2<Long, Integer>> executionCountsTable = this.getExecutionCountsTable(cte);
        Table<Record2<Long, Integer>> testCaseCoverageCountsTable = this.getTestCaseCoverageCountsTable(cte);
        Table<Record2<Long, Integer>> testStepCoverageCountsTable = this.getTestStepCoverageCountsTable(cte);
        Table<Record2<Long, Integer>> executionIssueCountsTable = this.getExecutionIssueCountsTable(cte);
        Table<Record2<Long, Integer>> executionStepIssueCountsTable = this.getExecutionStepIssueCountsTable(cte);
        Table<Record2<Long, String>> testCaseMilestoneTable = this.getTestCaseMilestone(cte);
        Table<Record2<Long, String>> testSuiteTable = this.getTestSuiteNames(campaignId);
        return this.dsl.with(new CommonTableExpression[]{cte}).select(new SelectFieldOrAsterisk[]{Tables.CAMPAIGN.CLN_ID, Tables.CAMPAIGN.SCHEDULED_START_DATE, Tables.CAMPAIGN.SCHEDULED_END_DATE, Tables.CAMPAIGN.ACTUAL_START_DATE, Tables.CAMPAIGN.ACTUAL_END_DATE, Tables.MILESTONE.LABEL, Tables.ITERATION.ITERATION_ID, cte.field((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER), Tables.ITERATION.NAME, Tables.ITERATION.SCHEDULED_START_DATE, Tables.ITERATION.SCHEDULED_END_DATE, Tables.ITERATION.ACTUAL_START_DATE, Tables.ITERATION.ACTUAL_END_DATE, testSuiteTable.field(AbstractCampaignExportDao.SUITE_NAMES), Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_PLAN_ITEM.ITEM_ORDER, Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON, Tables.CORE_USER.LOGIN, Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_NODE.NAME, Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, Tables.TEST_CASE.REFERENCE, Tables.TEST_CASE.TC_STATUS, Tables.TEST_CASE.IMPORTANCE, AbstractCampaignExportDao.TC_NATURE_TABLE.CODE, AbstractCampaignExportDao.TC_TYPE_TABLE.CODE, Tables.DATASET.NAME, DSL.coalesce((Object)testCaseCoverageCountsTable.field(AbstractCampaignExportDao.TC_COVERAGE_COUNT), (Object[])new Serializable[]{Integer.valueOf(0)}).as(AbstractCampaignExportDao.TC_COVERAGE_COUNT), DSL.coalesce((Field)testCaseMilestoneTable.field(AbstractCampaignExportDao.TC_MILESTONE_LABELS), (Object)"").as(AbstractCampaignExportDao.TC_MILESTONE_LABELS), Objects.requireNonNull(cte.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)).as((Field)Tables.TEST_CASE_STEPS.STEP_ID), Tables.PROJECT.NAME, Objects.requireNonNull(cte.field((Field)Tables.EXECUTION.EXECUTION_ID)).as((Field)Tables.EXECUTION.EXECUTION_ID), DSL.coalesce((Object)executionCountsTable.field(AbstractCampaignExportDao.EXECUTION_COUNT), (Object[])new Serializable[]{Integer.valueOf(0)}).as(AbstractCampaignExportDao.EXECUTION_COUNT), DSL.coalesce((Object)executionIssueCountsTable.field(AbstractCampaignExportDao.EXECUTION_ISSUE_COUNT), (Object[])new Serializable[]{Integer.valueOf(0)}).as(AbstractCampaignExportDao.EXECUTION_ISSUE_COUNT), Tables.EXECUTION_STEP.EXECUTION_STEP_ID, Tables.EXECUTION_STEP.EXECUTION_STATUS, Tables.EXECUTION_STEP.LAST_EXECUTED_ON, Tables.EXECUTION_STEP.LAST_EXECUTED_BY, DSL.coalesce((Object)testStepCoverageCountsTable.field(AbstractCampaignExportDao.TS_COVERAGE_COUNT), (Object[])new Serializable[]{Integer.valueOf(0)}).as(AbstractCampaignExportDao.TS_COVERAGE_COUNT), DSL.coalesce((Object)executionStepIssueCountsTable.field(AbstractCampaignExportDao.EXECUTION_STEP_ISSUE_COUNT), (Object[])new Serializable[]{Integer.valueOf(0)}).as(AbstractCampaignExportDao.EXECUTION_STEP_ISSUE_COUNT), Tables.EXECUTION_STEP.COMMENT}).from(cte).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN.CLN_ID.eq(cte.field((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID))).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq(cte.field((Field)Tables.ITERATION.ITERATION_ID))).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(cte.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID))).leftJoin((TableLike)Tables.DATASET).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.TEST_PLAN_ITEM.DATASET_ID).and(Tables.DATASET.TEST_CASE_ID.eq(cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)))).leftJoin((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.LOGIN.eq((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_BY)).leftJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.eq(cte.field((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID))).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID)).leftJoin(testSuiteTable).on(Objects.requireNonNull(testSuiteTable.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).eq(cte.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID))).leftJoin(executionCountsTable).on(Objects.requireNonNull(executionCountsTable.field((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).eq(cte.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID))).leftJoin(executionIssueCountsTable).on(Objects.requireNonNull(executionIssueCountsTable.field((Field)Tables.EXECUTION.EXECUTION_ID)).eq(cte.field((Field)Tables.EXECUTION.EXECUTION_ID))).leftJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq(cte.field((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID))).leftJoin(executionStepIssueCountsTable).on(Objects.requireNonNull(executionStepIssueCountsTable.field((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).eq(cte.field((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID))).leftJoin(testStepCoverageCountsTable).on(Objects.requireNonNull(testStepCoverageCountsTable.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)).eq(cte.field((Field)Tables.TEST_CASE_STEPS.STEP_ID))).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq(cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).leftJoin((TableLike)AbstractCampaignExportDao.TC_NATURE_TABLE).on(AbstractCampaignExportDao.TC_NATURE_TABLE.ITEM_ID.eq((Field)Tables.TEST_CASE.TC_NATURE)).leftJoin((TableLike)AbstractCampaignExportDao.TC_TYPE_TABLE).on(AbstractCampaignExportDao.TC_TYPE_TABLE.ITEM_ID.eq((Field)Tables.TEST_CASE.TC_TYPE)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin(testCaseMilestoneTable).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(testCaseMilestoneTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).leftJoin(testCaseCoverageCountsTable).on(Objects.requireNonNull(testCaseCoverageCountsTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).eq(cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).orderBy((OrderField)cte.field((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER), (OrderField)Tables.TEST_PLAN_ITEM.ITEM_ORDER, (OrderField)cte.field((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER), (OrderField)cte.field(this.stepPathField)).fetchSize(AbstractCampaignExportDao.BATCH_SIZE.intValue());
    }

    private Table<? extends Record> getTestCaseWithStep(Long campaignId) {
        String cteName = "test_case_cte";
        Field holderIdField = DSL.field((Name)DSL.name((String[])new String[]{cteName, "holder_id"}), Long.class);
        Field calledTcField = DSL.field((Name)DSL.name((String[])new String[]{cteName, "called_tc"}), Long.class);
        Field depthField = DSL.field((Name)DSL.name((String[])new String[]{cteName, "depth"}), Integer.class);
        Field callTestStepId = DSL.field((Name)DSL.name((String[])new String[]{cteName, "call_test_step_id"}), Long.class);
        CommonTableExpression cte = DSL.name((String)cteName).fields(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.getName(), holderIdField.getName(), Tables.TEST_CASE_STEPS.STEP_ID.getName(), this.stepPathField.getName(), depthField.getName(), callTestStepId.getName(), calledTcField.getName()).as((ResultQuery)DSL.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as(holderIdField), (SelectField)Tables.TEST_CASE_STEPS.STEP_ID, (SelectField)DSL.lpad((Field)DSL.coalesce((Field)Tables.TEST_CASE_STEPS.STEP_ORDER, (Object)0).cast(String.class), (int)2, (char)'0').cast(SQLDataType.VARCHAR((int)128)).as(this.stepPathField), (SelectField)DSL.val((int)0).as(depthField), (SelectField)Tables.CALL_TEST_STEP.TEST_STEP_ID.as(callTestStepId), (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.as(calledTcField)).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).leftJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).and(ConditionsConstants.TCLN_NOT_IN_BIN).and(Tables.EXECUTION.TEST_PLAN_ITEM_ID.isNull()).unionAll((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{cteName, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.getName()}), Long.class), (SelectField)holderIdField, (SelectField)Tables.TEST_CASE_STEPS.STEP_ID, (SelectField)DSL.concat((Field[])new Field[]{this.stepPathField, DSL.val((String)"."), DSL.lpad((Field)DSL.coalesce((Field)Tables.TEST_CASE_STEPS.STEP_ORDER, (Object)0).cast(String.class), (int)2, (char)'0')}).cast(SQLDataType.VARCHAR((int)128)).as(this.stepPathField), (SelectField)depthField.add((Number)1).as(depthField), (SelectField)Tables.CALL_TEST_STEP.TEST_STEP_ID, (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.as(calledTcField)).from(DSL.name((String)cteName)).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq(calledTcField)).leftJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).where(DSL.field((Name)DSL.name((String[])new String[]{cteName, callTestStepId.getName()}), Long.class).isNotNull()).and(depthField.lt((Object)50))));
        return this.dsl.withRecursive(new CommonTableExpression[]{cte}).select((SelectField)Objects.requireNonNull(cte.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).as((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID), (SelectField)holderIdField.as(this.testCaseHolderIdField), (SelectField)Objects.requireNonNull(cte.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)).as((Field)Tables.TEST_CASE_STEPS.STEP_ID), this.stepPathField).from((TableLike)cte).where(callTestStepId.isNull()).asTable();
    }

    private CommonTableExpression<? extends Record> getCampaignExportCte(Long campaignId) {
        Table<? extends Record> testCaseWithStepTable = this.getTestCaseWithStep(campaignId);
        Table<Record5<Integer, Long, Integer, Long, Integer>> lastExecutionTable = this.getLastestExecution(campaignId);
        return DSL.name((String)"cte").fields(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.getName(), Tables.CAMPAIGN_ITERATION.ITERATION_ORDER.getName(), Tables.ITERATION.ITERATION_ID.getName(), Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.getName(), Tables.EXECUTION.EXECUTION_ID.getName(), Tables.EXECUTION_STEP.EXECUTION_STEP_ID.getName(), Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER.getName(), Tables.TEST_CASE_STEPS.STEP_ID.getName(), Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.getName(), ConditionsConstants.TCLN_NOT_IN_BIN.getName(), this.stepPathField.getName()).as((ResultQuery)DSL.select((SelectField)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID, (SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER, (SelectField)Tables.ITERATION.ITERATION_ID, (SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)lastExecutionTable.field((Field)Tables.EXECUTION.EXECUTION_ID), (SelectField)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, (SelectField)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER, (SelectField)DSL.when((Condition)ConditionsConstants.TCLN_NOT_IN_BIN, (Field)Tables.TEST_CASE_STEPS.STEP_ID).otherwise(null).as((Field)Tables.TEST_CASE_STEPS.STEP_ID), (SelectField)DSL.when((Condition)ConditionsConstants.TCLN_NOT_IN_BIN, (Field)Tables.TEST_PLAN_ITEM.TCLN_ID).otherwise(null).as((Field)Tables.TEST_PLAN_ITEM.TCLN_ID), (SelectField)ConditionsConstants.TCLN_NOT_IN_BIN, (SelectField)DSL.val(null).as(this.stepPathField)).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join(lastExecutionTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(lastExecutionTable.field((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).and(AbstractCampaignExportDao.EXECUTION_POSITION.eq((Object)1))).leftJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq(lastExecutionTable.field((Field)Tables.EXECUTION.EXECUTION_ID))).leftJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)).leftJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.EXECUTION_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).unionAll((Select)DSL.select((SelectField)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID, (SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER, (SelectField)Tables.ITERATION.ITERATION_ID, (SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)DSL.val(null).as((Field)Tables.EXECUTION.EXECUTION_ID), (SelectField)DSL.val(null).as((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID), (SelectField)DSL.val(null).as((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER), (SelectField)testCaseWithStepTable.field((Field)Tables.TEST_CASE_STEPS.STEP_ID), (SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID, (SelectField)DSL.val((boolean)true), (SelectField)testCaseWithStepTable.field(this.stepPathField)).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join(testCaseWithStepTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(testCaseWithStepTable.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)))));
    }

    private Table<Record2<Long, Integer>> getExecutionCountsTable(CommonTableExpression<? extends Record> cte) {
        return DSL.select((SelectField)Objects.requireNonNull(cte.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).as((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID), (SelectField)DSL.countDistinct((Field)Tables.EXECUTION.EXECUTION_ID).as(AbstractCampaignExportDao.EXECUTION_COUNT)).from(cte).join((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq(cte.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID))).where(Objects.requireNonNull(cte.field((Field)Tables.EXECUTION.EXECUTION_ID)).isNotNull()).and(Objects.requireNonNull(cte.field((Field)ConditionsConstants.TCLN_NOT_IN_BIN)).isTrue()).groupBy(new GroupField[]{cte.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)}).asTable();
    }

    private Table<Record2<Long, Integer>> getTestCaseCoverageCountsTable(CommonTableExpression<? extends Record> cte) {
        SelectHavingStep testCaseTable = DSL.selectDistinct((SelectField)cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).from(cte).where(Objects.requireNonNull(cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).isNotNull()).and(Objects.requireNonNull(cte.field((Field)ConditionsConstants.TCLN_NOT_IN_BIN)).isTrue()).groupBy(new GroupField[]{cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)});
        return DSL.select((SelectField)Objects.requireNonNull(testCaseTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).as((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID), (SelectField)DSL.count((Field)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID).as(AbstractCampaignExportDao.TC_COVERAGE_COUNT)).from((TableLike)testCaseTable).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq(testCaseTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).groupBy(new GroupField[]{testCaseTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)}).asTable();
    }

    private Table<Record2<Long, Integer>> getTestStepCoverageCountsTable(CommonTableExpression<? extends Record> cte) {
        SelectHavingStep testStepTable = DSL.select((SelectField)cte.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)).from(cte).where(Objects.requireNonNull(cte.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)).isNotNull()).and(Objects.requireNonNull(cte.field((Field)ConditionsConstants.TCLN_NOT_IN_BIN)).isTrue()).groupBy(new GroupField[]{cte.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)});
        return this.dsl.select((SelectField)Objects.requireNonNull(testStepTable.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)).as((Field)Tables.TEST_CASE_STEPS.STEP_ID), (SelectField)DSL.count((Field)Tables.VERIFYING_STEPS.REQUIREMENT_VERSION_COVERAGE_ID).as(AbstractCampaignExportDao.TS_COVERAGE_COUNT)).from((TableLike)testStepTable).join((TableLike)Tables.VERIFYING_STEPS).on(Tables.VERIFYING_STEPS.TEST_STEP_ID.eq(testStepTable.field((Field)Tables.TEST_CASE_STEPS.STEP_ID))).groupBy(new GroupField[]{testStepTable.field((Field)Tables.TEST_CASE_STEPS.STEP_ID)}).asTable();
    }

    private Table<Record2<Long, Integer>> getExecutionIssueCountsTable(CommonTableExpression<? extends Record> cte) {
        SelectHavingStep executionTable = DSL.select((SelectField)cte.field((Field)Tables.EXECUTION.EXECUTION_ID)).from(cte).where(Objects.requireNonNull(cte.field((Field)Tables.EXECUTION.EXECUTION_ID)).isNotNull()).groupBy(new GroupField[]{cte.field((Field)Tables.EXECUTION.EXECUTION_ID)});
        return this.dsl.select((SelectField)Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.as((Field)Tables.EXECUTION.EXECUTION_ID), (SelectField)DSL.count((Field)Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID).as(AbstractCampaignExportDao.EXECUTION_ISSUE_COUNT)).from((TableLike)executionTable).join((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq(executionTable.field((Field)Tables.EXECUTION.EXECUTION_ID))).groupBy(new GroupField[]{Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID}).asTable();
    }

    private Table<Record2<Long, Integer>> getExecutionStepIssueCountsTable(CommonTableExpression<? extends Record> cte) {
        return this.dsl.select((SelectField)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, (SelectField)DSL.count((Field)Tables.ISSUE.ISSUE_ID).as(AbstractCampaignExportDao.EXECUTION_STEP_ISSUE_COUNT)).from(cte).join((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq(cte.field((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID))).join((TableLike)Tables.ISSUE).on(Tables.ISSUE.ISSUE_LIST_ID.eq((Field)Tables.EXECUTION_STEP.ISSUE_LIST_ID)).where(Objects.requireNonNull(cte.field((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).isNotNull()).groupBy(new GroupField[]{Tables.EXECUTION_STEP.EXECUTION_STEP_ID}).asTable();
    }

    private Table<Record2<Long, String>> getTestCaseMilestone(CommonTableExpression<? extends Record> cte) {
        SelectHavingStep testCaseTable = DSL.select((SelectField)cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).from(cte).where(Objects.requireNonNull(cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).isNotNull()).and(Objects.requireNonNull(cte.field((Field)ConditionsConstants.TCLN_NOT_IN_BIN)).isTrue()).groupBy(new GroupField[]{cte.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)});
        return this.dsl.select((SelectField)Objects.requireNonNull(testCaseTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).as((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID), (SelectField)DSL.groupConcat((Field)Tables.MILESTONE.LABEL).separator("|").as(AbstractCampaignExportDao.TC_MILESTONE_LABELS)).from((TableLike)testCaseTable).join((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq(testCaseTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID))).join((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).groupBy(new GroupField[]{testCaseTable.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)}).asTable();
    }

    private Table<Record2<Long, String>> getTestSuiteNames(Long campaignId) {
        return this.dsl.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)DSL.groupConcat((Field)Tables.TEST_SUITE.NAME).separator(",").as(AbstractCampaignExportDao.SUITE_NAMES)).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).join((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).groupBy(new GroupField[]{Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID}).asTable();
    }
}

