/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportHeader;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportMode;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportRows;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.dto.FileDto;
import org.squashtest.tm.service.internal.filemanagement.writer.CSVWriter;
import org.squashtest.tm.service.internal.filemanagement.writer.WriterFactory;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;

public abstract class AbstractCampaignExport {
    protected final FeatureManager featureManager;
    private final WriterFactory writerFactory;

    protected AbstractCampaignExport(FeatureManager featureManager, WriterFactory writerFactory) {
        this.featureManager = featureManager;
        this.writerFactory = writerFactory;
    }

    protected boolean milestoneIsEnabled() {
        return this.featureManager.isEnabled(FeatureManager.Feature.MILESTONE);
    }

    public void doExport(Appendable appendable, Long campaignId, CampaignExportMode exportMode) {
        boolean milestonesEnabled = this.milestoneIsEnabled();
        CampaignExportRows campaignExportRows = new CampaignExportRows(exportMode, milestonesEnabled);
        this.addCufHeader(campaignId, campaignExportRows);
        CalculateOrder calculateOrder = new CalculateOrder();
        Throwable throwable = null;
        Object var8_9 = null;
        try (CSVWriter csvWriter = this.writerFactory.createDefaultCSVWriter(appendable);){
            csvWriter.write(campaignExportRows.getHeaders());
            this.processExport(campaignId, campaignExportRows, milestonesEnabled, calculateOrder, csvWriter);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addCufHeader(Long campaignId, CampaignExportRows campaignExportRows) {
        List<BindableEntity> bindableEntities = this.getBindableEntities();
        if (bindableEntities.isEmpty()) {
            return;
        }
        Map<BindableEntity, List<String>> cufCodesByBindableEntity = this.getCufHeader(campaignId, bindableEntities);
        campaignExportRows.addCufHeaders(cufCodesByBindableEntity);
    }

    protected void addCufValue(Record record, Field<Long> idField, CampaignExportRows campaignExportRows, BindableEntity bindableEntity, Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessor, Map<BindableEntity, List<CustomFieldValueDto>> cufStorage) {
        Long id = (Long)record.get(idField);
        if (Objects.isNull(id) || !cufProcessor.containsKey(bindableEntity)) {
            return;
        }
        List<CustomFieldValueDto> cufValueStorage = cufStorage.get(bindableEntity);
        if (cufValueStorage.isEmpty()) {
            List<CustomFieldValueDto> cufValues = cufProcessor.get(bindableEntity).getSubElements(id, false);
            campaignExportRows.addValue(CampaignExportHeader.fromBindableEntity(bindableEntity), cufValues);
            cufStorage.put(bindableEntity, cufValues);
        } else if (this.isSameId(id, cufValueStorage)) {
            campaignExportRows.addValue(CampaignExportHeader.fromBindableEntity(bindableEntity), cufValueStorage);
        } else {
            cufValueStorage.clear();
            List<CustomFieldValueDto> cufValues = cufProcessor.get(bindableEntity).getSubElements(id, false);
            campaignExportRows.addValue(CampaignExportHeader.fromBindableEntity(bindableEntity), cufValues);
            cufStorage.replace(bindableEntity, cufValues);
        }
    }

    private boolean isSameId(Long id, List<CustomFieldValueDto> customFieldValueDtos) {
        return id.equals(customFieldValueDtos.getFirst().getBoundEntityId());
    }

    private void processExport(Long campaignId, CampaignExportRows campaignExportRows, boolean milestonesEnabled, CalculateOrder calculateOrder, CSVWriter csvWriter) {
        Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessors = null;
        Map<BindableEntity, List> cufStorage = this.getBindableEntities().stream().collect(Collectors.toMap(bindableEntity -> bindableEntity, bindableEntity -> new ArrayList()));
        try {
            Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> finalCufProcessors = cufProcessors = this.getCufProcessors(campaignId);
            this.getQuery(campaignId).fetchStream().forEach(record -> {
                Map<String, String> row = this.exportData((Record)record, campaignExportRows, milestonesEnabled, calculateOrder, finalCufProcessors, (Map<BindableEntity, List<CustomFieldValueDto>>)cufStorage);
                csvWriter.write(row.values());
            });
        }
        finally {
            if (cufProcessors != null) {
                cufProcessors.values().forEach(SubElementRecordProcessor::close);
            }
        }
    }

    protected abstract Map<BindableEntity, List<String>> getCufHeader(Long var1, List<BindableEntity> var2);

    protected abstract ResultQuery<Record> getQuery(Long var1);

    protected abstract List<BindableEntity> getBindableEntities();

    protected abstract Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> getCufProcessors(Long var1);

    protected abstract Map<String, String> exportData(Record var1, CampaignExportRows var2, boolean var3, CalculateOrder var4, Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> var5, Map<BindableEntity, List<CustomFieldValueDto>> var6);

    public FileDto getExportFile(CampaignExportMode exportMode, String campaignName) {
        try {
            String fileName = AbstractCampaignExport.buildFileName(exportMode, campaignName);
            String extension = ".csv";
            File file = File.createTempFile(fileName, extension);
            file.deleteOnExit();
            return new FileDto(fileName, file, extension);
        }
        catch (IOException e) {
            throw new ActionException("campaign export : I/O failure while creating the temporary file", (Throwable)e);
        }
    }

    private static String buildFileName(CampaignExportMode exportMode, String campaignName) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String encodedCampaignName = URLEncoder.encode(campaignName, StandardCharsets.UTF_8).replace(" ", "_");
        return String.format("EXPORT_CPG_%s_%s_%s", exportMode.getCode(), encodedCampaignName, sdf.format(new Date()));
    }

    protected static class CalculateOrder {
        private Long stepOrder = 1L;
        private Long tpiId;

        protected CalculateOrder() {
        }

        public Long getNextStep(Long tpiId) {
            if (Objects.isNull(tpiId) || !tpiId.equals(this.tpiId)) {
                this.setTpiId(tpiId);
                this.resetStepOrder();
            }
            Long l = this.stepOrder;
            this.stepOrder = l + 1L;
            return l;
        }

        private void setTpiId(Long tpiId) {
            this.tpiId = tpiId;
        }

        private void resetStepOrder() {
            this.stepOrder = 1L;
        }
    }
}

