/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.security.acls.domain;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.ObjectNotFoundException;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.AclPrimaryObject;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

public class AnnotatedPropertyObjectIdentityRetrievalStrategy
implements ObjectIdentityRetrievalStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotatedPropertyObjectIdentityRetrievalStrategy.class);
    private Map<Class<?>, Method> identityMethodMap = new ConcurrentHashMap();

    public ObjectIdentity getObjectIdentity(Object domainObject) {
        Object identityHolder;
        Class<?> candidateClass = domainObject.getClass();
        Method targetProperty = this.getTargetProperty(candidateClass);
        if (targetProperty != null) {
            LOGGER.trace("Found @AclConstrainedObject in class {} - OID will be generated using the annotated property", new Object[]{candidateClass.getName()});
            identityHolder = this.getIdentityHolder(targetProperty, domainObject);
        } else {
            LOGGER.trace("Did not find any @AclConstrainedObject in class {} - OID will be the object's", new Object[]{candidateClass.getName()});
            identityHolder = domainObject;
        }
        try {
            AclPrimaryObject aclPrimaryObject = (AclPrimaryObject)identityHolder;
            return new ObjectIdentityImpl(aclPrimaryObject.getClassName(), (Serializable)aclPrimaryObject.getId());
        }
        catch (ClassCastException cce) {
            LOGGER.error("You should implement AclPrimaryObject interface !", (Throwable)cce);
            throw new ClassCastException("Class cast exception when trying to cast identityHolder into AclPrimaryObject.");
        }
    }

    private Method getTargetProperty(Class<?> candidateClass) {
        Method targetProperty;
        if (this.isMapped(candidateClass)) {
            targetProperty = this.identityMethodMap.get(candidateClass);
        } else {
            targetProperty = this.findAnnotatedProperty(candidateClass);
            if (targetProperty != null) {
                this.mapClass(candidateClass, targetProperty);
            }
        }
        return targetProperty;
    }

    private Object getIdentityHolder(Method targetProperty, Object domainObject) {
        Object identityHolder;
        try {
            identityHolder = targetProperty.invoke(domainObject, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause().getClass() == ObjectNotFoundException.class) {
                identityHolder = new Identified(){

                    public Long getId() {
                        return 0L;
                    }
                };
            }
            throw new RuntimeException(e);
        }
        return identityHolder;
    }

    private Method findAnnotatedProperty(Class<?> candidateClass) {
        HashSet<Class> exploredClasses = new HashSet<Class>();
        LinkedList explorationQueue = new LinkedList();
        Method targetProperty = null;
        explorationQueue.add(candidateClass);
        while (targetProperty == null && !explorationQueue.isEmpty()) {
            Class currentClass = (Class)explorationQueue.removeFirst();
            if (currentClass == null || exploredClasses.contains(currentClass)) continue;
            LOGGER.trace("Looking for @AclConstrainedObject in class '{}'", new Object[]{candidateClass.getName()});
            targetProperty = this.findAnnotatedPropertyInClass(currentClass);
            if (targetProperty == null) {
                explorationQueue.addAll(Arrays.asList(currentClass.getInterfaces()));
                explorationQueue.add(currentClass.getSuperclass());
            }
            exploredClasses.add(currentClass);
        }
        return targetProperty;
    }

    private Method findAnnotatedPropertyInClass(Class<?> candidateClass) {
        Method targetProperty = null;
        Method[] methodArray = candidateClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method meth = methodArray[n2];
            AclConstrainedObject target = meth.getAnnotation(AclConstrainedObject.class);
            if (target != null) {
                targetProperty = meth;
                break;
            }
            ++n2;
        }
        if (targetProperty != null) {
            LOGGER.trace("Found @AclConstrainedObject in class {}", new Object[]{candidateClass.getName()});
        } else {
            LOGGER.trace("@AclConstrainedObject not found in class {}", new Object[]{candidateClass.getName()});
        }
        return targetProperty;
    }

    private boolean isMapped(Class<?> someClass) {
        return this.identityMethodMap.containsKey(someClass);
    }

    private void mapClass(Class<?> someClass, Method identityMethod) {
        LOGGER.debug("AnnotatedPropertyObjectIdentityRetrievalStrategy: identity method '{}' found for class '{}', registering now", new Object[]{identityMethod.getName(), someClass.getName()});
        this.identityMethodMap.put(someClass, identityMethod);
        this.nukeMapIfTooLarge();
    }

    private void nukeMapIfTooLarge() {
        if (this.identityMethodMap.size() > 50) {
            LOGGER.debug("AnnotatedPropertyObjectIdentityRetrievalStrategy: identity method registry grew too large, reseting it", new Object[0]);
            this.identityMethodMap.clear();
        }
    }
}

