/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record;
import org.jooq.Record5;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.SelectSelectStep;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customreport.CustomExportColumnLabel;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomFieldCustomExportDto;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;
import org.squashtest.tm.service.internal.repository.CustomCustomFieldValueDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;

public class CustomFieldValueDaoImpl
implements CustomCustomFieldValueDao {
    private static final String CUF_ID = "cufId";
    private static final String BINDABLE_ENTITY = "bindableEntity";
    private static final Field<String> CUSTOM_FIELD_VALUE_TAG_VALUE = DSL.groupConcat((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL).separator(", ");
    private static final Field<String> DENORMALIZED_FIELD_VALUE_TAG_VALUE = DSL.groupConcat((Field)Tables.DENORMALIZED_FIELD_VALUE_OPTION.LABEL).separator(", ");
    private static final Field<String> CUSTOM_FIELD_VALUE_COMPUTED = DSL.when((Condition)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)"CF"), (Field)Tables.CUSTOM_FIELD_VALUE.VALUE).when(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)"RTF"), (Field)Tables.CUSTOM_FIELD_VALUE.LARGE_VALUE).when(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)"NUM"), (Field)Tables.CUSTOM_FIELD_VALUE.VALUE).when(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)"TAG"), CUSTOM_FIELD_VALUE_TAG_VALUE).as("COMPUTED_VALUE");
    private static final Field<String> DENORMALIZED_FIELD_VALUE_COMPUTED = DSL.when((Condition)Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE.eq((Object)"CF"), (Field)Tables.DENORMALIZED_FIELD_VALUE.VALUE).when(Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE.eq((Object)"SSF"), (Field)Tables.DENORMALIZED_FIELD_VALUE.VALUE).when(Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE.eq((Object)"RTF"), (Field)Tables.DENORMALIZED_FIELD_VALUE.LARGE_VALUE).when(Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE.eq((Object)"NUM"), (Field)Tables.DENORMALIZED_FIELD_VALUE.VALUE).when(Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE.eq((Object)"MFV"), DENORMALIZED_FIELD_VALUE_TAG_VALUE).as("COMPUTED_VALUE");
    @Inject
    private DSLContext dsl;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Map<EntityReference, Map<Long, Object>> getCufValuesMapByEntityReference(List<EntityReference> scopeEntities, Map<EntityType, List<Long>> entityTypeToCufIdsListMap) {
        Iterator<Object> denormalizedCufQueryResult;
        Iterator<Record> standardCufQueryResult;
        Set<EntityReference> allRequestedEntitiesInCampaign = this.getEntityReferencesFromCampaign(scopeEntities, entityTypeToCufIdsListMap.keySet());
        if (allRequestedEntitiesInCampaign.isEmpty()) {
            return null;
        }
        if (entityTypeToCufIdsListMap.keySet().size() == 1 && entityTypeToCufIdsListMap.containsKey(EntityType.TEST_STEP)) {
            standardCufQueryResult = Collections.emptyIterator();
        } else {
            SelectSelectStep<Record5<String, Long, Long, String, String>> query = this.buildStandardCufQuery(entityTypeToCufIdsListMap, allRequestedEntitiesInCampaign);
            standardCufQueryResult = query.fetch().stream().map(r -> r).iterator();
        }
        Set<Long> testStepIdsInScope = allRequestedEntitiesInCampaign.stream().filter(ref -> EntityType.TEST_STEP.equals((Object)ref.getType())).map(EntityReference::getId).collect(Collectors.toSet());
        if (entityTypeToCufIdsListMap.containsKey(EntityType.TEST_STEP) && !testStepIdsInScope.isEmpty()) {
            SelectSelectStep<Record5<String, Long, String, Long, String>> denormQuery = this.buildDenormalizedCufQuery(entityTypeToCufIdsListMap, testStepIdsInScope);
            denormalizedCufQueryResult = denormQuery.fetch().stream().map(r -> r).iterator();
        } else {
            denormalizedCufQueryResult = Collections.emptyIterator();
        }
        return this.buildResultMapFromQueryResult(standardCufQueryResult, denormalizedCufQueryResult);
    }

    @Override
    public List<CustomFieldCustomExportDto> findAllAvailableForCustomExportByProjectIds(List<Long> projectIds) {
        return this.dsl.selectDistinct((SelectField)Tables.CUSTOM_FIELD.LABEL, (SelectField)Tables.CUSTOM_FIELD.CF_ID.as(CUF_ID), (SelectField)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY.as(BINDABLE_ENTITY)).from((TableLike)Tables.CUSTOM_FIELD).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)).where(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.in(projectIds)).or(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.in((Select)this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.in(projectIds)))).or(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.in((Select)this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.in(projectIds)))).fetchInto(CustomFieldCustomExportDto.class);
    }

    @Override
    public Map<Long, List<CustomFieldValue>> getCufValuesMapByBoundEntity(BindableEntity entity, List<Long> entityIds) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<CustomFieldValue> resultStream = this.getCufValuesByEntityAndIdsStream(entity, entityIds);){
            return resultStream.collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Stream<CustomFieldValue> getCufValuesByEntityAndIdsStream(BindableEntity entity, List<Long> entityIds) {
        return new EntityGraphQueryBuilder<CustomFieldValue>(this.entityManager, CustomFieldValue.class, "SELECT c FROM CustomFieldValue c WHERE c.binding.boundEntity = :entity AND c.boundEntityId in :entityIds").addAttributeNodes("binding").addSubGraph("binding", "customField").executeStream(Map.of("entity", entity, "entityIds", entityIds));
    }

    private Map<EntityReference, Map<Long, Object>> buildResultMapFromQueryResult(Iterator<Record> standardCufQueryResult, Iterator<Record> denormalizedCufQueryResult) {
        HashMap<EntityReference, Map<Long, Object>> resultMap = new HashMap<EntityReference, Map<Long, Object>>();
        standardCufQueryResult.forEachRemaining(record -> {
            EntityReference entity = new EntityReference(EntityType.valueOf((String)((String)record.get((Field)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE))), (Long)record.get((Field)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID));
            Object cufValue = record.get(CUSTOM_FIELD_VALUE_COMPUTED);
            if ("NUM".equals(record.get((Field)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE))) {
                cufValue = NumericCufHelper.formatOutputNumericCufValue(String.valueOf(cufValue));
            }
            Long cufId = (Long)record.get((Field)Tables.CUSTOM_FIELD_VALUE.CF_ID);
            this.populateCustomFieldValuesMap(entity, cufId, cufValue, resultMap);
        });
        denormalizedCufQueryResult.forEachRemaining(record -> {
            EntityReference entity = new EntityReference(EntityType.TEST_STEP, (Long)record.get((Field)Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID));
            Object cufValue = record.get(DENORMALIZED_FIELD_VALUE_COMPUTED);
            if ("NUM".equals(record.get((Field)Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE))) {
                cufValue = NumericCufHelper.formatOutputNumericCufValue(String.valueOf(cufValue));
            }
            Long cufId = (Long)record.get((Field)Tables.CUSTOM_FIELD_VALUE.CF_ID);
            this.populateCustomFieldValuesMap(entity, cufId, cufValue, resultMap);
        });
        return resultMap;
    }

    private void populateCustomFieldValuesMap(EntityReference entityReference, Long cufId, Object cufValue, Map<EntityReference, Map<Long, Object>> resultMap) {
        Map<Long, Object> currentEntityMap = resultMap.get(entityReference);
        if (currentEntityMap == null) {
            resultMap.put(entityReference, new HashMap());
            currentEntityMap = resultMap.get(entityReference);
        }
        currentEntityMap.put(cufId, cufValue);
    }

    private SelectSelectStep<Record5<String, Long, Long, String, String>> buildStandardCufQuery(Map<EntityType, List<Long>> entityTypeToCufIdsListMap, Set<EntityReference> allRequestedEntitiesInCampaign) {
        SelectSelectStep query1 = this.dsl.select((SelectField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE, (SelectField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID, (SelectField)Tables.CUSTOM_FIELD_VALUE.CF_ID, (SelectField)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE, CUSTOM_FIELD_VALUE_COMPUTED);
        query1.from((TableLike)Tables.CUSTOM_FIELD_VALUE).leftJoin((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).on(Tables.CUSTOM_FIELD_VALUE.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID));
        query1.where(this.buildWhereConditionOfCufQuery(entityTypeToCufIdsListMap, allRequestedEntitiesInCampaign));
        query1.groupBy(new GroupField[]{Tables.CUSTOM_FIELD_VALUE.CFV_ID});
        return query1;
    }

    private SelectSelectStep<Record5<String, Long, String, Long, String>> buildDenormalizedCufQuery(Map<EntityType, List<Long>> entityTypeToCufIdsListMap, Set<Long> testStepIdsInScope) {
        SelectSelectStep query2 = this.dsl.select((SelectField)Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_TYPE, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE, (SelectField)Tables.CUSTOM_FIELD_VALUE.CF_ID, DENORMALIZED_FIELD_VALUE_COMPUTED);
        query2.from((TableLike)Tables.DENORMALIZED_FIELD_VALUE).leftJoin((TableLike)Tables.DENORMALIZED_FIELD_VALUE_OPTION).on(Tables.DENORMALIZED_FIELD_VALUE_OPTION.DFV_ID.eq((Field)Tables.DENORMALIZED_FIELD_VALUE.DFV_ID)).innerJoin((TableLike)Tables.CUSTOM_FIELD_VALUE).on(Tables.DENORMALIZED_FIELD_VALUE.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID)).innerJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID));
        Condition condition = Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_TYPE.eq((Object)"EXECUTION_STEP").and(Tables.EXECUTION_STEP.TEST_STEP_ID.in(testStepIdsInScope)).and(Tables.CUSTOM_FIELD_VALUE.CF_ID.in((Collection)entityTypeToCufIdsListMap.get(EntityType.TEST_STEP)));
        query2.where(condition);
        query2.groupBy(new GroupField[]{Tables.DENORMALIZED_FIELD_VALUE.DFV_ID, Tables.CUSTOM_FIELD_VALUE.CFV_ID});
        return query2;
    }

    private Condition buildWhereConditionOfCufQuery(Map<EntityType, List<Long>> entityTypeToCufIdsListMap, Set<EntityReference> allRequestedEntitiesInCampaign) {
        Condition whereCondition = null;
        for (EntityReference entityReference : allRequestedEntitiesInCampaign) {
            List<Long> cufIdList = entityTypeToCufIdsListMap.get(entityReference.getType());
            Condition currentCondition = null;
            if (cufIdList != null) {
                currentCondition = Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)entityReference.getType().toString()).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.eq((Object)entityReference.getId())).and(Tables.CUSTOM_FIELD_VALUE.CF_ID.in(cufIdList));
            }
            whereCondition = whereCondition == null ? currentCondition : whereCondition.or(currentCondition);
        }
        return whereCondition;
    }

    private Set<EntityReference> getEntityReferencesFromCampaign(List<EntityReference> entities, Set<EntityType> entityTypes) {
        SelectJoinStep<Record> query = this.buildEntityReferencesQuery(entities, entityTypes);
        Iterator queryResult = query.fetch().iterator();
        return this.buildEntityReferencesSetFromQueryResult(entityTypes, queryResult);
    }

    private SelectJoinStep<Record> buildEntityReferencesQuery(List<EntityReference> scopeEntities, Set<EntityType> requestedEntityTypes) {
        int cufQueryDepth = this.getDepthOfEntitiesQuery(requestedEntityTypes);
        boolean isTestSuiteRequested = requestedEntityTypes.contains(EntityType.TEST_SUITE);
        List<Field<?>> fieldList = this.buildFieldsListOfEntitiesQuery(cufQueryDepth, isTestSuiteRequested, scopeEntities);
        SelectSelectStep selectQuery = this.dsl.select(fieldList);
        SelectJoinStep<Record> fromQuery = this.buildFromClauseOfEntitiesQuery((SelectSelectStep<Record>)selectQuery, cufQueryDepth, isTestSuiteRequested, scopeEntities);
        Condition condition = this.buildCondition(scopeEntities);
        fromQuery.where(condition);
        return fromQuery;
    }

    private Condition buildCondition(List<EntityReference> scopeEntities) {
        Map tableFieldByEntityTypeMap = CustomExportColumnLabel.getSelectableEntityTypeToIdTableFieldMap();
        Condition condition = null;
        for (EntityReference entity : scopeEntities) {
            TableField field = (TableField)tableFieldByEntityTypeMap.get(entity.getType());
            condition = condition == null ? field.eq((Object)entity.getId()) : condition.or(field.eq((Object)entity.getId()));
        }
        return condition;
    }

    private Set<EntityReference> buildEntityReferencesSetFromQueryResult(Set<EntityType> entityTypes, Iterator<Record> queryResult) {
        HashSet<EntityReference> entityReferenceSet = new HashSet<EntityReference>();
        queryResult.forEachRemaining(record -> {
            for (EntityType entityType : entityTypes) {
                Long entityId = (Long)record.get((Field)CustomExportColumnLabel.getEntityTypeToIdTableFieldMap().get(entityType));
                if (entityId == null) continue;
                entityReferenceSet.add(new EntityReference(entityType, entityId));
            }
        });
        return entityReferenceSet;
    }

    private SelectJoinStep<Record> buildFromClauseOfEntitiesQuery(SelectSelectStep<Record> selectQuery, int cufQueryDepth, boolean isTestSuiteRequested, List<EntityReference> scopeEntity) {
        List<EntityType> types = scopeEntity.stream().map(EntityReference::getType).toList();
        boolean isIterationSelected = types.contains(EntityType.ITERATION);
        boolean isTestSuiteSelected = types.contains(EntityType.TEST_SUITE);
        boolean isFolderSelected = types.contains(EntityType.CAMPAIGN_FOLDER);
        SelectJoinStep fromQuery = selectQuery.from((TableLike)Tables.CAMPAIGN);
        if (isFolderSelected) {
            fromQuery.innerJoin((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).on(Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(Tables.CAMPAIGN_FOLDER.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID));
        }
        if (cufQueryDepth > 1 || isIterationSelected || isTestSuiteSelected) {
            fromQuery.leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).leftJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID));
        }
        if (cufQueryDepth > 2 || isTestSuiteSelected) {
            fromQuery.leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID));
            if (isTestSuiteRequested || isTestSuiteSelected) {
                fromQuery.leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID));
            }
        }
        if (cufQueryDepth > 3) {
            fromQuery.leftJoin((TableLike)Tables.EXECUTION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID));
        }
        if (cufQueryDepth > 4) {
            fromQuery.leftJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)).leftJoin((TableLike)Tables.TEST_STEP).on(Tables.TEST_STEP.TEST_STEP_ID.eq((Field)Tables.EXECUTION_STEP.TEST_STEP_ID));
        }
        return fromQuery;
    }

    private List<Field<?>> buildFieldsListOfEntitiesQuery(int cufQueryDepth, boolean isTestSuiteRequested, List<EntityReference> scopeEntity) {
        ArrayList fieldList = new ArrayList();
        List<EntityType> types = scopeEntity.stream().map(EntityReference::getType).toList();
        fieldList.add((Field<?>)Tables.CAMPAIGN.CLN_ID);
        boolean isIterationSelected = types.contains(EntityType.ITERATION);
        boolean isTestSuiteSelected = types.contains(EntityType.TEST_SUITE);
        boolean isFolderSelected = types.contains(EntityType.CAMPAIGN_FOLDER);
        if (isFolderSelected) {
            fieldList.add((Field<?>)Tables.CAMPAIGN_FOLDER.CLN_ID);
        }
        if (cufQueryDepth > 1 || isIterationSelected) {
            fieldList.add((Field<?>)Tables.ITERATION.ITERATION_ID);
        }
        if (cufQueryDepth > 2 || isTestSuiteSelected) {
            fieldList.add((Field<?>)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID);
            fieldList.add((Field<?>)Tables.TEST_CASE.TCLN_ID);
            if (isTestSuiteRequested || isTestSuiteSelected) {
                fieldList.add((Field<?>)Tables.TEST_SUITE.ID);
            }
        }
        if (cufQueryDepth > 3) {
            fieldList.add((Field<?>)Tables.EXECUTION.EXECUTION_ID);
        }
        if (cufQueryDepth > 4) {
            fieldList.add((Field<?>)Tables.EXECUTION_STEP.EXECUTION_STEP_ID);
            fieldList.add((Field<?>)Tables.EXECUTION_STEP.TEST_STEP_ID);
            fieldList.add((Field<?>)Tables.TEST_STEP.TEST_STEP_ID);
        }
        return fieldList;
    }

    private int getDepthOfEntitiesQuery(Set<EntityType> entityTypeList) {
        if (entityTypeList.contains(EntityType.EXECUTION_STEP) || entityTypeList.contains(EntityType.TEST_STEP)) {
            return 5;
        }
        if (entityTypeList.contains(EntityType.EXECUTION)) {
            return 4;
        }
        if (entityTypeList.contains(EntityType.TEST_CASE) || entityTypeList.contains(EntityType.TEST_SUITE)) {
            return 3;
        }
        if (entityTypeList.contains(EntityType.ITERATION)) {
            return 2;
        }
        return 1;
    }
}

