/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AttachmentPivotType;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.RequirementPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.RequirementPivotDao;

@Service
public class RequirementPivotExporterServiceImpl
implements RequirementPivotExporterService {
    private final RequirementPivotDao requirementPivotDao;
    private final PivotFileManager pivotFileManager;

    public RequirementPivotExporterServiceImpl(RequirementPivotDao requirementPivotDao, PivotFileManager pivotFileManager) {
        this.requirementPivotDao = requirementPivotDao;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    public void generateRequirementJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, File tmpAttachmentDir, Long projectId) throws IOException {
        if (!this.requirementPivotDao.hasRequirementByProjectId(projectId)) {
            return;
        }
        File attachmentDir = this.pivotFileManager.createAttachmentDir(tmpAttachmentDir, AttachmentPivotType.REQUIREMENT_VERSION);
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleRequirements((JsonGenerator)jsonGenerator, attachmentDir, projectId), JsonImportFile.REQUIREMENTS, archive);
        this.pivotFileManager.addAttachmentsToZip(archive, tmpAttachmentDir, attachmentDir);
    }

    private void handleRequirements(JsonGenerator jsonGenerator, File attachmentDir, Long projectId) {
        this.requirementPivotDao.getRequirementByProjectId(projectId, requirementPivot -> this.pivotFileManager.writePivotObject(requirementPivot, jsonGenerator, JsonImportFile.REQUIREMENTS), attachmentPivot -> this.pivotFileManager.saveTmpSaveAttachment(attachmentDir, (AttachmentPivot)attachmentPivot));
    }
}

