/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.helper;

import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UpdateSetFirstStep;
import org.jooq.UpdateSetMoreStep;

public final class JooqUpdateHelper {
    private JooqUpdateHelper() {
    }

    public static void nullifyColumnsWithJoin(DSLContext dslContext, Table<?> joinTable, Condition joinCondition, TableField<?, ?> ... fieldsToNullify) {
        if (fieldsToNullify.length == 0) {
            throw new IllegalArgumentException("At least one field must be specified to set to NULL");
        }
        Table<?> targetTable = JooqUpdateHelper.getTargetTable(fieldsToNullify);
        switch (dslContext.dialect()) {
            case MARIADB: {
                UpdateSetFirstStep update = dslContext.update((Table)targetTable.innerJoin(joinTable).on(joinCondition));
                UpdateSetMoreStep<?> updateStep = JooqUpdateHelper.applySetNullFields(update, fieldsToNullify);
                updateStep.execute();
                break;
            }
            case POSTGRES: {
                UpdateSetFirstStep update = dslContext.update(targetTable);
                UpdateSetMoreStep<?> updateStep = JooqUpdateHelper.applySetNullFields(update, fieldsToNullify);
                updateStep.from(joinTable).where(joinCondition).execute();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported SQL dialect: " + String.valueOf(dslContext.dialect()) + ". Only MARIADB and POSTGRES are supported for UPDATE with JOIN operations.");
            }
        }
    }

    private static UpdateSetMoreStep<?> applySetNullFields(UpdateSetFirstStep<?> update, TableField<?, ?> ... fieldsToNull) {
        UpdateSetMoreStep updateStep = update.setNull(fieldsToNull[0]);
        int i = 1;
        while (i < fieldsToNull.length) {
            updateStep = updateStep.setNull(fieldsToNull[i]);
            ++i;
        }
        return updateStep;
    }

    private static Table<?> getTargetTable(TableField<?, ?>[] fields) {
        Table targetTable = fields[0].getTable();
        if (targetTable == null) {
            throw new IllegalArgumentException("Cannot determine target table from fields");
        }
        TableField<?, ?>[] tableFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            TableField<?, ?> field = tableFieldArray[n2];
            if (!targetTable.equals((Object)field.getTable())) {
                throw new IllegalArgumentException(String.format("All fields must belong to the same table. Expected: %s, but found: %s", targetTable.getName(), field.getTable() != null ? field.getTable().getName() : "null"));
            }
            ++n2;
        }
        return targetTable;
    }
}

