/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.filemanagement.writer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.squashtest.tm.exception.filemanagement.WriterException;
import org.squashtest.tm.service.internal.filemanagement.writer.Writer;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

public class CSVWriter
implements Writer {
    private static final char UTF8_BOM_UNICODE = '\ufeff';
    private final CSVPrinter csvPrinter;

    public CSVWriter(File file) {
        this.csvPrinter = this.createCSVPrinter(file, this.getDefaultCSVFormat());
    }

    private CSVPrinter createCSVPrinter(File file, CSVFormat csvFormat) {
        try {
            FileWriter fileWriter = new FileWriter(file, StandardCharsets.UTF_8);
            fileWriter.write(65279);
            return new CSVPrinter((Appendable)fileWriter, csvFormat);
        }
        catch (IOException e) {
            throw new WriterException((Throwable)e);
        }
    }

    private CSVFormat getDefaultCSVFormat() {
        return CSVFormat.DEFAULT.builder().setDelimiter(";").setQuoteMode(QuoteMode.ALL).get();
    }

    @Override
    public void close() {
        try {
            this.csvPrinter.close();
        }
        catch (IOException e) {
            throw new WriterException((Throwable)e);
        }
    }

    @Override
    public void flush() {
        try {
            this.csvPrinter.flush();
        }
        catch (IOException e) {
            throw new WriterException((Throwable)e);
        }
    }

    @Override
    public void write(Collection<String> data) {
        List<String> cleanedValues = data.stream().map(HTMLCleanupUtils::cleanHtml).toList();
        try {
            this.csvPrinter.printRecord(cleanedValues);
        }
        catch (IOException e) {
            throw new WriterException((Throwable)e);
        }
    }
}

