/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.administration;

import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record1;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectHavingStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.AclObjectIdentity;
import org.squashtest.tm.jooq.domain.tables.AclResponsibilityScopeEntry;
import org.squashtest.tm.jooq.domain.tables.CoreUser;
import org.squashtest.tm.jooq.domain.tables.Milestone;
import org.squashtest.tm.jooq.domain.tables.MilestoneBinding;
import org.squashtest.tm.jooq.domain.tables.MilestoneBindingPerimeter;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class MilestoneGrid
extends AbstractGrid {
    private static final String M_RANGE = "M_RANGE";
    private static final String USER_ID = "USER_ID";
    private static final String FILTERED_MILESTONE_ID = "FILTERED_MILESTONE_ID";
    private final Long userId;
    private final boolean isAdmin;

    public MilestoneGrid(Long userId, boolean isAdmin) {
        this.userId = userId;
        this.isAdmin = isAdmin;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn(DSL.field((String)"MILESTONE_ID")), new GridColumn(DSL.field((String)"LABEL")), new GridColumn(DSL.field((String)"STATUS")), new GridColumn(DSL.field((String)"END_DATE")), new GridColumn(DSL.isnull((Field)DSL.field((String)"PROJECT_COUNT"), (Object)0).as("PROJECT_COUNT")), new GridColumn(DSL.field((String)M_RANGE).as("RANGE")), new GridColumn(DSL.field((String)"OWNER_FIRST_NAME")), new GridColumn(DSL.field((String)"OWNER_LAST_NAME")), new GridColumn(DSL.field((String)"OWNER_LOGIN")), new GridColumn(DSL.field((String)USER_ID).as("OWNER_ID")), new GridColumn(DSL.field((String)"DESCRIPTION")), new GridColumn(DSL.field((String)"CREATED_ON")), new GridColumn(DSL.field((String)"CREATED_BY")), new GridColumn(DSL.field((String)"USER_SORT_COLUMN")));
    }

    @Override
    protected Table<?> getTable() {
        Table<?> visibleMilestones = this.getVisibleMilestonesForUser();
        SelectHavingStep<?> projectCount = this.getProjectCount();
        return DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[]{visibleMilestones.asterisk(), projectCount.field("PROJECT_COUNT").as("PROJECT_COUNT"), CoreUser.CORE_USER.FIRST_NAME.as("OWNER_FIRST_NAME"), CoreUser.CORE_USER.LAST_NAME.as("OWNER_LAST_NAME"), CoreUser.CORE_USER.LOGIN.as("OWNER_LOGIN"), this.getUserSortColumn(visibleMilestones)}).from(visibleMilestones).leftJoin((TableLike)CoreUser.CORE_USER).on(visibleMilestones.field(USER_ID, Long.class).eq((Field)CoreUser.CORE_USER.PARTY_ID)).leftJoin(projectCount).on(visibleMilestones.field("MILESTONE_ID", Long.class).eq(projectCount.field("MILESTONE_ID", Long.class))).asTable();
    }

    private SelectHavingStep<?> getProjectCount() {
        return DSL.select((SelectField)MilestoneBinding.MILESTONE_BINDING.MILESTONE_ID.as("MILESTONE_ID"), (SelectField)DSL.countDistinct((Field)Project.PROJECT.PROJECT_ID).as("PROJECT_COUNT")).from((TableLike)MilestoneBinding.MILESTONE_BINDING).leftJoin((TableLike)Project.PROJECT).on(MilestoneBinding.MILESTONE_BINDING.PROJECT_ID.eq((Field)Project.PROJECT.PROJECT_ID)).groupBy(new GroupField[]{MilestoneBinding.MILESTONE_BINDING.MILESTONE_ID});
    }

    private Table<?> getVisibleMilestonesForUser() {
        if (this.isAdmin) {
            return DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[]{Milestone.MILESTONE.asterisk()}).from((TableLike)Milestone.MILESTONE).asTable();
        }
        SelectHavingStep<Record1<Long>> globalMilestones = this.getGlobalRangeMilestones();
        SelectHavingStep<Record1<Long>> ownedMilestones = this.getOwnedMilestones();
        SelectHavingStep<Record1<Long>> milestoneBoundToManagedProject = this.getMilestoneBoundToManagedProject();
        return DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[]{Milestone.MILESTONE.asterisk()}).from((TableLike)Milestone.MILESTONE).join((TableLike)globalMilestones.union(ownedMilestones).union(milestoneBoundToManagedProject)).on(Milestone.MILESTONE.MILESTONE_ID.eq(DSL.field((String)FILTERED_MILESTONE_ID, Long.class))).asTable();
    }

    private Field<?> getUserSortColumn(Table<?> visibleMilestones) {
        Field concatWithoutFirstName = DSL.concat((Field[])new Field[]{DSL.val((String)"1"), CoreUser.CORE_USER.LAST_NAME, DSL.val((String)" ("), CoreUser.CORE_USER.LOGIN, DSL.val((String)")")});
        Field concatWithFirstName = DSL.concat((Field[])new Field[]{DSL.val((String)"1"), CoreUser.CORE_USER.FIRST_NAME, DSL.val((String)" "), CoreUser.CORE_USER.LAST_NAME, DSL.val((String)" ("), CoreUser.CORE_USER.LOGIN, DSL.val((String)")")});
        return DSL.when((Condition)visibleMilestones.field(M_RANGE, String.class).eq((Object)"GLOBAL"), (Object)"0").otherwise(DSL.when((Condition)CoreUser.CORE_USER.FIRST_NAME.isNull(), (Field)concatWithoutFirstName).otherwise(concatWithFirstName)).as("USER_SORT_COLUMN");
    }

    private SelectHavingStep<Record1<Long>> getGlobalRangeMilestones() {
        return DSL.select((SelectField)Milestone.MILESTONE.MILESTONE_ID.as(FILTERED_MILESTONE_ID)).from((TableLike)Milestone.MILESTONE).where(Milestone.MILESTONE.M_RANGE.eq((Object)"GLOBAL"));
    }

    private SelectHavingStep<Record1<Long>> getOwnedMilestones() {
        return DSL.select((SelectField)Milestone.MILESTONE.MILESTONE_ID.as(FILTERED_MILESTONE_ID)).from((TableLike)Milestone.MILESTONE).where(Milestone.MILESTONE.USER_ID.eq((Object)this.userId));
    }

    private SelectHavingStep<Record1<Long>> getMilestoneBoundToManagedProject() {
        return DSL.select((SelectField)MilestoneBindingPerimeter.MILESTONE_BINDING_PERIMETER.MILESTONE_ID.as(FILTERED_MILESTONE_ID)).from((TableLike)MilestoneBindingPerimeter.MILESTONE_BINDING_PERIMETER).join((TableLike)AclObjectIdentity.ACL_OBJECT_IDENTITY).on(AclObjectIdentity.ACL_OBJECT_IDENTITY.IDENTITY.eq((Field)MilestoneBindingPerimeter.MILESTONE_BINDING_PERIMETER.PROJECT_ID).and(AclObjectIdentity.ACL_OBJECT_IDENTITY.CLASS_ID.eq((Object)1L))).join((TableLike)AclResponsibilityScopeEntry.ACL_RESPONSIBILITY_SCOPE_ENTRY).on(AclResponsibilityScopeEntry.ACL_RESPONSIBILITY_SCOPE_ENTRY.OBJECT_IDENTITY_ID.eq((Field)AclObjectIdentity.ACL_OBJECT_IDENTITY.ID)).join((TableLike)Tables.ACL_GROUP_PERMISSION).on(AclResponsibilityScopeEntry.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.eq((Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID)).where(AclResponsibilityScopeEntry.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.eq((Object)this.userId).and(Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK.eq((Object)Permissions.MANAGE_MILESTONE.getMask())));
    }

    @Override
    protected Field<?> getIdentifier() {
        return DSL.field((String)"MILESTONE_ID");
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return null;
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return DSL.field((String)"END_DATE").desc();
    }
}

