/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.attachment;

import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.display.attachment.FileViewerService;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.display.attachment.FileViewerExtension;
import org.squashtest.tm.service.internal.display.dto.FileViewerDto;
import org.squashtest.tm.service.internal.display.dto.FileViewerRequest;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.TreeGridResponse;

@Service
@Transactional(readOnly=true)
public class FileViewerServiceImpl
implements FileViewerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileViewerServiceImpl.class);
    private static final String IS_DIRECTORY = "isDirectory";
    private static final String NAME = "name";
    private static final FileViewerExtension[] UNSAFE_EXTENSIONS = new FileViewerExtension[]{FileViewerExtension.HTML, FileViewerExtension.PDF, FileViewerExtension.SVG};
    @Inject
    private AttachmentRepository attachmentRepository;
    @Inject
    private FeatureManager featureManager;
    @Autowired(required=false)
    private HttpServletRequest httpServletRequest;

    @Override
    public FileViewerDto preview(FileViewerRequest viewerRequest) throws IOException {
        boolean unsafeAttachmentPreviewEnabled = this.featureManager.isEnabled(FeatureManager.Feature.UNSAFE_ATTACHMENT_PREVIEW);
        if (!unsafeAttachmentPreviewEnabled && List.of(UNSAFE_EXTENSIONS).contains((Object)viewerRequest.getFileType())) {
            return new FileViewerDto(FileViewerExtension.HTML, "Unsafe files preview is disabled.");
        }
        switch (viewerRequest.getFileType()) {
            case JSON: 
            case LOG: 
            case TXT: 
            case XML: 
            case JS: 
            case CSS: {
                String content = IOUtils.toString((InputStream)this.getStream(viewerRequest), (Charset)StandardCharsets.UTF_8);
                return new FileViewerDto(viewerRequest.getFileType(), content);
            }
            case HTML: {
                String content = IOUtils.toString((InputStream)this.getStream(viewerRequest), (Charset)StandardCharsets.UTF_8);
                if (viewerRequest.getTarget() != null) {
                    content = this.injectBaseTagForArchive(content, viewerRequest);
                }
                return new FileViewerDto(viewerRequest.getFileType(), content);
            }
            case JPEG: 
            case JPG: 
            case PDF: 
            case PNG: 
            case SVG: 
            case GIF: 
            case BMP: {
                byte[] buffer = this.getContentBytes(viewerRequest);
                return new FileViewerDto(viewerRequest.getFileType(), buffer);
            }
        }
        throw new IllegalArgumentException("Invalid extension + " + String.valueOf((Object)viewerRequest.getFileType()) + " for preview");
    }

    private String injectBaseTagForArchive(String content, FileViewerRequest viewerRequest) {
        if (content == null || content.trim().isEmpty()) {
            return content;
        }
        try {
            String baseUri = this.buildHtmlBaseURI(viewerRequest.getTarget(), viewerRequest.getSource());
            String baseTag = String.format("<base href=\"%s\">", baseUri);
            return content.replaceFirst("(?i)<head(\\s[^>]*)?>", "$0" + baseTag);
        }
        catch (Exception e) {
            LOGGER.error("Failed to inject base tag", (Throwable)e);
            return content;
        }
    }

    private String buildHtmlBaseURI(String filePath, String attachmentId) {
        String baseUrl = this.httpServletRequest.getContextPath() + "/backend/file-viewer/archive-source/" + attachmentId + "/";
        if (filePath.contains("/")) {
            String targetPath = "target:" + filePath.substring(0, filePath.lastIndexOf("/"));
            return baseUrl + targetPath + "/";
        }
        return baseUrl;
    }

    @Override
    public TreeGridResponse getArchiveFileTree(FileViewerRequest viewerRequest) throws IOException {
        ArrayList<DataRow> dataRows = new ArrayList<DataRow>();
        TarArchiveInputStream tarInput = new TarArchiveInputStream(this.getSourceStream(viewerRequest));
        FileViewerServiceImpl.processArchiveIntoDataRows(tarInput, dataRows);
        TreeGridResponse treeGridResponse = new TreeGridResponse();
        treeGridResponse.setDataRows(dataRows);
        return treeGridResponse;
    }

    private static void processArchiveIntoDataRows(TarArchiveInputStream tarInput, List<DataRow> dataRows) throws IOException {
        TarArchiveEntry entry;
        HashMap<Path, DataRow> map = new HashMap<Path, DataRow>();
        while ((entry = tarInput.getNextEntry()) != null) {
            Path entryPath = Paths.get(entry.getName(), new String[0]);
            DataRow row = new DataRow();
            String rowId = entry.getName();
            row.setId(rowId);
            Path parentPath = entryPath.getParent();
            if (parentPath != null) {
                FileViewerServiceImpl.processParent(dataRows, row, parentPath, map, rowId);
            }
            if (entry.isDirectory()) {
                row.setState(DataRow.State.leaf);
                row.setData(Map.of(NAME, FileViewerServiceImpl.getFileName(entryPath), IS_DIRECTORY, true));
                map.put(entryPath, row);
            } else {
                row.setState(DataRow.State.leaf);
                row.setData(Map.of(NAME, FileViewerServiceImpl.getFileName(entryPath), IS_DIRECTORY, false));
            }
            dataRows.add(row);
        }
    }

    private static void processParent(List<DataRow> dataRows, DataRow row, Path parentPath, Map<Path, DataRow> map, String rowId) {
        row.setParentRowId(parentPath.toString());
        DataRow parent = map.get(parentPath);
        if (parent != null) {
            if (parent.getState().equals((Object)DataRow.State.leaf)) {
                parent.setState(DataRow.State.closed);
            }
            parent.getChildren().add(rowId);
        } else {
            DataRow parentRow = new DataRow();
            parentRow.setId(parentPath.toString());
            parentRow.setState(DataRow.State.closed);
            parentRow.setChildren(new ArrayList<String>(List.of(rowId)));
            parentRow.setData(Map.of(NAME, FileViewerServiceImpl.getFileName(parentPath), IS_DIRECTORY, true));
            map.put(parentPath, parentRow);
            dataRows.add(parentRow);
            if (parentPath.getParent() != null) {
                FileViewerServiceImpl.processParent(dataRows, parentRow, parentPath.getParent(), map, parentPath.toString());
            }
        }
    }

    private static String getFileName(Path entryPath) {
        return entryPath.getFileName().toString();
    }

    private InputStream getSourceStream(FileViewerRequest viewerRequest) throws IOException {
        String source = viewerRequest.getSource();
        return viewerRequest.isAttachment() ? this.attachmentRepository.getContentStream(Long.parseLong(source)) : new FileInputStream(source);
    }

    private InputStream getStream(FileViewerRequest viewerRequest) throws IOException {
        if (viewerRequest.getTarget() != null) {
            return this.getInputStreamFromArchive(this.getSourceStream(viewerRequest), viewerRequest.getTarget(), viewerRequest.getSource());
        }
        return this.getSourceStream(viewerRequest);
    }

    /*
     * Exception decompiling
     */
    private InputStream getInputStreamFromArchive(InputStream tarStream, String target, String source) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] getContentBytes(FileViewerRequest viewerRequest) throws IOException {
        if (viewerRequest.getTarget() != null) {
            return this.getContentBytesFromArchive(viewerRequest);
        }
        String source = viewerRequest.getSource();
        return viewerRequest.isAttachment() ? this.attachmentRepository.getContentBytes(Long.parseLong(source)) : Files.readAllBytes(Paths.get(source, new String[0]));
    }

    /*
     * Exception decompiling
     */
    private byte[] getContentBytesFromArchive(FileViewerRequest viewerRequest) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

