/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.Map;
import org.squashtest.tm.domain.customfield.CustomField;

public enum CustomFieldError {
    MAX_SIZE{

        @Override
        public String getErrorMessage() {
            return "message.import.log.error.field.maxSize";
        }

        @Override
        public String getCreateImpact() {
            return "message.import.log.impact.truncatedValue";
        }

        @Override
        public String getUpdateImpact() {
            return "message.import.log.impact.truncatedValue";
        }
    }
    ,
    MANDATORY_CUF{

        @Override
        public String getErrorMessage() {
            return "message.import.log.error.cuf.noValueForMandatoryCuf";
        }

        @Override
        public String getCreateImpact() {
            return "message.import.log.impact.useDefaultValue";
        }

        @Override
        public String getUpdateImpact() {
            return "message.import.log.impact.fieldNotChange";
        }
    }
    ,
    UNPARSABLE_CHECKBOX{

        @Override
        public String getErrorMessage() {
            return "message.import.log.error.field.notBoolean";
        }

        @Override
        public String getCreateImpact() {
            return "message.import.log.impact.useDefaultValue";
        }

        @Override
        public String getUpdateImpact() {
            return "message.import.log.impact.fieldNotChange";
        }
    }
    ,
    UNPARSABLE_DATE{

        @Override
        public String getErrorMessage() {
            return "message.import.log.error.field.wrongDateFormat";
        }

        @Override
        public String getCreateImpact() {
            return "message.import.log.impact.useDefaultValue";
        }

        @Override
        public String getUpdateImpact() {
            return "message.import.log.impact.fieldNotChange";
        }
    }
    ,
    UNPARSABLE_OPTION{

        @Override
        public String getErrorMessage() {
            return "message.import.log.error.listField.wrongValueForListField";
        }

        @Override
        public String getCreateImpact() {
            return "message.import.log.impact.useDefaultValue";
        }

        @Override
        public String getUpdateImpact() {
            return "message.import.log.impact.fieldNotChange";
        }
    }
    ,
    UNKNOWN_CUF_TYPE{

        @Override
        public String getErrorMessage() {
            return "message.import.log.cuf.unknowntype";
        }

        @Override
        public String getCreateImpact() {
            return "message.import.log.impact.fieldNotChange";
        }

        @Override
        public String getUpdateImpact() {
            return "message.import.log.impact.fieldNotChange";
        }
    }
    ,
    UNPARSABLE_NUMBER{

        @Override
        public String getErrorMessage() {
            return "message.import.log.error.field.notNumber";
        }

        @Override
        public String getCreateImpact() {
            return "message.import.log.impact.useDefaultValue";
        }

        @Override
        public String getUpdateImpact() {
            return "message.import.log.impact.fieldNotChange";
        }
    };


    public abstract String getErrorMessage();

    public abstract String getCreateImpact();

    public abstract String getUpdateImpact();

    public static void updateValue(Map<String, String> cufs, CustomField cuf, String value, String impact) {
        switch (impact) {
            case "message.import.log.impact.truncatedValue": {
                cufs.put(cuf.getCode(), value.substring(0, Math.min(value.length(), 255)));
                break;
            }
            case "message.import.log.impact.useDefaultValue": {
                cufs.put(cuf.getCode(), cuf.getDefaultValue());
                break;
            }
            case "message.import.log.impact.fieldNotChange": {
                cufs.remove(cuf.getCode());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CUF validation impact : " + impact);
            }
        }
    }
}

