/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.audit;

import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.internal.repository.AttachmentListDao;

@Service(value="squashtest.tm.service.AuditModificationService")
@Transactional
public class AuditModificationServiceImpl
implements AuditModificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditModificationServiceImpl.class);
    private static final List<BindableEntity> AUDITABLE_BINDABLE_ENTITY = Arrays.asList(BindableEntity.CAMPAIGN, BindableEntity.CAMPAIGN_FOLDER, BindableEntity.TEST_CASE, BindableEntity.TESTCASE_FOLDER, BindableEntity.REQUIREMENT_VERSION, BindableEntity.REQUIREMENT_FOLDER, BindableEntity.ITERATION, BindableEntity.TEST_SUITE, BindableEntity.EXECUTION, BindableEntity.EXECUTION_STEP);
    @Inject
    private AttachmentListDao attachmentListDao;

    @Override
    public void updateRelatedToAttachmentAuditableEntity(long attachmentListId, EntityType holderType) {
        LOGGER.debug("Looking for auditable related to attachment list with ID {}", new Object[]{attachmentListId});
        AuditableMixin auditable = this.attachmentListDao.findAuditableAssociatedEntityIfExists(attachmentListId, holderType);
        if (auditable != null) {
            this.updateAuditable(auditable);
        }
    }

    @Override
    public void updateRelatedToRequirementLinkAuditableEntity(List<RequirementVersion> versions) {
        LOGGER.debug("Updating requirement version auditable related to a RequirementLink", new Object[0]);
        versions.stream().map(AuditableMixin.class::cast).forEach(this::updateAuditable);
    }

    @Override
    public void updateRelatedToCustomFieldAuditableEntity(BoundEntity boundEntity) {
        LOGGER.debug("Updating auditable related to CUF BoundEntity {}", new Object[]{boundEntity});
        if (AUDITABLE_BINDABLE_ENTITY.contains(boundEntity.getBoundEntityType())) {
            this.updateAuditable((AuditableMixin)boundEntity);
        } else if (boundEntity.getBoundEntityType().equals((Object)BindableEntity.TEST_STEP)) {
            ActionTestStep testStep = (ActionTestStep)boundEntity;
            this.updateAuditable((AuditableMixin)testStep.getTestCase());
        }
    }

    @Override
    public void updateAuditable(AuditableMixin auditable) {
        LOGGER.debug("Updating auditable {}", new Object[]{auditable});
        auditable.setLastModifiedOn(new Date());
        auditable.setLastModifiedBy(UserContextHolder.getUsername());
    }
}

