/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auth.oauth2.GoogleCredentials;
import dev.langchain4j.model.anthropic.AnthropicChatModel;
import dev.langchain4j.model.azure.AzureOpenAiChatModel;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.mistralai.MistralAiChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiChatRequestParameters;
import dev.langchain4j.model.vertexai.gemini.VertexAiGeminiChatModel;
import io.micrometer.common.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.aiserver.AiProvider;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerCouldNotExecuteRequestException;
import org.squashtest.tm.exception.artificialintelligence.server.GoogleVertexCredentialsNotJsonException;
import org.squashtest.tm.service.internal.artificialintelligence.server.custom.CustomChatModel;
import org.squashtest.tm.service.internal.artificialintelligence.server.custom.CustomChatModelBuilder;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerConfiguration;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerDto;
import org.squashtest.tm.service.internal.display.dto.aiserver.CustomAiServerConfiguration;

public final class ChatModelProviderHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChatModelProviderHelper.class);

    private ChatModelProviderHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static ChatModel buildChatModelForAiServer(AiServerDto aiServerDto, TokenAuthCredentials credentials) {
        return switch (aiServerDto.getProvider()) {
            case AiProvider.AZURE_OPEN_AI -> ChatModelProviderHelper.getAzureOpenAiChatModel(aiServerDto, credentials);
            case AiProvider.ANTHROPIC -> ChatModelProviderHelper.getAnthropicChatModel(aiServerDto, credentials);
            case AiProvider.CUSTOM -> ChatModelProviderHelper.getCustomChatModel(aiServerDto, credentials);
            case AiProvider.GOOGLE_VERTEX_AI -> ChatModelProviderHelper.getVertexAiChatModel(aiServerDto, credentials);
            case AiProvider.MISTRAL_AI -> ChatModelProviderHelper.getMistralAiChatModel(aiServerDto, credentials);
            case AiProvider.OPEN_AI -> ChatModelProviderHelper.getOpenAiChatModel(aiServerDto, credentials);
            default -> throw new IllegalArgumentException("Unsupported AI provider: " + String.valueOf(aiServerDto.getProvider()));
        };
    }

    private static AzureOpenAiChatModel getAzureOpenAiChatModel(AiServerDto aiServerDto, TokenAuthCredentials credentials) {
        AiServerConfiguration config = (AiServerConfiguration)aiServerDto.getConfiguration();
        AzureOpenAiChatModel.Builder builder = AzureOpenAiChatModel.builder().endpoint(aiServerDto.getUrl()).apiKey(credentials.getToken()).deploymentName(aiServerDto.getModelName()).logRequestsAndResponses(Boolean.valueOf(true));
        Optional.ofNullable(config.getApiVersion()).ifPresent(arg_0 -> ((AzureOpenAiChatModel.Builder)builder).serviceVersion(arg_0));
        Optional.ofNullable(config.getTemperature()).ifPresent(arg_0 -> ((AzureOpenAiChatModel.Builder)builder).temperature(arg_0));
        Optional.ofNullable(config.getTopP()).ifPresent(arg_0 -> ((AzureOpenAiChatModel.Builder)builder).topP(arg_0));
        Optional.ofNullable(config.getSeed()).ifPresent(seed -> {
            AzureOpenAiChatModel.Builder builder2 = builder.seed(Long.valueOf(seed.intValue()));
        });
        Optional.ofNullable(config.getMaxTokens()).ifPresent(arg_0 -> ((AzureOpenAiChatModel.Builder)builder).maxTokens(arg_0));
        Optional.ofNullable(config.getMaxCompletionTokens()).ifPresent(arg_0 -> ((AzureOpenAiChatModel.Builder)builder).maxCompletionTokens(arg_0));
        Optional.ofNullable(config.getTimeout()).ifPresent(timeout -> {
            AzureOpenAiChatModel.Builder builder2 = builder.timeout(Duration.ofSeconds(timeout.intValue()));
        });
        return builder.build();
    }

    private static AnthropicChatModel getAnthropicChatModel(AiServerDto aiServerDto, TokenAuthCredentials credentials) {
        AiServerConfiguration config = (AiServerConfiguration)aiServerDto.getConfiguration();
        AnthropicChatModel.AnthropicChatModelBuilder builder = AnthropicChatModel.builder().apiKey(credentials.getToken()).modelName(aiServerDto.getModelName()).baseUrl(aiServerDto.getUrl()).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true));
        Optional.ofNullable(config.getTemperature()).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).temperature(arg_0));
        Optional.ofNullable(config.getTopP()).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).topP(arg_0));
        Optional.ofNullable(config.getMaxTokens()).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).maxTokens(arg_0));
        Optional.ofNullable(config.getThinkingType()).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).thinkingType(arg_0));
        Optional.ofNullable(config.getThinkingBudgetTokens()).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).thinkingBudgetTokens(arg_0));
        Optional.ofNullable(config.getTimeout()).ifPresent(timeout -> {
            AnthropicChatModel.AnthropicChatModelBuilder anthropicChatModelBuilder2 = builder.timeout(Duration.ofSeconds(timeout.intValue()));
        });
        return builder.build();
    }

    private static VertexAiGeminiChatModel getVertexAiChatModel(AiServerDto aiServerDto, TokenAuthCredentials credentials) {
        AiServerConfiguration config = (AiServerConfiguration)aiServerDto.getConfiguration();
        VertexAiGeminiChatModel.VertexAiGeminiChatModelBuilder builder = VertexAiGeminiChatModel.builder().modelName(aiServerDto.getModelName()).location(((AiServerConfiguration)aiServerDto.getConfiguration()).getRegion()).project(((AiServerConfiguration)aiServerDto.getConfiguration()).getProjectId()).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true));
        Optional.ofNullable(config.getTemperature()).ifPresent(temp -> {
            VertexAiGeminiChatModel.VertexAiGeminiChatModelBuilder vertexAiGeminiChatModelBuilder2 = builder.temperature(Float.valueOf(temp.floatValue()));
        });
        Optional.ofNullable(config.getTopP()).ifPresent(topP -> {
            VertexAiGeminiChatModel.VertexAiGeminiChatModelBuilder vertexAiGeminiChatModelBuilder2 = builder.topP(Float.valueOf(topP.floatValue()));
        });
        Optional.ofNullable(config.getMaxOutputTokens()).ifPresent(arg_0 -> ((VertexAiGeminiChatModel.VertexAiGeminiChatModelBuilder)builder).maxOutputTokens(arg_0));
        Optional.ofNullable(config.getSeed()).ifPresent(arg_0 -> ((VertexAiGeminiChatModel.VertexAiGeminiChatModelBuilder)builder).seed(arg_0));
        if (credentials != null && credentials.getToken() != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                objectMapper.readTree(credentials.getToken());
            }
            catch (JsonProcessingException e) {
                LOGGER.error("For Google Vertex AI, API key must be in JSON format.", (Throwable)e);
                throw new GoogleVertexCredentialsNotJsonException();
            }
            try {
                GoogleCredentials scopedCredentials = GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(credentials.getToken().getBytes(StandardCharsets.UTF_8))).createScoped(new String[]{"https://www.googleapis.com/auth/aiplatform"});
                builder.credentials(scopedCredentials);
            }
            catch (Exception e) {
                LOGGER.error("Failed to configure Google credentials", (Throwable)e);
                throw new AiServerCouldNotExecuteRequestException(e.getMessage());
            }
        }
        return builder.build();
    }

    private static MistralAiChatModel getMistralAiChatModel(AiServerDto aiServerDto, TokenAuthCredentials credentials) {
        AiServerConfiguration config = (AiServerConfiguration)aiServerDto.getConfiguration();
        MistralAiChatModel.MistralAiChatModelBuilder builder = MistralAiChatModel.builder().baseUrl(aiServerDto.getUrl()).apiKey(credentials.getToken()).modelName(aiServerDto.getModelName()).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true));
        Optional.ofNullable(config.getTemperature()).ifPresent(arg_0 -> ((MistralAiChatModel.MistralAiChatModelBuilder)builder).temperature(arg_0));
        Optional.ofNullable(config.getTopP()).ifPresent(arg_0 -> ((MistralAiChatModel.MistralAiChatModelBuilder)builder).topP(arg_0));
        Optional.ofNullable(config.getRandomSeed()).ifPresent(arg_0 -> ((MistralAiChatModel.MistralAiChatModelBuilder)builder).randomSeed(arg_0));
        Optional.ofNullable(config.getMaxTokens()).ifPresent(arg_0 -> ((MistralAiChatModel.MistralAiChatModelBuilder)builder).maxTokens(arg_0));
        Optional.ofNullable(config.getTimeout()).ifPresent(timeout -> {
            MistralAiChatModel.MistralAiChatModelBuilder mistralAiChatModelBuilder2 = builder.timeout(Duration.ofSeconds(timeout.intValue()));
        });
        return builder.build();
    }

    private static OpenAiChatModel getOpenAiChatModel(AiServerDto aiServerDto, TokenAuthCredentials credentials) {
        AiServerConfiguration config = (AiServerConfiguration)aiServerDto.getConfiguration();
        OpenAiChatModel.OpenAiChatModelBuilder builder = OpenAiChatModel.builder().apiKey(credentials.getToken()).modelName(aiServerDto.getModelName()).baseUrl(aiServerDto.getUrl()).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true));
        Optional.ofNullable(config.getTemperature()).ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).temperature(arg_0));
        Optional.ofNullable(config.getTopP()).ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).topP(arg_0));
        Optional.ofNullable(config.getSeed()).ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).seed(arg_0));
        Optional.ofNullable(config.getMaxCompletionTokens()).ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).maxCompletionTokens(arg_0));
        Optional.ofNullable(config.getOrganizationId()).ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).organizationId(arg_0));
        Optional.ofNullable(config.getTimeout()).ifPresent(timeout -> {
            OpenAiChatModel.OpenAiChatModelBuilder openAiChatModelBuilder2 = builder.timeout(Duration.ofSeconds(timeout.intValue()));
        });
        Optional.ofNullable(config.getReasoningEffort()).ifPresent(reasoningEffort -> {
            OpenAiChatModel.OpenAiChatModelBuilder openAiChatModelBuilder2 = builder.defaultRequestParameters((ChatRequestParameters)OpenAiChatRequestParameters.builder().reasoningEffort(reasoningEffort).build());
        });
        return builder.build();
    }

    private static ChatModel getCustomChatModel(AiServerDto aiServerDto, TokenAuthCredentials credentials) {
        CustomAiServerConfiguration config = (CustomAiServerConfiguration)aiServerDto.getConfiguration();
        CustomChatModelBuilder builder = CustomChatModel.builder().baseUrl(aiServerDto.getUrl()).apiKey(credentials.getToken()).payloadTemplate(config.getPayloadTemplate()).answerPath(config.getGeneratedTextJsonPath()).logRequests(true).logResponses(true);
        Map<String, String> httpHeaders = ChatModelProviderHelper.getHttpHeadersFromConfig(config);
        if (!httpHeaders.isEmpty()) {
            builder.httpHeaders(httpHeaders);
        }
        Optional.ofNullable(config.getTimeout()).ifPresent(timeout -> {
            CustomChatModelBuilder customChatModelBuilder2 = builder.timeout(Duration.ofSeconds(timeout.intValue()));
        });
        return builder.build();
    }

    private static Map<String, String> getHttpHeadersFromConfig(CustomAiServerConfiguration config) {
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        String[] headerNames = new String[]{config.getHttpHeaderName1(), config.getHttpHeaderName2(), config.getHttpHeaderName3(), config.getHttpHeaderName4(), config.getHttpHeaderName5()};
        String[] headerValues = new String[]{config.getHttpHeaderValueTemplate1(), config.getHttpHeaderValueTemplate2(), config.getHttpHeaderValueTemplate3(), config.getHttpHeaderValueTemplate4(), config.getHttpHeaderValueTemplate5()};
        int i = 0;
        while (i < headerNames.length) {
            if (StringUtils.isNotBlank((String)headerNames[i])) {
                httpHeaders.put(headerNames[i], headerValues[i]);
            }
            ++i;
        }
        return httpHeaders;
    }
}

