/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record3;
import org.jooq.Record4;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectOnConditionStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeReferences;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.NodeWorkspace;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.display.MultipleHierarchyTreeBrowserDao;
import org.squashtest.tm.service.internal.repository.display.impl.AncestorLookupDefinition;
import org.squashtest.tm.service.internal.repository.display.impl.RelationshipDefinition;

@Repository
public class MultipleHierarchyTreeBrowserDaoImpl
implements MultipleHierarchyTreeBrowserDao {
    private static final String SIMPLE_CLASS_NAME = "SIMPLE_CLASS_NAME";
    private final DSLContext dsl;
    private final Map<NodeType, RelationshipDefinition> relationshipDefinitions;
    private final Map<NodeType, AncestorLookupDefinition> ancestorLookupDefinitions;

    public MultipleHierarchyTreeBrowserDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
        this.relationshipDefinitions = EnumSet.allOf(RelationshipDefinition.class).stream().collect(Collectors.toMap(RelationshipDefinition::getNodeType, Function.identity()));
        this.ancestorLookupDefinitions = EnumSet.allOf(AncestorLookupDefinition.class).stream().filter(def -> def != AncestorLookupDefinition.TEST_SUITES_ANCESTORS && def != AncestorLookupDefinition.ITERATION_ANCESTORS).collect(Collectors.toMap(AncestorLookupDefinition::getNodeType, Function.identity()));
    }

    @Override
    public Set<NodeReference> findLibraryReferences(NodeWorkspace workspace, Collection<Long> projectIds) {
        return this.dsl.select((SelectField)workspace.getColumnRef()).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_TYPE.eq((Object)"P")).and(Tables.PROJECT.PROJECT_ID.in(projectIds)).fetch((Field)workspace.getColumnRef()).stream().map(id -> new NodeReference(workspace.getLibraryType(), id)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public ListMultimap<NodeReference, NodeReference> findChildrenReference(Set<NodeReference> parentReferences) {
        Map<NodeType, List<NodeReference>> parentReferencesByType = parentReferences.stream().collect(Collectors.groupingBy(NodeReference::getNodeType));
        ArrayListMultimap childrenReferences = ArrayListMultimap.create();
        for (Map.Entry<NodeType, List<NodeReference>> entry : parentReferencesByType.entrySet()) {
            NodeType nodeType = entry.getKey();
            Set<Long> ids = entry.getValue().stream().map(NodeReference::getId).collect(Collectors.toSet());
            if (this.relationshipDefinitions.containsKey(nodeType)) {
                childrenReferences.putAll(this.getChildrenReferences(this.relationshipDefinitions.get(nodeType), ids));
                continue;
            }
            throw new UnsupportedOperationException("No relationship definition implemented for type : " + String.valueOf(nodeType));
        }
        return childrenReferences;
    }

    @Override
    public Set<NodeReference> findAncestors(NodeReferences nodeReferences) {
        Set filteredReferences = nodeReferences.extractNonLibraries();
        if (filteredReferences.isEmpty()) {
            return new HashSet<NodeReference>();
        }
        Map<NodeType, List<NodeReference>> nodeReferencesByType = filteredReferences.stream().collect(Collectors.groupingBy(NodeReference::getNodeType));
        HashSet<NodeReference> ancestors = new HashSet<NodeReference>();
        List testSuitesReferences = nodeReferencesByType.getOrDefault(NodeType.TEST_SUITE, new ArrayList());
        Set<NodeReference> iterationsFromSuites = this.getAncestorReferences(AncestorLookupDefinition.TEST_SUITES_ANCESTORS, testSuitesReferences);
        List iterationsReferences = nodeReferencesByType.getOrDefault(NodeType.ITERATION, new ArrayList());
        ancestors.addAll(iterationsFromSuites);
        iterationsReferences.addAll(iterationsFromSuites);
        Set<NodeReference> campaignFromIterations = this.getAncestorReferences(AncestorLookupDefinition.ITERATION_ANCESTORS, iterationsReferences);
        ancestors.addAll(campaignFromIterations);
        List campaigns = nodeReferencesByType.getOrDefault(NodeType.CAMPAIGN, new ArrayList());
        campaigns.addAll(campaignFromIterations);
        nodeReferencesByType.put(NodeType.CAMPAIGN, new ArrayList(campaigns));
        for (Map.Entry<NodeType, List<NodeReference>> entry : nodeReferencesByType.entrySet()) {
            NodeType nodeType = entry.getKey();
            if (!this.ancestorLookupDefinitions.containsKey(nodeType)) continue;
            Set<NodeReference> ancestorReferences = this.getAncestorReferences(this.ancestorLookupDefinitions.get(nodeType), entry.getValue());
            ancestors.addAll(ancestorReferences);
        }
        return ancestors;
    }

    private Set<NodeReference> getAncestorReferences(AncestorLookupDefinition ancestorLookupDefinition, List<NodeReference> descendants) {
        if (descendants.isEmpty()) {
            return new HashSet<NodeReference>();
        }
        Set<Long> descendantIds = descendants.stream().map(NodeReference::getId).collect(Collectors.toSet());
        SelectConditionStep<Record3<String, Long, Long>> selectQuery = this.craftSelectAncestorRequest(ancestorLookupDefinition, descendantIds);
        return this.buildAncestorsSet(ancestorLookupDefinition, descendants, selectQuery);
    }

    private Set<NodeReference> buildAncestorsSet(AncestorLookupDefinition ancestorLookupDefinition, List<NodeReference> descendants, SelectConditionStep<? extends Record> selectQuery) {
        HashSet<NodeReference> ancestors = new HashSet<NodeReference>();
        selectQuery.forEach(tuple -> {
            Long libraryId;
            NodeType nodeType = NodeType.fromTypeName((String)((String)tuple.get(SIMPLE_CLASS_NAME, String.class)));
            NodeReference candidate = new NodeReference(nodeType, (Long)tuple.get(ancestorLookupDefinition.getAncestorField()));
            if (!descendants.contains(candidate)) {
                ancestors.add(candidate);
            }
            if (Objects.nonNull(ancestorLookupDefinition.getLibraryField()) && Objects.nonNull(libraryId = (Long)tuple.get(ancestorLookupDefinition.getLibraryField()))) {
                ancestors.add(new NodeReference(ancestorLookupDefinition.getNodeType().getLibraryType(), libraryId));
            }
        });
        return ancestors;
    }

    private SelectConditionStep<Record3<String, Long, Long>> craftSelectAncestorRequest(AncestorLookupDefinition ancestorLookupDefinition, Set<Long> descendantIds) {
        Stack requestPart = new Stack();
        ancestorLookupDefinition.getRelationshipIds().forEach((key, field) -> {
            SelectOnConditionStep initialJoin = this.dsl.select((SelectField)DSL.val((String)key.getTypeName()).as(SIMPLE_CLASS_NAME), ancestorLookupDefinition.getAncestorField(), ancestorLookupDefinition.getLibraryField()).from((TableLike)ancestorLookupDefinition.getAncestorField().getTable()).innerJoin((TableLike)field.getTable()).on(ancestorLookupDefinition.getAncestorField().eq((Field)field));
            if (Objects.nonNull(ancestorLookupDefinition.getLibraryField())) {
                initialJoin = initialJoin.leftJoin((TableLike)ancestorLookupDefinition.getLibraryContentField().getTable()).on(ancestorLookupDefinition.getLibraryContentField().eq(ancestorLookupDefinition.getAncestorField()));
            }
            ancestorLookupDefinition.addAdditionalJoins((SelectOnConditionStep<Record3<String, Long, Long>>)initialJoin, (NodeType)key);
            SelectConditionStep query = initialJoin.where(ancestorLookupDefinition.getDescendantField().in((Collection)descendantIds));
            ancestorLookupDefinition.addAdditionalCondition((SelectConditionStep<Record3<String, Long, Long>>)query, (NodeType)key);
            requestPart.push(query);
        });
        SelectConditionStep selectQuery = (SelectConditionStep)requestPart.pop();
        while (!requestPart.empty()) {
            selectQuery.union((Select)requestPart.pop());
        }
        return selectQuery;
    }

    private ListMultimap<NodeReference, NodeReference> getChildrenReferences(RelationshipDefinition relationshipDefinition, Set<Long> ancestorIds) {
        Stack requestPart = new Stack();
        String simpleClassName = SIMPLE_CLASS_NAME;
        relationshipDefinition.getRelationshipIds().forEach((key, field) -> {
            SelectOnConditionStep joinQuery = this.dsl.select((SelectField)DSL.val((String)key.getTypeName()).as(simpleClassName), relationshipDefinition.getAncestorField(), relationshipDefinition.getDescendantField(), relationshipDefinition.getOrderField()).from((TableLike)relationshipDefinition.getAncestorField().getTable()).innerJoin((TableLike)field.getTable()).on(relationshipDefinition.getDescendantField().eq((Field)field));
            relationshipDefinition.addAdditionalJoins((SelectOnConditionStep<Record4<String, Long, Long, Integer>>)joinQuery, (NodeType)key);
            SelectConditionStep query = joinQuery.where(relationshipDefinition.getAncestorField().in((Collection)ancestorIds));
            relationshipDefinition.addAdditionalCriteria((SelectConditionStep<Record4<String, Long, Long, Integer>>)query, (NodeType)key);
            requestPart.push(query);
        });
        SelectConditionStep selectQuery = (SelectConditionStep)requestPart.pop();
        while (!requestPart.empty()) {
            selectQuery.union((Select)requestPart.pop());
        }
        selectQuery.orderBy(relationshipDefinition.getAncestorField(), relationshipDefinition.getOrderField());
        ArrayListMultimap childrenRef = ArrayListMultimap.create();
        selectQuery.fetch().forEach(arg_0 -> MultipleHierarchyTreeBrowserDaoImpl.lambda$12(simpleClassName, relationshipDefinition, (ListMultimap)childrenRef, arg_0));
        return childrenRef;
    }

    private static /* synthetic */ void lambda$12(String string, RelationshipDefinition relationshipDefinition, ListMultimap listMultimap, Record4 tuple) {
        NodeType nodeType = NodeType.fromTypeName((String)((String)tuple.get(string, String.class)));
        NodeReference childRef = new NodeReference(nodeType, (Long)tuple.get(relationshipDefinition.getDescendantField()));
        listMultimap.put((Object)new NodeReference(relationshipDefinition.getNodeType(), (Long)tuple.get(relationshipDefinition.getAncestorField())), (Object)childRef);
    }
}

