/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.query;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.QCampaign;
import org.squashtest.tm.domain.campaign.QIteration;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.QCustomFieldValue;
import org.squashtest.tm.domain.customfield.QCustomFieldValueOption;
import org.squashtest.tm.domain.customfield.QTagsValue;
import org.squashtest.tm.domain.execution.QExecution;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.query.ColumnType;
import org.squashtest.tm.domain.query.DataType;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.query.QueryColumnPrototypeInstance;
import org.squashtest.tm.domain.requirement.QRequirementVersion;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.service.internal.query.DomainGraph;
import org.squashtest.tm.service.internal.query.InternalEntityType;
import org.squashtest.tm.service.internal.query.InternalQueryModel;
import org.squashtest.tm.service.internal.query.PlannedJoin;
import org.squashtest.tm.service.internal.query.QueryPlan;
import org.squashtest.tm.service.internal.query.QuerydslToolbox;

class QueryPlanner {
    private InternalQueryModel internalQueryModel;
    private QuerydslToolbox utils;
    private Set<String> aliases = new HashSet<String>();
    private InternalEntityType graphSeed;
    private Iterator<InternalEntityType> seedIterator;
    private ExtendedHibernateQuery<?> query;

    QueryPlanner() {
    }

    QueryPlanner(InternalQueryModel internalQueryModel) {
        this.internalQueryModel = internalQueryModel;
        this.utils = new QuerydslToolbox();
    }

    QueryPlanner(InternalQueryModel internalQueryModel, QuerydslToolbox utils) {
        this.internalQueryModel = internalQueryModel;
        this.utils = utils;
    }

    QueryPlanner appendToQuery(ExtendedHibernateQuery<?> existingQuery) {
        this.query = existingQuery;
        return this;
    }

    QueryPlanner joinRootEntityOn(EntityPathBase<?> mainJoinEntity) {
        this.utils.forceAlias(this.internalQueryModel.getRootEntity(), mainJoinEntity.getMetadata().getName());
        return this;
    }

    ExtendedHibernateQuery<?> createQuery() {
        this.query = new ExtendedHibernateQuery();
        this.doTheJob();
        this.appendCufJoins();
        return this.query;
    }

    void modifyQuery() {
        this.doTheJob();
    }

    private void doTheJob() {
        QueryPlan plan = this.createQueryPlan();
        this.init();
        Iterator<PlannedJoin> iterator = plan.joinIterator();
        while (iterator.hasNext()) {
            PlannedJoin join = iterator.next();
            this.addJoin(join);
        }
        for (QueryColumnPrototypeInstance queryColumnPrototypeInstance : this.internalQueryModel.getInlinedColumns()) {
            EntityPathBase<?> subRootpath = this.utils.getQBean(queryColumnPrototypeInstance.getColumn().getSpecializedType());
            InternalQueryModel detailedSub = InternalQueryModel.createFor(queryColumnPrototypeInstance);
            QuerydslToolbox toolbox = new QuerydslToolbox(queryColumnPrototypeInstance);
            QueryPlanner subPlanner = new QueryPlanner(detailedSub, toolbox).appendToQuery(this.query).joinRootEntityOn(subRootpath);
            subPlanner.modifyQuery();
        }
    }

    private void nextSeed() {
        if (this.seedIterator == null) {
            this.seedIterator = this.internalQueryModel.getTargetEntities().iterator();
        }
        if (!this.seedIterator.hasNext()) {
            throw new RuntimeException("The query cannot be generated : could not find a query plan that would join together all the targeted entities");
        }
        this.graphSeed = this.seedIterator.next();
    }

    private QueryPlan createQueryPlan() {
        DomainGraph graph;
        QueryPlan plan;
        do {
            this.nextSeed();
        } while (!this.isEveryEntityReachable(plan = (graph = new DomainGraph(this.internalQueryModel, this.graphSeed)).getQueryPlan()));
        return plan;
    }

    private void init() {
        this.aliases = this.utils.getJoinedAliases(this.query);
        EntityPathBase<?> rootPath = this.utils.getQBean(this.graphSeed);
        if (!this.isKnown(rootPath)) {
            this.query.from(rootPath);
        }
    }

    private void addJoin(PlannedJoin joininfo) {
        EntityPathBase<?> src = this.utils.getQBean(joininfo.getSrc());
        EntityPathBase<?> dest = this.utils.getQBean(joininfo.getDest());
        String attribute = joininfo.getAttribute();
        if (joininfo.getType() == PlannedJoin.JoinType.MAPPED) {
            this.addMappedJoin(src, dest, attribute);
        } else {
            this.addUnmappedJoin(src, dest, attribute);
        }
        this.registerAlias(src);
        this.registerAlias(dest);
    }

    private void addMappedJoin(EntityPathBase<?> src, EntityPathBase<?> dest, String srcNavigableAttribute) {
        if (!this.isKnown(dest)) {
            PathBuilder join = this.utils.makePath(src, dest, srcNavigableAttribute);
            switch (this.internalQueryModel.getJoinStyle()) {
                case INNER_JOIN: {
                    this.query.innerJoin((EntityPath)join, dest);
                    break;
                }
                case LEFT_JOIN: {
                    this.query.leftJoin((EntityPath)join, dest);
                    break;
                }
            }
        }
    }

    private void addUnmappedJoin(EntityPathBase<?> src, EntityPathBase<?> dest, String destNavigableAttribute) {
        if (!this.isKnown(dest)) {
            PathBuilder join = this.utils.makePath(dest, src, destNavigableAttribute);
            switch (this.internalQueryModel.getJoinStyle()) {
                case INNER_JOIN: {
                    ((HibernateQuery)this.query.innerJoin(dest)).on((Predicate)join.eq(src));
                    break;
                }
                case LEFT_JOIN: {
                    ((HibernateQuery)this.query.leftJoin(dest)).on((Predicate)join.eq(src));
                    break;
                }
            }
        }
    }

    private void appendCufJoins() {
        Map<QueryColumnPrototype, Set<Long>> cufPrototypesWithIds = this.extractAllCufPrototype();
        this.createCufJoins(cufPrototypesWithIds);
    }

    private Map<QueryColumnPrototype, Set<Long>> extractAllCufPrototype() {
        HashMap<QueryColumnPrototype, Set<Long>> cufPrototypesWithIds = new HashMap<QueryColumnPrototype, Set<Long>>();
        this.extractCufPrototype(cufPrototypesWithIds, this.internalQueryModel.getFilterColumns());
        this.extractCufPrototype(cufPrototypesWithIds, this.internalQueryModel.getAggregationColumns());
        this.extractCufPrototype(cufPrototypesWithIds, this.internalQueryModel.getProjectionColumns());
        this.extractCufPrototype(cufPrototypesWithIds, this.internalQueryModel.getOrderingColumns());
        return cufPrototypesWithIds;
    }

    private void extractCufPrototype(Map<QueryColumnPrototype, Set<Long>> cufPrototypesWithIds, List<? extends QueryColumnPrototypeInstance> prototypes) {
        for (QueryColumnPrototypeInstance queryColumnPrototypeInstance : prototypes) {
            QueryColumnPrototype columnPrototype = queryColumnPrototypeInstance.getColumn();
            if (columnPrototype.getColumnType() != ColumnType.CUF) continue;
            Set<Long> cufIds = cufPrototypesWithIds.get(columnPrototype);
            if (cufIds == null) {
                HashSet<Long> ids = new HashSet<Long>();
                ids.add(queryColumnPrototypeInstance.getCufId());
                cufPrototypesWithIds.put(columnPrototype, ids);
                continue;
            }
            cufIds.add(queryColumnPrototypeInstance.getCufId());
        }
    }

    private void createCufJoins(Map<QueryColumnPrototype, Set<Long>> cufPrototypes) {
        for (Map.Entry<QueryColumnPrototype, Set<Long>> entry : cufPrototypes.entrySet()) {
            Set<Long> cufIds = entry.getValue();
            QueryColumnPrototype columnPrototype = entry.getKey();
            for (Long cufId : cufIds) {
                String alias = this.utils.getCustomFieldValueStandardTableAlias(columnPrototype, cufId);
                if (columnPrototype.getDataType().equals((Object)DataType.TAG)) {
                    String cufValueOptionAlias = this.utils.getCustomFieldValueOptionTableAlias(columnPrototype, cufId);
                    this.createJoinForMultipleValues(columnPrototype, cufId, alias, cufValueOptionAlias);
                    continue;
                }
                this.createJoinForUniqueValue(columnPrototype, cufId, alias);
            }
        }
    }

    private void createJoinForUniqueValue(QueryColumnPrototype columnPrototype, Long cufId, String alias) {
        QCustomFieldValue qCustomFieldValue = new QCustomFieldValue(alias);
        BindableEntity boundEntityType = this.getBoundEntityType(columnPrototype);
        ((HibernateQuery)this.query.join((EntityPath)qCustomFieldValue)).on((Predicate)qCustomFieldValue.boundEntityType.eq((Object)boundEntityType).and((Predicate)qCustomFieldValue.boundEntityId.eq(this.getEntityIdForCufValue(columnPrototype))));
        this.query.where((Predicate)qCustomFieldValue.cufId.eq((Object)cufId));
    }

    private void createJoinForMultipleValues(QueryColumnPrototype columnPrototype, Long cufId, String alias, String cufValueOptionAlias) {
        QTagsValue qTagsValue = new QTagsValue(alias);
        BindableEntity boundEntityType = this.getBoundEntityType(columnPrototype);
        ((HibernateQuery)this.query.join((EntityPath)qTagsValue)).on((Predicate)qTagsValue.boundEntityType.eq((Object)boundEntityType).and((Predicate)qTagsValue.boundEntityId.eq(this.getEntityIdForCufValue(columnPrototype))));
        if (!this.query.toString().contains(cufValueOptionAlias)) {
            QCustomFieldValueOption qCustomFieldValueOption = new QCustomFieldValueOption(cufValueOptionAlias);
            this.query.innerJoin((CollectionExpression)qTagsValue.selectedOptions, (Path)qCustomFieldValueOption);
        }
        this.query.where((Predicate)qTagsValue.cufId.eq((Object)cufId));
    }

    private NumberPath<Long> getEntityIdForCufValue(QueryColumnPrototype columnPrototype) {
        EntityType entityType = columnPrototype.getEntityType();
        return switch (entityType) {
            case EntityType.TEST_CASE -> QTestCase.testCase.id;
            case EntityType.REQUIREMENT_VERSION -> QRequirementVersion.requirementVersion.id;
            case EntityType.CAMPAIGN -> QCampaign.campaign.id;
            case EntityType.ITERATION -> QIteration.iteration.id;
            case EntityType.EXECUTION -> QExecution.execution.id;
            default -> throw new IllegalArgumentException("This entity type couldn't have cuf bound to them or can't actually be in custom report chart.");
        };
    }

    private BindableEntity getBoundEntityType(QueryColumnPrototype columnPrototype) {
        EntityType entityType = columnPrototype.getEntityType();
        return switch (entityType) {
            case EntityType.TEST_CASE -> BindableEntity.TEST_CASE;
            case EntityType.TEST_CASE_STEP -> BindableEntity.TEST_STEP;
            case EntityType.REQUIREMENT_VERSION -> BindableEntity.REQUIREMENT_VERSION;
            case EntityType.CAMPAIGN -> BindableEntity.CAMPAIGN;
            case EntityType.ITERATION -> BindableEntity.ITERATION;
            case EntityType.TEST_SUITE -> BindableEntity.TEST_SUITE;
            case EntityType.EXECUTION -> BindableEntity.EXECUTION;
            default -> throw new IllegalArgumentException("This entity type couldn't have cuf bound to them or can't actually be in custom report chart.");
        };
    }

    private boolean isEveryEntityReachable(QueryPlan plan) {
        Set<InternalEntityType> targetEntities = this.internalQueryModel.getTargetEntities();
        List planedEntities = plan.collectKeys();
        return planedEntities.containsAll(targetEntities);
    }

    private boolean isKnown(EntityPathBase<?> path) {
        return this.aliases.contains(path.getMetadata().getName());
    }

    private void registerAlias(EntityPathBase<?> path) {
        this.aliases.add(path.getMetadata().getName());
    }
}

