/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.jsonpathextractor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;
import org.squashtest.tm.exception.artificialintelligence.server.InvalidJsonPathException;
import org.squashtest.tm.service.jsonpathextractor.JsonPathExtractor;

@Component
public class JsonPathExtractorImpl
implements JsonPathExtractor {
    static final Pattern validJsonPathPattern = Pattern.compile("((\\p{L}|\\d|_)+|\\[\\d+])(\\.(\\p{L}|\\d|_)+|\\[\\d+])*");
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public boolean isPathValid(String path) {
        return validJsonPathPattern.matcher(path).matches();
    }

    public static String extract(String json, String path) throws IOException {
        JsonNode rootNode = objectMapper.readTree(json);
        return JsonPathExtractorImpl.extract(rootNode, JsonPathExtractorImpl.split(path), 0, path).asText();
    }

    private static JsonNode extract(JsonNode node, List<String> pathParts, int startIndex, String originalPath) throws InvalidJsonPathException {
        JsonPathExtractorImpl.checkIfNodeIsNullOrMissing(node, pathParts, startIndex, originalPath);
        if (startIndex == pathParts.size()) {
            return node;
        }
        JsonPathExtractorImpl.checkIfNodeIsValueNode(node, pathParts, startIndex, originalPath);
        String part = pathParts.get(startIndex);
        if (part.startsWith("[")) {
            int index = Integer.parseInt(part.substring(1, part.length() - 1));
            JsonPathExtractorImpl.checkNodeIsAnArray(node, pathParts, startIndex, originalPath);
            JsonPathExtractorImpl.checkIndexIsNotOutOfBounds(node, pathParts, startIndex, originalPath, index);
            return JsonPathExtractorImpl.extract(node.get(index), pathParts, startIndex + 1, originalPath);
        }
        JsonPathExtractorImpl.checkNodeIsAnObject(node, pathParts, startIndex, originalPath);
        JsonPathExtractorImpl.checkIfFieldExists(node, pathParts, startIndex, originalPath, part);
        return JsonPathExtractorImpl.extract(node.get(part), pathParts, startIndex + 1, originalPath);
    }

    private static void checkIfNodeIsNullOrMissing(JsonNode node, List<String> pathParts, int startIndex, String originalPath) {
        if (node == null || node.isMissingNode()) {
            String pathSoFar = JsonPathExtractorImpl.buildPathSoFar(pathParts, startIndex);
            throw new InvalidJsonPathException(String.format("Invalid JSON path - Node not found at path '%s'. Full path: '%s'", pathSoFar, originalPath));
        }
    }

    private static void checkIfNodeIsValueNode(JsonNode node, List<String> pathParts, int startIndex, String originalPath) {
        if (node.isValueNode()) {
            String pathSoFar = JsonPathExtractorImpl.buildPathSoFar(pathParts, startIndex);
            throw new InvalidJsonPathException(String.format("Invalid JSON path - Cannot traverse beyond node at path '%s'. Node contains a %s value, but path continues to '%s'", pathSoFar, node.getNodeType(), originalPath));
        }
    }

    private static void checkNodeIsAnArray(JsonNode node, List<String> pathParts, int startIndex, String originalPath) {
        if (!node.isArray()) {
            String pathSoFar = JsonPathExtractorImpl.buildPathSoFar(pathParts, startIndex);
            throw new InvalidJsonPathException(String.format("Invalid JSON path - Expected array at path '%s' but found %s. Full path: '%s'", pathSoFar, node.getNodeType(), originalPath));
        }
    }

    private static void checkIndexIsNotOutOfBounds(JsonNode node, List<String> pathParts, int startIndex, String originalPath, int index) {
        if (index < 0 || index >= node.size()) {
            String pathSoFar = JsonPathExtractorImpl.buildPathSoFar(pathParts, startIndex + 1);
            throw new InvalidJsonPathException(String.format("Invalid JSON path - Array index %d out of bounds at path '%s' (array size: %d). Full path: '%s'", index, pathSoFar, node.size(), originalPath));
        }
    }

    private static void checkNodeIsAnObject(JsonNode node, List<String> pathParts, int startIndex, String originalPath) {
        if (!node.isObject()) {
            String pathSoFar = JsonPathExtractorImpl.buildPathSoFar(pathParts, startIndex);
            throw new InvalidJsonPathException(String.format("Invalid JSON path - Expected object at path '%s' but found %s. Full path: '%s'", pathSoFar, node.getNodeType(), originalPath));
        }
    }

    private static void checkIfFieldExists(JsonNode node, List<String> pathParts, int startIndex, String originalPath, String part) {
        if (!node.has(part)) {
            String pathSoFar = JsonPathExtractorImpl.buildPathSoFar(pathParts, startIndex + 1);
            ArrayList availableFields = new ArrayList();
            node.fieldNames().forEachRemaining(availableFields::add);
            Collections.sort(availableFields);
            throw new InvalidJsonPathException(String.format("Invalid JSON path - Field '%s' not found at path '%s'. Available fields: %s. Full path: '%s'", part, pathSoFar, availableFields, originalPath));
        }
    }

    private static String buildPathSoFar(List<String> pathParts, int upToIndex) {
        if (upToIndex == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < upToIndex && i < pathParts.size()) {
            String part = pathParts.get(i);
            if (part.startsWith("[")) {
                sb.append(part);
            } else {
                if (!sb.isEmpty()) {
                    sb.append(".");
                }
                sb.append(part);
            }
            ++i;
        }
        return sb.toString();
    }

    private static List<String> split(String str) {
        Matcher m = Pattern.compile("\\[\\d+]|\\w+").matcher(str);
        ArrayList<String> matches = new ArrayList<String>();
        while (m.find()) {
            matches.add(m.group());
        }
        return matches;
    }
}

