/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.annotation;

import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.exception.requirement.MilestoneForbidModificationException;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.CheckBlockingMilestones;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.internal.repository.MilestoneDao;

@Aspect
@Component
public class CheckBlockingMilestoneAspect {
    private static final String ADVISING_METHOD = "Advising method {}{}.";
    private static final String FOUND_ID_IN_METHOD = "Found required @{} on arg #{} of method {}.";
    private static final String LOCKED_MILESTONE_MESSAGE = "This element is bound to a locked milestone. It can't be modified";
    private static final String LOCKED_MILESTONES_MESSAGE = "At least one element is bound to a locked milestone. It can't be modified";
    private static final String MISSING_ID_PARAMETER = "Could not find any argument annotated @Id in @CheckBlockingMilestone method %s%s. This must be a structural programming error.";
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckBlockingMilestone.class);
    @Inject
    private MilestoneDao milestoneDao;

    @Around(value="execution(@org.squashtest.tm.service.annotation.CheckBlockingMilestone * * (..)) && @annotation(args)", argNames="args")
    public Object checkBlockingMilestone(ProceedingJoinPoint pjp, CheckBlockingMilestone args) throws Throwable {
        long id = this.findEntityId(pjp);
        Class<?> entityType = args.entityType();
        boolean isEntityBoundToBlockingMilestone = switch (entityType.getSimpleName()) {
            case "Requirement" -> this.milestoneDao.isRequirementBoundToBlockingMilestone(id);
            case "RequirementVersion" -> this.milestoneDao.isRequirementVersionBoundToBlockingMilestone(id);
            case "TestCase" -> this.milestoneDao.isTestCaseMilestoneModifiable(id);
            case "TestStep" -> this.milestoneDao.isTestStepBoundToBlockingMilestone(id);
            case "Parameter" -> this.milestoneDao.isParameterBoundToBlockingMilestone(id);
            case "Dataset" -> this.milestoneDao.isDatasetBoundToBlockingMilestone(id);
            case "DatasetParamValue" -> this.milestoneDao.isDatasetParamValueBoundToBlockingMilestone(id);
            case "AttachmentList" -> this.milestoneDao.isAttachmentListBoundToBlockingMilestone(id);
            case "Attachment" -> this.milestoneDao.isAttachmentBoundToBlockingMilestone(id);
            case "Campaign" -> this.milestoneDao.isCampaignBoundToBlockingMilestone(id);
            case "Iteration" -> this.milestoneDao.isIterationBoundToBlockingMilestone(id);
            case "TestSuite" -> this.milestoneDao.isTestSuiteBoundToBlockingMilestone(id);
            case "CampaignTestPlanItem" -> this.milestoneDao.isCampaignTestPlanItemBoundToBlockingMilestone(id);
            case "Execution" -> this.milestoneDao.isExecutionBoundToBlockingMilestone(id);
            case "ExecutionStep" -> this.milestoneDao.isExecutionStepBoundToBlockingMilestone(id);
            case "TestPlanItem" -> this.milestoneDao.isTestPlanItemBoundToBlockingMilestone(id);
            default -> throw new UnsupportedOperationException("Cannot check locked milestones for entity type " + entityType.getSimpleName());
        };
        if (isEntityBoundToBlockingMilestone) {
            throw new MilestoneForbidModificationException(LOCKED_MILESTONE_MESSAGE);
        }
        return pjp.proceed();
    }

    private long findEntityId(ProceedingJoinPoint pjp) {
        return (Long)this.findAnnotatedParamValue(pjp, Id.class);
    }

    @Around(value="execution(@org.squashtest.tm.service.annotation.CheckBlockingMilestones * * (..)) && @annotation(args)", argNames="args")
    public Object checkBlockingMilestoneMultiple(ProceedingJoinPoint pjp, CheckBlockingMilestones args) throws Throwable {
        Collection<Long> ids = this.findEntitiesIds(pjp);
        Class<?> entityType = args.entityType();
        boolean areEntitiesBoundToBlockingMilestone = switch (entityType.getSimpleName()) {
            case "Requirement" -> this.milestoneDao.areRequirementsBoundToBlockingMilestone(ids);
            case "TestCase" -> this.milestoneDao.areTestCasesBoundToBlockingMilestone(ids);
            case "Campaign" -> this.milestoneDao.areCampaignsBoundToBlockingMilestone(ids);
            case "TestSuite" -> this.milestoneDao.areTestSuitesBoundToBlockingMilestone(ids);
            default -> throw new UnsupportedOperationException();
        };
        if (areEntitiesBoundToBlockingMilestone) {
            throw new MilestoneForbidModificationException(LOCKED_MILESTONES_MESSAGE);
        }
        return pjp.proceed();
    }

    private Collection<Long> findEntitiesIds(ProceedingJoinPoint pjp) {
        return (Collection)this.findAnnotatedParamValue(pjp, Ids.class);
    }

    private <T> T findAnnotatedParamValue(ProceedingJoinPoint pjp, Class<? extends Annotation> idAnnotation) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        LOGGER.trace(ADVISING_METHOD, new Object[]{signature.getDeclaringTypeName(), method.getName()});
        Annotation[][] annotations = method.getParameterAnnotations();
        int iArg = 0;
        while (iArg < annotations.length) {
            Annotation[] currentArgAnnotations;
            Annotation[] annotationArray = currentArgAnnotations = annotations[iArg];
            int n = currentArgAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (idAnnotation.equals(annotation.annotationType())) {
                    LOGGER.trace(FOUND_ID_IN_METHOD, new Object[]{idAnnotation.getSimpleName(), iArg, method.getName()});
                    return (T)pjp.getArgs()[iArg];
                }
                ++n2;
            }
            ++iArg;
        }
        throw new IllegalArgumentException(String.format(MISSING_ID_PARAMETER, signature.getDeclaringTypeName(), method.getName()));
    }
}

