/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.lang.Wrapped;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.ExploratoryTestCase;
import org.squashtest.tm.domain.testcase.IsScriptedTestCaseVisitor;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.internal.batchimport.Batch;
import org.squashtest.tm.service.internal.batchimport.instruction.ParameterInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.ParameterTarget;
import org.squashtest.tm.service.internal.repository.ParameterDao;
import org.squashtest.tm.service.internal.repository.TestStepDao;
import org.squashtest.tm.service.internal.repository.loaders.testcase.TestCaseLoader;
import org.squashtest.tm.service.internal.testcase.ParameterModificationServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.testcase.ParameterModificationServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.testcase.ParameterNamesFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.SecurityCheckableObject;
import org.squashtest.tm.service.testcase.DatasetModificationService;
import org.squashtest.tm.service.testcase.ParameterModificationService;

@Transactional
@Service(value="squashtest.tm.service.ParameterModificationService")
public class ParameterModificationServiceImpl
implements ParameterModificationService {
    private static final Logger LOGGER;
    @Inject
    private ParameterDao parameterDao;
    @Inject
    private TestStepDao testStepDao;
    @Inject
    private TestCaseLoader testCaseLoader;
    @Inject
    private DatasetModificationService datasetModificationService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @PersistenceContext
    EntityManager entityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        ParameterModificationServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ParameterModificationServiceImpl.class);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Parameter> findOwnParameters(long testCaseId) {
        return this.parameterDao.findOwnParametersByTestCaseOrderedByName(testCaseId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Parameter> findOwnOrderedParameters(long testCaseId) {
        return this.parameterDao.findOwnOrderedParametersByTestCase(testCaseId);
    }

    @Override
    public List<Parameter> findAllParameters(long testCaseId) {
        Map parametersByTestCaseId = this.parameterDao.findAllParametersByTestCaseIds(Collections.singleton(testCaseId));
        return parametersByTestCaseId.getOrDefault(testCaseId, Collections.emptyList());
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public Parameter addNewParameterToTestCase(Parameter parameter, @Id long testCaseId) {
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_PARAMETERS));
        return this.addNewParameterToTestCaseUnsecured(parameter, testCase);
    }

    @Override
    public Parameter addNewParameterToTestCaseUnsecured(Parameter parameter, TestCase testCase) {
        IsScriptedTestCaseVisitor testCaseVisitor = new IsScriptedTestCaseVisitor();
        if (testCaseVisitor.isScripted()) {
            throw new IllegalArgumentException("Cannot add parameters in a scripted test case.");
        }
        if (testCase != null) {
            testCase.accept((TestCaseVisitor)testCaseVisitor);
            this.createAttachmentIfNeeded(parameter, testCase);
            parameter.setTestCase(testCase);
            this.datasetModificationService.cascadeDatasetsUpdate(testCase.getId());
        } else {
            LOGGER.warn("Cannot add parameters because the test case is null.", new Object[0]);
        }
        return parameter;
    }

    private void addNewParameterToTestCase(Parameter parameter, TestCase testCase) {
        this.createAttachmentIfNeeded(parameter, testCase);
        parameter.setTestCase(testCase);
        this.datasetModificationService.cascadeDatasetsUpdate(testCase.getId());
    }

    private void createAttachmentIfNeeded(Parameter parameter, TestCase testCase) {
        String description = parameter.getDescription();
        if (description == null || description.isEmpty()) {
            return;
        }
        String newDescription = this.attachmentManagerService.handleRichTextAttachments(description, testCase.getAttachmentList());
        if (!newDescription.equals(description)) {
            parameter.setDescription(newDescription);
        }
    }

    @Override
    @CheckBlockingMilestone(entityType=Parameter.class)
    public void changeName(@Id long parameterId, String newName) {
        Parameter parameter = this.parameterDao.loadWithTestCase(parameterId);
        TestCase testCase = parameter.getTestCase();
        this.permissionEvaluationService.checkPermission(new SecurityCheckableObject(testCase, Permissions.WRITE.name()));
        parameter.setName(newName);
    }

    @Override
    @CheckBlockingMilestone(entityType=Parameter.class)
    public void changeDescription(@Id long parameterId, String newDescription) {
        Parameter parameter = (Parameter)this.parameterDao.getReferenceById(parameterId);
        parameter.setDescription(newDescription);
    }

    @Override
    public void remove(Parameter parameter) {
        TestCase testCase = parameter.getTestCase();
        this.permissionEvaluationService.checkPermission(new SecurityCheckableObject(testCase, Permissions.WRITE.name()));
        this.parameterDao.delete(parameter);
        testCase.reorderParametersAfterRemoval(parameter);
    }

    @Override
    public void removeAllByTestCaseIds(@Ids List<Long> testCaseIds) {
        List<Long> list = testCaseIds;
        ParameterDao parameterDao = this.parameterDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)parameterDao, list);
        Object[] objectArray = new Object[]{this, parameterDao, list, joinPoint};
        ParameterModificationServiceImpl$AjcClosure1 parameterModificationServiceImpl$AjcClosure1 = new ParameterModificationServiceImpl$AjcClosure1(objectArray);
        SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(parameterModificationServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        List<Long> list2 = testCaseIds;
        ParameterDao parameterDao2 = this.parameterDao;
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)parameterDao2, list2);
        Object[] objectArray2 = new Object[]{this, parameterDao2, list2, joinPoint2};
        ParameterModificationServiceImpl$AjcClosure3 parameterModificationServiceImpl$AjcClosure3 = new ParameterModificationServiceImpl$AjcClosure3(objectArray2);
        SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(parameterModificationServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112));
    }

    @Override
    @CheckBlockingMilestone(entityType=Parameter.class)
    public void removeById(@Id long parameterId) {
        Optional optParameter = this.parameterDao.findById(parameterId);
        if (optParameter.isPresent()) {
            Parameter param = (Parameter)optParameter.get();
            this.remove(param);
        }
    }

    @Override
    @CheckBlockingMilestone(entityType=TestStep.class)
    public void createParamsForStep(@Id long stepId) {
        TestStep step = (TestStep)this.testStepDao.findById(stepId);
        this.createParamsForStep(step);
    }

    @Override
    public void createParamsForStep(TestStep step) {
        LOGGER.debug("creating parameters for step #{}", new Object[]{step.getId()});
        Set<String> parameterNames = new ParameterNamesFinder().findParametersNamesInActionAndExpectedResult(step);
        LOGGER.trace("discovered parameters in step : {} ", new Object[]{parameterNames});
        for (String name : parameterNames) {
            this.createParameterIfNotExists(name, step.getTestCase());
        }
    }

    private void createParameterIfNotExists(String name, TestCase testCase) {
        Parameter parameter;
        if (testCase != null && (parameter = testCase.findParameterByName(name)) == null) {
            LOGGER.debug("declaring new parameter '{}' in test case #{}", new Object[]{name, testCase.getId()});
            parameter = new Parameter(name);
            this.addNewParameterToTestCase(parameter, testCase);
        }
    }

    @Override
    public void createParamsForSteps(Map<Long, TestCase> testCaseById, List<Batch<ActionTestStep>> batchTestSteps) {
        for (Batch<ActionTestStep> batch : batchTestSteps) {
            TestCase testCase = testCaseById.get(batch.getTargetId());
            Set parameterNames = batch.getEntities().stream().flatMap(step -> new ParameterNamesFinder().findParametersNamesInActionAndExpectedResult((TestStep)step).stream()).collect(Collectors.toSet());
            for (String name : parameterNames) {
                Parameter parameter = testCase.findParameterByName(name);
                if (parameter != null) continue;
                parameter = new Parameter(name);
                parameter.setTestCase(testCase);
            }
        }
        this.datasetModificationService.cascadeDatasetsUpdate(testCaseById.keySet());
    }

    @Override
    public boolean isUsed(long parameterId) {
        final Parameter parameter = this.parameterDao.loadWithTestCase(parameterId);
        final long testCaseId = parameter.getTestCase().getId();
        final Wrapped isUsed = new Wrapped();
        TestCaseVisitor visitor = new TestCaseVisitor(){

            public void visit(TestCase testCase) {
                isUsed.setValue((Object)ParameterModificationServiceImpl.this.testStepDao.stringIsFoundInStepsOfTestCase(parameter.getParamStringAsUsedInStep(), testCaseId));
            }

            public void visit(KeywordTestCase keywordTestCase) {
                isUsed.setValue((Object)ParameterModificationServiceImpl.this.testStepDao.stringIsFoundInStepsOfKeywordTestCase(parameter.getParamStringAsUsedInStep(), testCaseId));
            }

            public void visit(ScriptedTestCase scriptedTestCase) {
                throw new IllegalArgumentException("Scripted Test Case doesn't have any parameter.");
            }

            public void visit(ExploratoryTestCase exploratoryTestCase) {
                throw new IllegalArgumentException("Exploratory Test Case doesn't have any parameter.");
            }
        };
        parameter.getTestCase().accept(visitor);
        return (Boolean)isUsed.getValue();
    }

    @Override
    public Parameter findById(long parameterId) {
        return (Parameter)this.parameterDao.getReferenceById(parameterId);
    }

    @Override
    public List<Parameter> findByIds(List<Long> parameterIds) {
        return this.parameterDao.findAllById(parameterIds);
    }

    @Override
    public void createParamsForTestCaseSteps(TestCase testCase) {
        for (TestStep step : testCase.getActionSteps()) {
            this.createParamsForStep(step);
        }
    }

    @Override
    public Map<Long, List<Parameter>> findOwnParametersByTestCaseIds(Collection<Long> testCaseIds) {
        return this.parameterDao.findOwnParametersByTestCaseIds(testCaseIds);
    }

    @Override
    public void batchParameterAddition(List<Batch<Parameter>> parameterBatches) {
        List<Long> testCaseIds = parameterBatches.stream().map(Batch::getTargetId).toList();
        Map testCases = this.testCaseLoader.load(testCaseIds, EnumSet.of(TestCaseLoader.Options.FETCH_PARAMETERS)).stream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
        for (Batch<Parameter> batch : parameterBatches) {
            TestCase testCase = (TestCase)testCases.get(batch.getTargetId());
            IsScriptedTestCaseVisitor testCaseVisitor = new IsScriptedTestCaseVisitor();
            if (testCaseVisitor.isScripted()) {
                throw new IllegalArgumentException("Cannot add parameters in a scripted test case.");
            }
            testCase.accept((TestCaseVisitor)testCaseVisitor);
            for (Parameter parameter : batch.getEntities()) {
                parameter.setTestCase(testCase);
            }
        }
        this.datasetModificationService.cascadeDatasetsUpdate(testCaseIds);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    public void updateImportParameters(List<Batch<ParameterInstruction>> batchList) {
        List<Long> testCaseIds = batchList.stream().map(Batch::getTargetId).toList();
        Map parametersByTestCaseId = this.parameterDao.findParametersByTestCaseIds(testCaseIds);
        for (Batch<ParameterInstruction> batch : batchList) {
            Map<String, Parameter> parameterByName = parametersByTestCaseId.getOrDefault(batch.getTargetId(), Collections.emptyList()).stream().collect(Collectors.toMap(Parameter::getName, param -> param));
            for (ParameterInstruction instruction : batch.getEntities()) {
                String description = instruction.getParameter().getDescription();
                if (description == null) continue;
                Parameter parameter = parameterByName.get(((ParameterTarget)instruction.getTarget()).getName());
                if (parameter == null) {
                    throw new NoSuchElementException("parameter " + String.valueOf(instruction.getTarget()) + " could not be found");
                }
                parameter.setDescription(description);
            }
        }
        this.entityManager.flush();
        this.entityManager.clear();
    }

    static final /* synthetic */ void removeAllValuesByTestCaseIds_aroundBody0(ParameterModificationServiceImpl parameterModificationServiceImpl, ParameterDao parameterDao, List list, JoinPoint joinPoint) {
        parameterDao.removeAllValuesByTestCaseIds(list);
    }

    static final /* synthetic */ void removeAllByTestCaseIds_aroundBody2(ParameterModificationServiceImpl parameterModificationServiceImpl, ParameterDao parameterDao, List list, JoinPoint joinPoint) {
        parameterDao.removeAllByTestCaseIds(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ParameterModificationServiceImpl.java", ParameterModificationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "removeAllValuesByTestCaseIds", "org.squashtest.tm.service.internal.repository.ParameterDao", "java.util.List", "arg0", "", "void"), 212);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "removeAllByTestCaseIds", "org.squashtest.tm.service.internal.repository.ParameterDao", "java.util.List", "arg0", "", "void"), 213);
    }
}

