/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.internal.repository.AutomatedTestDao;
import org.squashtest.tm.service.internal.repository.TestAutomationProjectDao;
import org.squashtest.tm.service.internal.testautomation.FetchTestListFuture;
import org.squashtest.tm.service.internal.testautomation.FetchTestListTask;
import org.squashtest.tm.service.internal.testautomation.TestAutomationConnectorRegistry;
import org.squashtest.tm.service.internal.testautomation.TestAutomationTaskExecutor;
import org.squashtest.tm.service.internal.testautomation.UnsecuredAutomatedTestManagerService;
import org.squashtest.tm.service.scmserver.ScmRepositoryManifest;
import org.squashtest.tm.service.testautomation.model.TestAutomationProjectContent;

@Transactional
@Service(value="squashtest.tm.service.AutomatedTestService")
public class AutomatedTestManagerServiceImpl
implements UnsecuredAutomatedTestManagerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomatedTestManagerServiceImpl.class);
    private static final int DEFAULT_THREAD_TIMEOUT = 30000;
    private int timeoutMillis = 30000;
    @Inject
    private TestAutomationProjectDao projectDao;
    @Inject
    private AutomatedTestDao testDao;
    @Inject
    private TestAutomationConnectorRegistry connectorRegistry;
    private TestAutomationTaskExecutor executor;

    @Inject
    @Transactional(propagation=Propagation.SUPPORTS)
    public void setAsyncTaskExecutor(AsyncTaskExecutor executor) {
        this.executor = new TestAutomationTaskExecutor(executor);
    }

    @Override
    public TestAutomationProject findProjectById(long projectId) {
        return this.projectDao.findById(projectId);
    }

    @Override
    public AutomatedTest persistOrAttach(AutomatedTest newTest) {
        return this.testDao.persistOrAttach(newTest);
    }

    @Override
    public void removeIfUnused(AutomatedTest test) {
        this.testDao.removeIfUnused(test);
    }

    @Override
    public Collection<TestAutomationProjectContent> listTestsInProjects(Collection<TestAutomationProject> projects) {
        Collection<TestAutomationProjectContent> listedFromServers = this.listTestsFromRemoteServers(projects);
        Collection<TestAutomationProjectContent> listedFromScms = this.listTestsFromScm(projects);
        for (TestAutomationProjectContent fromScm : listedFromScms) {
            Optional<TestAutomationProjectContent> maybeFromServer = listedFromServers.stream().filter(proj -> proj.getProject().equals(fromScm.getProject())).findFirst();
            if (!maybeFromServer.isPresent()) continue;
            TestAutomationProjectContent fromServer = maybeFromServer.get();
            fromServer.mergeContent(fromScm);
        }
        return listedFromServers;
    }

    @Override
    public Collection<TestAutomationProjectContent> listTestsFromRemoteServers(Collection<TestAutomationProject> projects) {
        LOGGER.debug("listing tests on remote test automation projects ", new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            List<String> projectNames = projects.stream().map(TestAutomationProject::getJobName).toList();
            LOGGER.trace("projects are : {}", new Object[]{projectNames});
        }
        String username = UserContextHolder.getUsername();
        List<FetchTestListFuture> futures = projects.stream().map(project -> new FetchTestListTask(this.connectorRegistry, (TestAutomationProject)project, username)).map(this.executor::submitFetchTestListTask).toList();
        return futures.stream().map(this::extractFromFuture).toList();
    }

    private TestAutomationProjectContent extractFromFuture(FetchTestListFuture future) {
        try {
            return future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            return future.getTask().buildFailedResult(ex);
        }
    }

    private Collection<TestAutomationProjectContent> listTestsFromScm(Collection<TestAutomationProject> autoprojects) {
        ArrayList<TestAutomationProjectContent> allContent = new ArrayList<TestAutomationProjectContent>();
        LOGGER.debug("retrieving test automation project content from repositories", new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            List<String> taNames = autoprojects.stream().map(TestAutomationProject::getLabel).toList();
            LOGGER.trace("automation projects : {}", new Object[]{taNames});
        }
        Map<ScmRepository, List<TestAutomationProject>> byTmProject = this.automationProjectsGroupByScm(autoprojects);
        for (Map.Entry<ScmRepository, List<TestAutomationProject>> groupedAutoprojects : byTmProject.entrySet()) {
            ScmRepository scm = groupedAutoprojects.getKey();
            List<TestAutomationProject> taProjects = groupedAutoprojects.getValue();
            Collection<TestAutomationProjectContent> content = this.processAutoprojectSubset(scm, taProjects);
            allContent.addAll(content);
        }
        return allContent;
    }

    private Map<ScmRepository, List<TestAutomationProject>> automationProjectsGroupByScm(Collection<TestAutomationProject> autoprojects) {
        return autoprojects.stream().filter(auto -> auto.getTmProject().getScmRepository() != null).collect(Collectors.groupingBy(auto -> auto.getTmProject().getScmRepository()));
    }

    private Collection<TestAutomationProjectContent> processAutoprojectSubset(ScmRepository scm, Collection<TestAutomationProject> projects) {
        if (LOGGER.isTraceEnabled()) {
            List<String> taNames = projects.stream().map(TestAutomationProject::getLabel).toList();
            LOGGER.trace("inspecting content of repository '{}' and automation projects {}", new Object[]{scm.getName(), taNames});
        }
        try {
            ArrayList<TestAutomationProjectContent> allContent = new ArrayList<TestAutomationProjectContent>();
            Map<TestCaseKind, List<String>> testsByTech = this.groupTestsByTechnology(scm);
            Map<TestCaseKind, List<TestAutomationProjectContent>> projectContentsByTech = this.groupProjectsByTechnology(projects);
            for (TestCaseKind kind : testsByTech.keySet()) {
                List<String> testPathsForKind = testsByTech.getOrDefault(kind, Collections.emptyList());
                List<TestAutomationProjectContent> contentForKind = projectContentsByTech.getOrDefault(kind, Collections.emptyList());
                this.populateProjectContents(testPathsForKind, contentForKind);
                allContent.addAll(contentForKind);
            }
            return allContent;
        }
        catch (Exception exception) {
            LOGGER.error("Error while retrieving tests from repository '{}', which prevented to populate the automation projects test list", new Object[]{scm.getName(), exception});
            return this.buildFailedContent(exception, projects);
        }
    }

    private Collection<TestAutomationProjectContent> buildFailedContent(Exception ex, Collection<TestAutomationProject> projects) {
        return projects.stream().map(proj -> new TestAutomationProjectContent((TestAutomationProject)proj, ex)).toList();
    }

    private void populateProjectContents(List<String> testPathsForKind, List<TestAutomationProjectContent> contentForKind) {
        for (TestAutomationProjectContent content : contentForKind) {
            TestAutomationProject taProject = content.getProject();
            for (String path : testPathsForKind) {
                AutomatedTest taTest = new AutomatedTest(path, taProject);
                content.appendTest(taTest);
            }
        }
    }

    private Map<TestCaseKind, List<String>> groupTestsByTechnology(ScmRepository scm) throws IOException {
        return new ScmRepositoryManifest(scm).streamTestsRelativePath().sorted().collect(Collectors.groupingBy(this::identifyTestKind));
    }

    private Map<TestCaseKind, List<TestAutomationProjectContent>> groupProjectsByTechnology(Collection<TestAutomationProject> autoprojects) {
        return autoprojects.stream().sorted(Comparator.comparing(TestAutomationProject::getLabel)).map(TestAutomationProjectContent::new).collect(Collectors.groupingBy(this::identifyProjectTechnology));
    }

    private TestCaseKind identifyTestKind(String testPath) {
        return this.isTestGherkin(testPath) ? TestCaseKind.GHERKIN : TestCaseKind.STANDARD;
    }

    private boolean isTestGherkin(String testPath) {
        return testPath.endsWith("feature");
    }

    private TestCaseKind identifyProjectTechnology(TestAutomationProjectContent projectContent) {
        return projectContent.getProject().isCanRunGherkin() ? TestCaseKind.GHERKIN : TestCaseKind.STANDARD;
    }
}

