/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.ActionWord;
import org.squashtest.tm.jooq.domain.tables.ActionWordLibraryNode;
import org.squashtest.tm.jooq.domain.tables.KeywordTestCase;
import org.squashtest.tm.service.internal.display.dto.testcase.ActionWordNameDto;
import org.squashtest.tm.service.internal.repository.CustomActionWordDao;

@Repository
@Transactional
public class ActionWordDaoImpl
implements CustomActionWordDao {
    @Inject
    private DSLContext dsl;
    @PersistenceContext
    private EntityManager em;

    @Override
    public void updateActionWordImplInfoFromAutomRequestIds(Collection<Long> automationRequestIds) {
        Map<String, List<Long>> actionWordIdsMappedByImplTechno = this.findActionWordIdMappedByBddImplTechno(automationRequestIds);
        for (Map.Entry<String, List<Long>> entry : actionWordIdsMappedByImplTechno.entrySet()) {
            String implementationTechnology = entry.getKey();
            Collection actionWordIds = entry.getValue();
            this.updateActionWordsImplInfo(actionWordIds, implementationTechnology);
        }
    }

    private Map<String, List<Long>> findActionWordIdMappedByBddImplTechno(Collection<Long> automationRequestIds) {
        return this.dsl.selectDistinct((SelectField)Tables.PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY, (SelectField)Tables.ACTION_WORD.ACTION_WORD_ID).from((TableLike)Tables.AUTOMATION_REQUEST).join((TableLike)Tables.TEST_CASE).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.TEST_CASE.AUTOMATION_REQUEST_ID)).join((TableLike)KeywordTestCase.KEYWORD_TEST_CASE).on(KeywordTestCase.KEYWORD_TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)KeywordTestCase.KEYWORD_TEST_CASE.TCLN_ID)).join((TableLike)Tables.KEYWORD_TEST_STEP).on(Tables.KEYWORD_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).join((TableLike)Tables.ACTION_WORD).on(Tables.ACTION_WORD.ACTION_WORD_ID.eq((Field)Tables.KEYWORD_TEST_STEP.ACTION_WORD_ID)).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.AUTOMATION_REQUEST.PROJECT_ID)).where(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.in(automationRequestIds)).fetchGroups((Field)Tables.PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY, (Field)Tables.ACTION_WORD.ACTION_WORD_ID);
    }

    private void updateActionWordsImplInfo(Collection<Long> actionWordIds, String implementationTechnology) {
        this.dsl.update((Table)Tables.ACTION_WORD).set((Field)Tables.ACTION_WORD.LAST_IMPLEMENTATION_TECHNOLOGY, (Object)implementationTechnology).set((Field)Tables.ACTION_WORD.LAST_IMPLEMENTATION_DATE, DSL.currentTimestamp()).where(Tables.ACTION_WORD.ACTION_WORD_ID.in(actionWordIds)).execute();
    }

    @Override
    public List<String> findAllCaseInsensitiveDuplicateActions() {
        List duplicateActionWords = this.dsl.select((SelectField)DSL.min((Field)Tables.ACTION_WORD.ACTION_WORD_ID).as("ID"), (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME")).from((TableLike)Tables.ACTION_WORD).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.ACTION_WORD.PROJECT_ID)).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID, DSL.lower((Field)Tables.ACTION_WORD.TOKEN)}).having(DSL.count().greaterThan((Object)1)).orderBy((OrderField)Tables.PROJECT.PROJECT_ID, (OrderField)DSL.lower((Field)Tables.ACTION_WORD.TOKEN)).fetchInto(ActionWordDto.class);
        if (duplicateActionWords.isEmpty()) {
            return new ArrayList<String>();
        }
        List<Long> duplicateActionWordIds = duplicateActionWords.stream().map(ActionWordDto::getId).toList();
        List<ActionWordFragmentWithValueDto> actionWordFragments = this.dsl.select((SelectField)Tables.ACTION_WORD_TEXT.TEXT.as("VALUE"), (SelectField)Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_ID, (SelectField)Tables.ACTION_WORD_FRAGMENT.FRAGMENT_ORDER).from((TableLike)Tables.ACTION_WORD_FRAGMENT).innerJoin((TableLike)Tables.ACTION_WORD_TEXT).on(Tables.ACTION_WORD_TEXT.ACTION_WORD_FRAGMENT_ID.eq((Field)Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_FRAGMENT_ID)).where(Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_ID.in(duplicateActionWordIds)).union((Select)this.dsl.select((SelectField)DSL.concat((Field[])new Field[]{DSL.val((String)"\""), Tables.ACTION_WORD_PARAMETER.NAME, DSL.val((String)"\"")}).as("VALUE"), (SelectField)Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_ID, (SelectField)Tables.ACTION_WORD_FRAGMENT.FRAGMENT_ORDER).from((TableLike)Tables.ACTION_WORD_FRAGMENT).innerJoin((TableLike)Tables.ACTION_WORD_PARAMETER).on(Tables.ACTION_WORD_PARAMETER.ACTION_WORD_FRAGMENT_ID.eq((Field)Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_FRAGMENT_ID)).where(Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_ID.in(duplicateActionWordIds))).orderBy((OrderField)Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_ID, (OrderField)Tables.ACTION_WORD_FRAGMENT.FRAGMENT_ORDER).fetch().stream().map(record -> new ActionWordFragmentWithValueDto((Long)record.get((Field)Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_ID), record.get("VALUE").toString())).toList();
        return duplicateActionWords.stream().map(actionWord -> {
            List<ActionWordFragmentWithValueDto> fragmentList = actionWordFragments.stream().filter(fragment -> actionWord.getId().equals(fragment.getActionWordId())).toList();
            String actionWithParamNames = fragmentList.stream().map(ActionWordFragmentWithValueDto::getValue).collect(Collectors.joining());
            return actionWithParamNames.toLowerCase() + " - " + actionWord.getProjectName();
        }).toList();
    }

    @Override
    public Map<Long, Long> findAllWithDuplicateTokenByProjectId(Long projectId) {
        ActionWord duplicateTokenActionWord = Tables.ACTION_WORD.as("duplicateTokenActionWord");
        Field duplicateTokenActionWordIdField = duplicateTokenActionWord.ACTION_WORD_ID.as("duplicateActionWordId");
        return this.dsl.select((SelectField)Tables.ACTION_WORD.ACTION_WORD_ID, (SelectField)DSL.min((Field)duplicateTokenActionWord.ACTION_WORD_ID).as(duplicateTokenActionWordIdField)).from((TableLike)Tables.ACTION_WORD).join((TableLike)duplicateTokenActionWord).on(Tables.ACTION_WORD.TOKEN.eq((Field)duplicateTokenActionWord.TOKEN)).where(Tables.ACTION_WORD.PROJECT_ID.eq((Object)projectId)).and(duplicateTokenActionWord.PROJECT_ID.ne((Object)projectId)).groupBy(new GroupField[]{Tables.ACTION_WORD.ACTION_WORD_ID}).fetchMap((Field)Tables.ACTION_WORD.ACTION_WORD_ID, duplicateTokenActionWordIdField);
    }

    @Override
    public Map<Long, Long> findAllWithoutDuplicateTokenByProjectId(Long projectId) {
        ActionWordLibraryNode projectAwln = Tables.ACTION_WORD_LIBRARY_NODE.as("projectAwln");
        return this.dsl.select((SelectField)Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID, (SelectField)DSL.min((Field)projectAwln.AWLN_ID)).from((TableLike)Tables.ACTION_WORD).join((TableLike)Tables.KEYWORD_TEST_STEP).on(Tables.KEYWORD_TEST_STEP.ACTION_WORD_ID.eq((Field)Tables.ACTION_WORD.ACTION_WORD_ID)).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).join((TableLike)Tables.ACTION_WORD_LIBRARY_NODE).on(Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_ID.eq((Field)Tables.ACTION_WORD.ACTION_WORD_ID).and(Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_TYPE.eq((Object)"ACTION_WORD"))).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).join((TableLike)projectAwln).on(projectAwln.ENTITY_ID.eq((Field)Tables.PROJECT.AWL_ID).and(projectAwln.ENTITY_TYPE.eq((Object)"LIBRARY"))).where(Tables.ACTION_WORD.PROJECT_ID.eq((Object)projectId)).and(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.ne((Object)projectId)).groupBy(new GroupField[]{Tables.ACTION_WORD.ACTION_WORD_ID, Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID}).fetchMap((Field)Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID, (Field)DSL.min((Field)projectAwln.AWLN_ID));
    }

    @Override
    public List<ActionWordNameDto> findByProjectIdOrderByProjectId(List<Long> projectIds) {
        ActionWord aw = Tables.ACTION_WORD.as("AW");
        return this.dsl.select((SelectField)aw.ACTION_WORD_ID.as("ID"), (SelectField)aw.PROJECT_ID.as("PROJECT_ID"), (SelectField)DSL.field((Select)this.dsl.select((SelectField)DSL.groupConcat((Field)DSL.coalesce((Field)Tables.ACTION_WORD_TEXT.TEXT, (Field[])new Field[]{DSL.concat((Field[])new Field[]{DSL.inline((String)"\""), DSL.decode().when(Tables.ACTION_WORD_PARAMETER.DEFAULT_VALUE.isNotNull().and(Tables.ACTION_WORD_PARAMETER.DEFAULT_VALUE.notEqual((Object)"")), (Field)Tables.ACTION_WORD_PARAMETER.DEFAULT_VALUE).otherwise((Field)Tables.ACTION_WORD_PARAMETER.NAME), DSL.inline((String)"\"")})})).orderBy(new OrderField[]{Tables.ACTION_WORD_FRAGMENT.FRAGMENT_ORDER}).separator("")).from((TableLike)Tables.ACTION_WORD).join((TableLike)Tables.ACTION_WORD_FRAGMENT).on(Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_ID.eq((Field)Tables.ACTION_WORD.ACTION_WORD_ID)).leftJoin((TableLike)Tables.ACTION_WORD_TEXT).on(Tables.ACTION_WORD_TEXT.ACTION_WORD_FRAGMENT_ID.eq((Field)Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_FRAGMENT_ID)).leftJoin((TableLike)Tables.ACTION_WORD_PARAMETER).on(Tables.ACTION_WORD_PARAMETER.ACTION_WORD_FRAGMENT_ID.eq((Field)Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_FRAGMENT_ID)).where(aw.ACTION_WORD_ID.eq((Field)Tables.ACTION_WORD.ACTION_WORD_ID))).as("NAME")).from((TableLike)aw).where(aw.PROJECT_ID.in(projectIds)).orderBy((OrderField)aw.PROJECT_ID).fetchInto(ActionWordNameDto.class);
    }

    @Override
    public Map<Long, org.squashtest.tm.domain.bdd.ActionWord> findAllActionWordWithParameterByIds(Collection<Long> ids) {
        return this.em.createQuery("SELECT aw FROM ActionWord aw\nLEFT JOIN FETCH aw.fragments\nWHERE aw.id IN :ids\n", org.squashtest.tm.domain.bdd.ActionWord.class).setParameter("ids", ids).getResultStream().collect(Collectors.toMap(org.squashtest.tm.domain.bdd.ActionWord::getId, aw -> aw));
    }

    private static class ActionWordDto {
        private Long id;
        private String projectName;

        public ActionWordDto(Long id, String projectName) {
            this.id = id;
            this.projectName = projectName;
        }

        public Long getId() {
            return this.id;
        }

        public String getProjectName() {
            return this.projectName;
        }
    }

    private static class ActionWordFragmentWithValueDto {
        private Long actionWordId;
        private String value;

        public ActionWordFragmentWithValueDto(Long actionWordId, String value) {
            this.actionWordId = actionWordId;
            this.value = value;
        }

        public Long getActionWordId() {
            return this.actionWordId;
        }

        public String getValue() {
            return this.value;
        }
    }
}

