/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.quicktest;

import java.util.Date;
import org.jooq.DSLContext;
import org.jooq.TableLike;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.quicktest.QuickTest;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.internal.repository.QuickTestDao;
import org.squashtest.tm.service.internal.repository.SprintReqVersionDao;
import org.squashtest.tm.service.quicktest.QuickTestCreationService;

@Service
public class QuickTestCreationServiceImpl
implements QuickTestCreationService {
    private final DSLContext dsl;
    private final QuickTestDao quickTestDao;
    private final SprintReqVersionDao sprintReqVersionDao;

    public QuickTestCreationServiceImpl(DSLContext dsl, QuickTestDao quickTestDao, SprintReqVersionDao sprintReqVersionDao) {
        this.dsl = dsl;
        this.quickTestDao = quickTestDao;
        this.sprintReqVersionDao = sprintReqVersionDao;
    }

    @Override
    public QuickTest createQuickTest(long sprintReqVersionId) {
        Long quickTestCount = (Long)this.dsl.selectCount().from((TableLike)Tables.QUICK_TEST).where(Tables.QUICK_TEST.SPRINT_REQ_VERSION_ID.eq((Object)sprintReqVersionId)).fetchOneInto(Long.class);
        SprintReqVersion sprintReqVersion = (SprintReqVersion)this.sprintReqVersionDao.getReferenceById(sprintReqVersionId);
        String name = "Quick test n\u00b0" + (quickTestCount + 1L);
        QuickTest quickTest = new QuickTest();
        quickTest.setName(name);
        quickTest.setSprintReqVersion(sprintReqVersion);
        quickTest.setCreatedOn(new Date());
        quickTest.setCreatedBy(UserContextHolder.getUsername());
        this.quickTestDao.save(quickTest);
        return quickTest;
    }
}

