/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.xrayimporter;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.exception.pivot.projectimporter.xrayimporter.ImportXrayException;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestPlanItemPivot;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.tables.CustomFieldTable;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.tables.ItemTable;
import org.squashtest.tm.service.internal.dto.projectimporterxray.model.XrayImportModel;
import org.squashtest.tm.service.internal.dto.projectimporterxray.model.XrayInfoModel;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.GlobalProjectXrayImporterService;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.ProjectImporterXrayToTableService;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.XrayTablesDao;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.topivot.ExecutionWorkspaceToPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.topivot.TestCaseToPivotImporterService;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class GlobalProjectXrayImporterServiceImpl
implements GlobalProjectXrayImporterService {
    private final XrayTablesDao xrayTablesDao;
    private final ProjectImporterXrayToTableService projectImporterXrayToTableService;
    private final TestCaseToPivotImporterService testCaseToPivotImporterService;
    private final ExecutionWorkspaceToPivotImporterService executionWorkspaceToPivotImporterService;
    private final PermissionEvaluationService permissionEvaluationService;

    public GlobalProjectXrayImporterServiceImpl(XrayTablesDao xrayTablesDao, ProjectImporterXrayToTableService projectImporterXrayToTableService, TestCaseToPivotImporterService testCaseToPivotImporterService, ExecutionWorkspaceToPivotImporterService executionWorkspaceToPivotImporterService, PermissionEvaluationService permissionEvaluationService) {
        this.xrayTablesDao = xrayTablesDao;
        this.projectImporterXrayToTableService = projectImporterXrayToTableService;
        this.testCaseToPivotImporterService = testCaseToPivotImporterService;
        this.executionWorkspaceToPivotImporterService = executionWorkspaceToPivotImporterService;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @Override
    public XrayImportModel generatePivotFromXml(long projectId, MultipartFile[] multipartFiles) throws IOException {
        this.checkCanImportPermission(projectId);
        try {
            int idTransaction = TransactionAspectSupport.currentTransactionStatus().hashCode();
            this.generateTmpTables(idTransaction);
            MultipartFile[] multipartFileArray = multipartFiles;
            int n = multipartFiles.length;
            int n2 = 0;
            while (n2 < n) {
                MultipartFile multipartFile = multipartFileArray[n2];
                this.parsingXmlToTmpTables(multipartFile.getInputStream());
                ++n2;
            }
            XrayImportModel xrayImportModel = this.generatePivotWithTmpTables(idTransaction);
            return xrayImportModel;
        }
        finally {
            this.xrayTablesDao.dropTablesIfExist();
        }
    }

    @Override
    public XrayInfoModel generateXrayInfoDtoFromXml(long projectId, MultipartFile[] multipartFiles) throws IOException {
        this.checkCanImportPermission(projectId);
        XrayInfoModel xrayInfoDto = new XrayInfoModel();
        MultipartFile[] multipartFileArray = multipartFiles;
        int n = multipartFiles.length;
        int n2 = 0;
        while (n2 < n) {
            MultipartFile multipartFile = multipartFileArray[n2];
            Throwable throwable = null;
            Object var10_10 = null;
            try (InputStream inputStream = multipartFile.getInputStream();){
                this.projectImporterXrayToTableService.getXrayInfoFromXMLParsing(inputStream, xrayInfoDto, multipartFile.getOriginalFilename());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++n2;
        }
        return xrayInfoDto;
    }

    @Override
    public File verifyXrayFile(long projectId, String fileName) throws IllegalAccessException {
        this.checkCanImportPermission(projectId);
        String fileNameMatch = String.format("^(%s|%s)\\d+\\.[a-z]+", "pivot", "pivot_log");
        Matcher matcher = Pattern.compile(fileNameMatch).matcher(fileName);
        if (!matcher.find()) {
            throw new IllegalAccessException("File " + fileName + " is not a valid pivot file.");
        }
        File file = new File(FileUtils.getTempDirectory(), fileName);
        if (!file.exists()) {
            throw new IllegalArgumentException("File " + fileName + " does not exist.");
        }
        return file;
    }

    private void checkCanImportPermission(long projectId) {
        this.permissionEvaluationService.checkPermission(Collections.singletonList(projectId), Permissions.IMPORT.name(), Project.class.getName());
    }

    private void generateTmpTables(int idTransaction) {
        this.xrayTablesDao.createTables(new ItemTable(idTransaction), new CustomFieldTable(idTransaction));
    }

    private void parsingXmlToTmpTables(InputStream inputStream) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                try {
                    this.projectImporterXrayToTableService.convertXrayToTable(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (XMLStreamException xmlStreamException) {
            throw new ImportXrayException("Error during the parsing of the xml file:", (Throwable)xmlStreamException);
        }
    }

    private XrayImportModel generatePivotWithTmpTables(int idTransaction) {
        File pivotLogFile;
        File pivotZipFile;
        try {
            pivotZipFile = File.createTempFile("pivot" + idTransaction, ".zip");
            pivotLogFile = File.createTempFile("pivot_log" + idTransaction, ".txt");
            pivotZipFile.deleteOnExit();
            pivotLogFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new ImportXrayException("Error during the generation of the pivot format while creating the temporary files in the temp directory: ", (Throwable)e);
        }
        JsonFactory jsonFactory = new JsonFactory();
        XrayImportModel xrayImportModel = new XrayImportModel();
        HashMap<String, List<TestPlanItemPivot>> tpiPivotByTestCaseKey = new HashMap<String, List<TestPlanItemPivot>>();
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try (ArchiveOutputStream archive = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)new FileOutputStream(pivotZipFile));){
                Throwable throwable2 = null;
                Object var11_16 = null;
                try (PrintWriter logWriter = new PrintWriter(pivotLogFile);){
                    logWriter.write("Pivot generation log");
                    this.testCaseToPivotImporterService.writeTestCaseFolder(jsonFactory, logWriter, (ArchiveOutputStream<ZipArchiveEntry>)archive, xrayImportModel);
                    this.testCaseToPivotImporterService.writeTestCase(jsonFactory, logWriter, (ArchiveOutputStream<ZipArchiveEntry>)archive, xrayImportModel, tpiPivotByTestCaseKey);
                    this.testCaseToPivotImporterService.writeCalledTestCase(jsonFactory, logWriter, (ArchiveOutputStream<ZipArchiveEntry>)archive, xrayImportModel);
                    this.executionWorkspaceToPivotImporterService.writeCampaign(jsonFactory, logWriter, (ArchiveOutputStream<ZipArchiveEntry>)archive, xrayImportModel, tpiPivotByTestCaseKey);
                    this.executionWorkspaceToPivotImporterService.writeIteration(jsonFactory, logWriter, (ArchiveOutputStream<ZipArchiveEntry>)archive, xrayImportModel, tpiPivotByTestCaseKey);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | ArchiveException e) {
            throw new ImportXrayException("Error during the generation of the pivot format while writing to the ZIP file: ", e);
        }
        xrayImportModel.setPivotFileName(pivotZipFile.getName());
        xrayImportModel.setPivotLogFileName(pivotLogFile.getName());
        return xrayImportModel;
    }
}

