/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record9;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.MilestonePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.PivotAttachmentEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.CampaignPivot;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.AbstractPivotDao;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.EntityBindingField;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.ExecutionWorkspaceConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CampaignPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;

@Repository
public class CampaignPivotDaoImpl
extends AbstractPivotDao<CampaignPivot>
implements CampaignPivotDao {
    private final CustomFieldPivotDao customFieldPivotDao;
    private final ExecutionWorkspaceConverterService executionWorkspaceConverterService;

    public CampaignPivotDaoImpl(DSLContext dsl, AdminPivotConverterService adminPivotConverterService, CustomFieldPivotDao customFieldPivotDao, ExecutionWorkspaceConverterService executionWorkspaceConverterService) {
        super(dsl, adminPivotConverterService);
        this.customFieldPivotDao = customFieldPivotDao;
        this.executionWorkspaceConverterService = executionWorkspaceConverterService;
    }

    @Override
    public boolean hasCampaignByProjectId(Long projectId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
    }

    private ResultQuery<? extends Record> getCustomFieldValueCampaignByProjectIdQuery(Long projectId) {
        Table<Record9<Long, Long, Long, String, String, String, String, String, String>> customFieldTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.CAMPAIGN);
        return this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_TYPE, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.CAMPAIGN).join(customFieldTable).on(Tables.CAMPAIGN.CLN_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID).fetchSize(50);
    }

    private ResultQuery<? extends Record> getAttachmentByProjectIdQuery(Long projectId) {
        return this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from((TableLike)Tables.CAMPAIGN).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID).fetchSize(50);
    }

    private ResultQuery<? extends Record> getMilestoneByProjectIdQuery(Long projectId) {
        return this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID).from((TableLike)Tables.CAMPAIGN).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).join((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID);
    }

    @Override
    public void getCampaignByProjectId(Long projectId, Consumer<CampaignPivot> writingToJsonConsumer, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        ResultQuery campaignQuery = this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_BY, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_ON, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_BY, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_ON, (SelectField)Tables.CAMPAIGN.REFERENCE, (SelectField)Tables.CAMPAIGN.CAMPAIGN_STATUS, (SelectField)Tables.CAMPAIGN.ACTUAL_START_AUTO, (SelectField)Tables.CAMPAIGN.ACTUAL_END_AUTO, (SelectField)Tables.CAMPAIGN.ACTUAL_START_DATE, (SelectField)Tables.CAMPAIGN.ACTUAL_END_DATE, (SelectField)Tables.CAMPAIGN.SCHEDULED_START_DATE, (SelectField)Tables.CAMPAIGN.SCHEDULED_END_DATE, (SelectField)Tables.CLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID, (SelectField)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID, (SelectField)Tables.CAMPAIGN_TEST_PLAN_ITEM.DATASET_ID).from((TableLike)Tables.CAMPAIGN).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.CLN_RELATIONSHIP).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP.DESCENDANT_ID)).leftJoin((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (OrderField)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_PLAN_ORDER).fetchSize(50);
        this.convertRecordAndWritingPivot(campaignQuery, projectId, EntityBindingField.CAMPAIGN, writingToJsonConsumer, writingAttachmentConsumer);
    }

    @Override
    protected CampaignPivot getNewPivotObject(Record record, Long projectId, EntityBindingField entityBindingField) {
        CampaignPivot campaignPivot = this.executionWorkspaceConverterService.campaignRecordToCampaignPivot(record);
        this.appendTestPlanItemToCampaignPivot(campaignPivot, record);
        return campaignPivot;
    }

    @Override
    protected void fillPivotObject(CampaignPivot pivotObject, Record record) {
        this.appendTestPlanItemToCampaignPivot(pivotObject, record);
    }

    private void appendTestPlanItemToCampaignPivot(CampaignPivot campaignPivot, Record record) {
        if (record.get((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID) != null) {
            campaignPivot.addTestPlanItem(this.executionWorkspaceConverterService.campaignTpiRecordToTpiPivot(record));
        }
    }

    @Override
    protected List<SubElementRecordProcessor<? extends AbstractPivotObject>> getSubElementRecordProcessors(Long projectId, EntityBindingField entityBindingField) {
        return List.of(this.getCufPivotContainer(projectId), this.getMilestoneTestCasePivotContainer(projectId), this.getAttachmentPivotContainer(this.getAttachmentByProjectIdQuery(projectId), (Field<Long>)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID));
    }

    private SubElementRecordProcessor<CustomFieldValuePivot> getCufPivotContainer(Long projectId) {
        return new SubElementRecordProcessor<CustomFieldValuePivot>(this.getCustomFieldValueCampaignByProjectIdQuery(projectId), (Field<Long>)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, this.customFieldPivotDao::cufValueRecordToCufValuePivot, CustomFieldValuePivot.class);
    }

    private SubElementRecordProcessor<MilestonePivot> getMilestoneTestCasePivotContainer(Long projectId) {
        return new SubElementRecordProcessor<MilestonePivot>(this.getMilestoneByProjectIdQuery(projectId), (Field<Long>)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (Field<Long>)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID, record -> this.adminPivotConverterService.recordToBindingMilestonePivot((Record)record, (Field<Long>)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (Field<Long>)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID), MilestonePivot.class);
    }

    @Override
    protected void appendSubElementsToPivotObject(CampaignPivot pivotObject, Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> subElementsByClazz, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        pivotObject.addAllCustomFields(this.getSubElement(CustomFieldValuePivot.class, subElementsByClazz));
        this.getSubElement(MilestonePivot.class, subElementsByClazz).forEach(milestonePivot -> pivotObject.addMilestone(milestonePivot.getPivotId()));
        this.addAndWriteAttachmentPivot(this.getSubElement(AttachmentPivot.class, subElementsByClazz), (PivotAttachmentEntity)pivotObject, writingAttachmentConsumer);
    }
}

