/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import java.util.List;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.search.filter.FilterValueHandler;

@Component
public class FilterValueHandlers {
    private List<FilterValueHandler> gridFilterValueHandlers;

    public FilterValueHandlers(List<FilterValueHandler> gridFilterValueHandlers) {
        this.gridFilterValueHandlers = gridFilterValueHandlers;
    }

    public boolean isHandledOutOfQueryEngine(GridFilterValue filter) {
        List<FilterValueHandler> handlers = this.findHandlers(filter);
        if (handlers.size() > 1) {
            throw new RuntimeException("There can be only one special filter handler for a filter value");
        }
        return handlers.size() == 1;
    }

    private List<FilterValueHandler> findHandlers(GridFilterValue filter) {
        return this.gridFilterValueHandlers.stream().filter(filterHandler -> filterHandler.canHandleGridFilterValue(filter)).toList();
    }

    public void handleGridFilterValuesOutOfQueryEngine(GridFilterValue gridFilterValue) {
        if (this.isHandledOutOfQueryEngine(gridFilterValue)) {
            List<FilterValueHandler> handlers = this.findHandlers(gridFilterValue);
            handlers.get(0).handleGridFilterValue(gridFilterValue);
        }
    }
}

