/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.context.MessageSource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.campaign.AutomatedSuiteDeletionService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.campaign.LockedCampaignNodeDetectionService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.deletion.AbstractNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.DeletionPreview;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcCampaignDeletionHandlerFactory;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcIterationDeletionHandlerFactory;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcTestPlanItemDeletionHandlerFactory;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueService;
import org.squashtest.tm.service.internal.repository.CampaignDeletionDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Component(value="squashtest.tm.service.deletion.CampaignNodeDeletionHandler")
public class CampaignDeletionHandlerImpl
extends AbstractNodeDeletionHandler<CampaignLibraryNode, CampaignFolder>
implements CampaignNodeDeletionHandler {
    private final LockedCampaignNodeDetectionService lockedCampaignNodeDetectionService;
    private final CampaignDeletionDao deletionDao;
    private final TestSuiteDao suiteDao;
    private final IterationTestPlanDao iterationTestPlanDao;
    private final PrivateCustomFieldValueService customValueService;
    private final PrivateDenormalizedFieldValueService denormalizedFieldValueService;
    private final ActiveMilestoneHolder activeMilestoneHolder;
    private final CustomTestSuiteModificationService customTestSuiteModificationService;
    private final JdbcIterationDeletionHandlerFactory jdbcIterationDeletionHandlerFactory;
    private final JdbcCampaignDeletionHandlerFactory jdbcCampaignDeletionHandlerFactory;
    private final TestPlanItemDao testPlanItemDao;
    private final PermissionEvaluationService permissionEvaluationService;
    private final AuditModificationService auditModificationService;
    private final IterationDao iterationDao;
    private final JdbcTestPlanItemDeletionHandlerFactory testPlanItemDeletionHandler;
    private final AutomatedSuiteDeletionService automatedSuiteDeletionService;

    public CampaignDeletionHandlerImpl(LockedCampaignNodeDetectionService lockedCampaignNodeDetectionService, CampaignDeletionDao deletionDao, TestSuiteDao suiteDao, IterationTestPlanDao iterationTestPlanDao, PrivateCustomFieldValueService customValueService, PrivateDenormalizedFieldValueService denormalizedFieldValueService, ActiveMilestoneHolder activeMilestoneHolder, CustomTestSuiteModificationService customTestSuiteModificationService, JdbcIterationDeletionHandlerFactory jdbcIterationDeletionHandlerFactory, JdbcCampaignDeletionHandlerFactory jdbcCampaignDeletionHandlerFactory, AttachmentManagerService attachmentManager, TestPlanItemDao testPlanItemDao, PermissionEvaluationService permissionEvaluationService, AuditModificationService auditModificationService, IterationDao iterationDao, JdbcTestPlanItemDeletionHandlerFactory testPlanItemDeletionHandler, MessageSource messageSource, AutomatedSuiteDeletionService automatedSuiteDeletionService) {
        super(attachmentManager, messageSource, deletionDao);
        this.lockedCampaignNodeDetectionService = lockedCampaignNodeDetectionService;
        this.deletionDao = deletionDao;
        this.suiteDao = suiteDao;
        this.iterationTestPlanDao = iterationTestPlanDao;
        this.customValueService = customValueService;
        this.denormalizedFieldValueService = denormalizedFieldValueService;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.customTestSuiteModificationService = customTestSuiteModificationService;
        this.jdbcIterationDeletionHandlerFactory = jdbcIterationDeletionHandlerFactory;
        this.jdbcCampaignDeletionHandlerFactory = jdbcCampaignDeletionHandlerFactory;
        this.automatedSuiteDeletionService = automatedSuiteDeletionService;
        this.testPlanItemDao = testPlanItemDao;
        this.permissionEvaluationService = permissionEvaluationService;
        this.auditModificationService = auditModificationService;
        this.iterationDao = iterationDao;
        this.testPlanItemDeletionHandler = testPlanItemDeletionHandler;
    }

    @Override
    protected List<SuppressionPreviewReport> diagnoseSuppression(List<Long> nodeIds) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedCampaigns(nodeIds));
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedSprints(nodeIds));
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedByMilestone(nodeIds));
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedWithActiveMilestone(nodeIds));
        return reportList;
    }

    @Override
    public DeletionPreview simulateIterationDeletion(List<Long> targetIds) {
        if (targetIds.isEmpty()) {
            return new DeletionPreview();
        }
        List<SuppressionPreviewReport> reportList = this.diagnoseIterationDeletion(targetIds);
        List lockIds = reportList.stream().flatMap(report -> report.getLockedNodes().stream()).toList();
        List<Long> deletableIds = targetIds.stream().filter(id -> !lockIds.contains(id)).toList();
        long deletionCount = this.iterationDao.countTestSuitesInIterations(deletableIds);
        DeletionPreview deletionPreview = new DeletionPreview(deletionCount += (long)deletableIds.size(), this.deletionThreshold);
        deletionPreview.addMessages(reportList, this.messageSource);
        return deletionPreview;
    }

    private List<SuppressionPreviewReport> diagnoseIterationDeletion(List<Long> targetIds) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedIteration(targetIds));
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedByMilestoneIteration(targetIds));
        return reportList;
    }

    @Override
    public DeletionPreview simulateSuiteDeletion(List<Long> targetIds) {
        if (targetIds.isEmpty()) {
            return new DeletionPreview();
        }
        List<SuppressionPreviewReport> reportList = this.diagnoseTestSuiteDeletion(targetIds);
        List lockIds = reportList.stream().flatMap(report -> report.getLockedNodes().stream()).toList();
        List<Long> deletableIds = targetIds.stream().filter(id -> !lockIds.contains(id)).toList();
        DeletionPreview deletionPreview = new DeletionPreview(Long.valueOf(deletableIds.size()), this.deletionThreshold);
        deletionPreview.addMessages(reportList, this.messageSource);
        return deletionPreview;
    }

    private List<SuppressionPreviewReport> diagnoseTestSuiteDeletion(List<Long> targetIds) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedSuites(targetIds));
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedByMilestoneTestSuite(targetIds));
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectTestPlanItemBoundMultipleTestSuite(targetIds));
        return reportList;
    }

    @Override
    protected OperationReport batchDeleteNodes(List<Long> ids) {
        return this.jdbcCampaignDeletionHandlerFactory.build(ids).delete();
    }

    @Override
    protected OperationReport batchUnbindFromMilestone(List<Long> ids) {
        List<Long> remainingIds = this.deletionDao.findRemainingCampaignIds(ids);
        List<Long> lockedIds = this.deletionDao.findCampaignsWhichMilestonesForbidsDeletion(remainingIds);
        remainingIds.removeAll(lockedIds);
        OperationReport report = new OperationReport();
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        activeMilestone.ifPresent(milestone -> this.deletionDao.unbindFromMilestone(remainingIds, milestone.getId()));
        report.addRemoved(remainingIds, "campaign");
        return report;
    }

    @Override
    public OperationReport deleteIterations(List<Long> targetIds) {
        ArrayList<Long> iterationsToDelete = new ArrayList<Long>(targetIds.size());
        List lockedIds = this.diagnoseIterationDeletion(targetIds).stream().flatMap(report -> report.getLockedNodes().stream()).toList();
        iterationsToDelete.addAll(targetIds);
        iterationsToDelete.removeAll(lockedIds);
        this.doDeleteIterations(iterationsToDelete);
        OperationReport report2 = new OperationReport();
        report2.addRemoved(iterationsToDelete, "iteration");
        return report2;
    }

    private void doDeleteSuites(Collection<TestSuite> testSuites) {
        List<ExternalContentCoordinates> pairContentIDListIDS = testSuites.stream().flatMap(testSuite -> {
            testSuite.getTestPlanItems().forEach(testPlanItem -> testPlanItem.getTestSuites().clear());
            testSuite.getIteration().removeTestSuite(testSuite);
            return this.getExternalAttachmentContentCoordinatesOfObject((AttachmentHolder)testSuite).stream();
        }).toList();
        List<Long> testSuiteIds = testSuites.stream().map(TestSuite::getId).toList();
        this.customValueService.deleteAllCustomFieldValues(BindableEntity.TEST_SUITE, testSuiteIds);
        List attachmentListIds = this.suiteDao.findTestSuiteAttachmentListIds(testSuiteIds);
        List automatedSuitesIds = this.suiteDao.findTestSuitesAutomatedSuiteIds(testSuiteIds);
        this.deleteAutomatedSuites(automatedSuitesIds);
        this.suiteDao.removeTestSuites(testSuiteIds);
        this.attachmentManager.removeAttachmentsAndLists(attachmentListIds);
        this.attachmentManager.deleteContents(pairContentIDListIDS);
    }

    @Override
    public void deleteExecution(Execution execution) {
        List<ExternalContentCoordinates> pairContentIDListIDSteps = this.deleteExecSteps(execution);
        List<ExternalContentCoordinates> pairContentIDListIDExec = this.getExternalAttachmentContentCoordinatesOfObject((AttachmentHolder)execution);
        if (!pairContentIDListIDExec.isEmpty()) {
            pairContentIDListIDSteps.addAll(pairContentIDListIDExec);
        }
        Long projectId = execution.getProject().getId();
        this.automatedSuiteDeletionService.deleteAutomatedExecutionExtenderAndDenormalizedEnvironments(execution, projectId);
        this.denormalizedFieldValueService.deleteAllDenormalizedFieldValues((DenormalizedFieldHolder)execution);
        this.customValueService.deleteAllCustomFieldValues((BoundEntity)execution);
        TestPlanItem testPlanItem = execution.getTestPlanItem();
        testPlanItem.removeExecutionsById(Collections.singletonList(execution.getId()));
        this.customTestSuiteModificationService.updateExecutionStatus(testPlanItem.getTestSuites());
        this.attachmentManager.deleteContents(pairContentIDListIDSteps);
    }

    @Override
    public void deleteAutomatedSuites(List<Long> automatedSuiteIds) {
        this.automatedSuiteDeletionService.processAutomatedSuitesDeletion(automatedSuiteIds);
    }

    private void doDeleteIterations(List<Long> iterations) {
        if (!iterations.isEmpty()) {
            this.jdbcIterationDeletionHandlerFactory.build(iterations).deleteIterations();
        }
    }

    @Override
    public void deleteExecutions(List<Execution> executions) {
        ArrayList<Execution> executionsCopy = new ArrayList<Execution>(executions);
        for (Execution execution : executionsCopy) {
            this.deleteExecution(execution);
        }
    }

    private List<ExternalContentCoordinates> deleteExecSteps(Execution execution) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>(execution.getSteps());
        execution.getSteps().clear();
        List<Object> pairContentIDListID = !steps.isEmpty() ? this.attachmentManager.getListPairContentIDListIDForExecutionSteps(steps) : new ArrayList();
        for (ExecutionStep step : steps) {
            this.denormalizedFieldValueService.deleteAllDenormalizedFieldValues((DenormalizedFieldHolder)step);
            this.customValueService.deleteAllCustomFieldValues((BoundEntity)step);
            this.deletionDao.removeEntity(step);
        }
        return pairContentIDListID;
    }

    @Override
    public OperationReport deleteSuites(List<Long> suiteIds, boolean removeFromIter) {
        List<Long> testPlanItemIds;
        ArrayList<Long> suiteToDelete = new ArrayList<Long>(suiteIds.size());
        List lockedIds = this.diagnoseTestSuiteDeletion(suiteIds).stream().flatMap(report -> report.getLockedNodes().stream()).toList();
        suiteToDelete.addAll(suiteIds);
        suiteToDelete.removeAll(lockedIds);
        if (removeFromIter && !(testPlanItemIds = this.iterationTestPlanDao.findTestPlanItemsToRemoveInDeleteTestSuite(suiteToDelete, suiteIds)).isEmpty()) {
            Long iterationId = this.suiteDao.findIterationIdByTestSuiteId((Long)suiteToDelete.get(0));
            this.removeTestPlanItemsFromIteration(testPlanItemIds, iterationId, false);
        }
        List suitesToDelete = this.suiteDao.findAllByIds(suiteToDelete);
        this.doDeleteSuites(suitesToDelete);
        OperationReport report2 = new OperationReport();
        if (!suitesToDelete.isEmpty()) {
            report2.addRemoved(suiteIds, "test-suite");
        }
        return report2;
    }

    @Override
    protected boolean isMilestoneMode() {
        return this.activeMilestoneHolder.getActiveMilestone().isPresent();
    }

    @Override
    public boolean removeTestPlanItemsFromIteration(List<Long> testPlanItemsIds, long iterationId, boolean shouldThrowException) {
        List<Long> authorizedTestPlanItemIds = this.filterPermittedTestPlanItemIds(testPlanItemsIds, shouldThrowException);
        this.testPlanItemDeletionHandler.build(authorizedTestPlanItemIds).deleteTestPlanItems();
        Iteration it = (Iteration)this.iterationDao.findById(iterationId);
        this.auditModificationService.updateAuditable((AuditableMixin)it);
        return testPlanItemsIds.size() != authorizedTestPlanItemIds.size();
    }

    @Override
    public void removeTestPlanItems(Collection<Long> testPlanItemsIds, boolean shouldThrowException) {
        List<Long> authorizedTestPlanItemIds = this.filterPermittedTestPlanItemIds(testPlanItemsIds, shouldThrowException);
        this.testPlanItemDeletionHandler.build(authorizedTestPlanItemIds).deleteTestPlanItems();
    }

    private List<Long> filterPermittedTestPlanItemIds(Collection<Long> testPlanItemIds, boolean shouldThrowException) {
        List<Long> testPlanItemIdsWithExecution = this.testPlanItemDao.filterItemsWithExecutions(testPlanItemIds);
        ArrayList<Long> authorizedTestPlanItemIds = new ArrayList<Long>();
        for (Long testPlanItemId : testPlanItemIds) {
            Permissions permissionToCheck;
            Permissions permissions = permissionToCheck = testPlanItemIdsWithExecution.contains(testPlanItemId) ? Permissions.EXTENDED_DELETE : Permissions.DELETE;
            if (this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", permissionToCheck.name(), testPlanItemId, TestPlanItem.class.getName())) {
                authorizedTestPlanItemIds.add(testPlanItemId);
                continue;
            }
            if (!shouldThrowException) continue;
            throw new AccessDeniedException("The current user cannot delete this test plan item: " + String.valueOf(testPlanItemId));
        }
        return authorizedTestPlanItemIds;
    }

    @Override
    protected long countDeletableTreeNodes(List<Long> nodeIds, List<SuppressionPreviewReport> reports) {
        List lockedNodeIds = reports.stream().flatMap(report -> report.getLockedNodes().stream()).distinct().toList();
        List<Long> deletableNodeIds = nodeIds.stream().filter(nodeId -> !lockedNodeIds.contains(nodeId)).toList();
        Long deletableIterationAndSuiteCount = this.deletionDao.countDeletableIterationAndTestSuite(deletableNodeIds);
        return deletableIterationAndSuiteCount + (long)deletableNodeIds.size();
    }
}

