/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customreport.export;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.jooq.impl.DSL;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValueType;
import org.squashtest.tm.domain.customreport.CustomExportColumnLabel;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportCustomExportColumn;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.customreport.export.CustomReportExportCSV;
import org.squashtest.tm.service.customreport.export.CustomReportExportDao;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.dto.FileDto;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;
import org.squashtest.tm.service.internal.filemanagement.writer.CSVWriter;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.repository.CustomFieldDao;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

@Service
public class CustomReportExportCSVImpl
implements CustomReportExportCSV {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomReportExportCSV.class);
    private static final String SPACE_DASH_SPACE = " - ";
    private static final String NOT_AVAILABLE = "n/a;";
    private final CustomFieldDao customFieldDao;
    private final CustomReportExportDao customReportExportDao;
    private final MessageSource messageSource;

    public CustomReportExportCSVImpl(CustomFieldDao customFieldDao, CustomReportExportDao customReportExportDao, MessageSource messageSource) {
        this.customFieldDao = customFieldDao;
        this.customReportExportDao = customReportExportDao;
        this.messageSource = messageSource;
    }

    @Override
    public FileDto getExportFile(CustomReportCustomExport customReportExport) {
        try {
            File file = File.createTempFile("custom-export", ".tmp");
            file.deleteOnExit();
            return new FileDto(CustomReportExportCSVImpl.buildFileName(customReportExport), file, ".csv");
        }
        catch (IOException e) {
            throw new ActionException("custom export : I/O failure while creating the temporary file", (Throwable)e);
        }
    }

    private static String buildFileName(CustomReportCustomExport customExport) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String encodedCustomExportName = URLEncoder.encode(customExport.getName(), StandardCharsets.UTF_8).replace(" ", "_");
        return String.format("EXPORT_%s_%s", encodedCustomExportName, sdf.format(new Date()));
    }

    @Override
    public void doExport(CustomReportCustomExport customReportExport, File file, Locale locale, boolean onlyLastExecution) {
        Map<EntityType, List<Long>> cufIdsByEntityType = this.extractCufIdsByEntityType(customReportExport);
        List<String> headers = this.getHeaders(customReportExport.getColumns(), cufIdsByEntityType, locale);
        Set<Long> selectedCampaignIds = this.customReportExportDao.getSelectedCampaignIds(customReportExport);
        Map<Long, String> campaignProgressRateById = this.getCampaignProgressRateById(selectedCampaignIds);
        List selectedColumns = customReportExport.getColumns();
        HashMap cufProcessors = new HashMap();
        HashMap cufStorage = new HashMap();
        try {
            Throwable throwable = null;
            Object var13_14 = null;
            try {
                CSVWriter csvWriter = new CSVWriter(file);
                try {
                    try (Stream records = this.customReportExportDao.getExportQuery(selectedCampaignIds, selectedColumns, cufIdsByEntityType, onlyLastExecution).fetchStream();){
                        csvWriter.write(headers);
                        this.customReportExportDao.getCufQueryByEntityType(selectedCampaignIds, cufIdsByEntityType).forEach((entityType, record4s) -> {
                            SubElementRecordProcessor<CustomFieldValueDto> subElementRecordProcessor = cufProcessors.put(entityType, this.getCufProcessor((ResultQuery)record4s));
                        });
                        records.forEach(record -> this.appendRowValues(selectedColumns, cufProcessors, cufStorage, campaignProgressRateById, (Record)record, csvWriter, locale));
                    }
                    if (csvWriter != null) {
                        csvWriter.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (csvWriter != null) {
                        csvWriter.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            cufProcessors.values().forEach(SubElementRecordProcessor::close);
        }
    }

    private <R extends Record> SubElementRecordProcessor<CustomFieldValueDto> getCufProcessor(ResultQuery<R> query) {
        return new SubElementRecordProcessor<CustomFieldValueDto>(query, (Field<Long>)DSL.field((String)"ID", Long.class), (Field<Long>)Tables.CUSTOM_FIELD_VALUE.CFV_ID, this::toCustomFieldValueDto, CustomFieldValueDto.class);
    }

    private CustomFieldValueDto toCustomFieldValueDto(Record record) {
        String value = (String)record.get((Field)Tables.CUSTOM_FIELD_VALUE.VALUE);
        if (CustomFieldValueType.NUM.name().equals(record.get((Field)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE))) {
            value = NumericCufHelper.formatOutputNumericCufValue(value);
        }
        value = this.adaptHtmlImageAttribute(value);
        return new CustomFieldValueDto((Long)record.get((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID), (Long)record.get(DSL.field((String)"ID", Long.class)), (Long)record.get((Field)Tables.CUSTOM_FIELD_VALUE.CF_ID), value);
    }

    private Map<EntityType, List<Long>> extractCufIdsByEntityType(CustomReportCustomExport customExport) {
        return customExport.getColumns().stream().filter(column -> column.getCufId() != null).collect(Collectors.groupingBy(column -> column.getLabel().getEntityType(), Collectors.mapping(CustomReportCustomExportColumn::getCufId, Collectors.toList())));
    }

    private List<String> getHeaders(List<CustomReportCustomExportColumn> exportColumns, Map<EntityType, List<Long>> cufIdsByEntityType, Locale locale) {
        Map<Long, String> cufLabelById = this.getCufLabelByCufId(cufIdsByEntityType);
        return exportColumns.stream().map(column -> this.getHeaderName((CustomReportCustomExportColumn)column, cufLabelById, locale)).toList();
    }

    private String getHeaderName(CustomReportCustomExportColumn column, Map<Long, String> cufLabelById, Locale locale) {
        return "%s%s%s".formatted(column.getLabel().getShortenedEntityType(), SPACE_DASH_SPACE, this.getInternationalizedHeaderName(column, cufLabelById, locale));
    }

    private String getInternationalizedHeaderName(CustomReportCustomExportColumn column, Map<Long, String> cufLabelById, Locale locale) {
        if (column.getCufId() == null) {
            return this.messageSource.getMessage(column.getLabel().getI18nKey(), null, locale);
        }
        if (cufLabelById.containsKey(column.getCufId())) {
            return cufLabelById.get(column.getCufId());
        }
        LOGGER.info("Custom Field of ID {} was deleted and will be written as such.", new Object[]{column.getCufId()});
        return this.messageSource.getMessage("squashtm.itemdeleted", null, locale);
    }

    private Map<Long, String> getCufLabelByCufId(Map<EntityType, List<Long>> cufIdsByEntityType) {
        Set cufIds = cufIdsByEntityType.entrySet().stream().flatMap(c -> ((List)c.getValue()).stream()).collect(Collectors.toSet());
        if (cufIds.isEmpty()) {
            return Map.of();
        }
        return this.customFieldDao.findAllById(cufIds).stream().collect(Collectors.toMap(CustomField::getId, CustomField::getLabel));
    }

    private Map<Long, String> getCampaignProgressRateById(Set<Long> campaignIds) {
        Map<Long, String> campaignProgressRateById = this.customReportExportDao.getExecutionStatusByCampaignId(campaignIds).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.computeProgressRateForCampaign((List)entry.getValue())));
        campaignIds.forEach(id -> {
            String string = campaignProgressRateById.putIfAbsent((Long)id, this.formatProgressRate(0.0));
        });
        return campaignProgressRateById;
    }

    private String computeProgressRateForCampaign(List<String> executionStatuses) {
        long executed = executionStatuses.stream().map(ExecutionStatus::fromString).filter(ExecutionStatus::isTerminatedStatus).count();
        return this.formatProgressRate((double)executed * 100.0 / (double)executionStatuses.size());
    }

    private String formatProgressRate(double rate) {
        return String.format(Locale.ROOT, "%.2f %%", rate);
    }

    private void appendRowValues(List<CustomReportCustomExportColumn> selectedColumns, Map<EntityType, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessors, Map<EntityType, List<CustomFieldValueDto>> cufStorage, Map<Long, String> campaignProgressRate, Record record, CSVWriter csvWriter, Locale locale) {
        Long campaignId = (Long)record.get((Field)Tables.CAMPAIGN.CLN_ID);
        List<String> rowValues = this.generateRowValues(record, selectedColumns, cufProcessors, cufStorage, campaignProgressRate.get(campaignId), locale);
        csvWriter.write(rowValues);
    }

    private List<String> generateRowValues(Record record, List<CustomReportCustomExportColumn> selectedColumns, Map<EntityType, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessors, Map<EntityType, List<CustomFieldValueDto>> cufStorage, Object campaignProgressRate, Locale locale) {
        ArrayList<String> rowValues = new ArrayList<String>();
        for (CustomReportCustomExportColumn column : selectedColumns) {
            Object value = this.computeOutputValue(record, column, cufProcessors, cufStorage, campaignProgressRate, locale);
            rowValues.add(this.valueToString(value));
        }
        return rowValues;
    }

    private String valueToString(Object value) {
        if (Objects.isNull(value) || StringUtils.isEmpty((CharSequence)value.toString())) {
            return NOT_AVAILABLE;
        }
        return value.toString();
    }

    private Object computeOutputValue(Record record, CustomReportCustomExportColumn column, Map<EntityType, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessors, Map<EntityType, List<CustomFieldValueDto>> cufStorage, Object campaignSuccessRate, Locale locale) {
        CustomExportColumnLabel label = column.getLabel();
        Field columnField = label.getJooqTableField();
        Object value = label.equals((Object)CustomExportColumnLabel.TEST_CASE_NATURE) || label.equals((Object)CustomExportColumnLabel.TEST_CASE_TYPE) ? this.translateI18nKey(record, columnField, locale) : (CustomExportColumnLabel.getRichTextFieldsSet().contains(label) ? this.computeRichValue(record.get(columnField)) : (label.equals((Object)CustomExportColumnLabel.CAMPAIGN_PROGRESS_STATUS) ? campaignSuccessRate : (columnField != null ? record.get(columnField) : this.computeOutputValueForCustomField(record, column, cufProcessors, cufStorage, label))));
        return value;
    }

    private Object translateI18nKey(Record record, Field<?> columnField, Locale locale) {
        Object i18nKey = record.get(columnField);
        if (i18nKey != null) {
            String i18nKeyString = String.valueOf(i18nKey);
            return this.messageSource.getMessage(i18nKeyString, null, i18nKeyString, locale);
        }
        return null;
    }

    private Object computeOutputValueForCustomField(Record record, CustomReportCustomExportColumn column, Map<EntityType, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessors, Map<EntityType, List<CustomFieldValueDto>> cufStorage, CustomExportColumnLabel label) {
        long cufId = column.getCufId();
        EntityType entityType = label.getEntityType();
        Long entityId = (Long)record.get((Field)CustomExportColumnLabel.getEntityTypeToIdTableFieldMap().get(entityType));
        if (entityId != null) {
            List cufValueStorage = cufStorage.getOrDefault(entityType, new ArrayList());
            if (cufValueStorage.isEmpty()) {
                List<CustomFieldValueDto> cufValues = cufProcessors.get(entityType).getSubElements(entityId, false);
                cufStorage.put(entityType, cufValues);
                return this.getCufValue(cufId, cufValues);
            }
            if (this.isSameId(entityId, cufValueStorage)) {
                return this.getCufValue(cufId, cufValueStorage);
            }
            cufValueStorage.clear();
            List<CustomFieldValueDto> cufValues = cufProcessors.get(entityType).getSubElements(entityId, false);
            cufStorage.replace(entityType, cufValues);
            return this.getCufValue(cufId, cufValues);
        }
        return null;
    }

    private Object getCufValue(Long cufId, List<CustomFieldValueDto> customFieldValueDtos) {
        return customFieldValueDtos.stream().filter(cufValueDto -> Objects.equals(cufValueDto.getCufId(), cufId)).map(CustomFieldValueDto::getValue).findFirst().orElse(null);
    }

    private boolean isSameId(Long id, List<CustomFieldValueDto> customFieldValueDtos) {
        return id.equals(customFieldValueDtos.getFirst().getBoundEntityId());
    }

    private String computeRichValue(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        String cleanHtml = HTMLCleanupUtils.cleanHtml(String.valueOf(rawValue));
        String formattedHtml = this.adaptHtmlImageAttribute(cleanHtml);
        return HTMLCleanupUtils.htmlToTrimmedText(HTMLCleanupUtils.cleanHtml(formattedHtml));
    }

    private String adaptHtmlImageAttribute(String html) {
        Document document = Jsoup.parse((String)html);
        Elements elements = document.select("img");
        if (!elements.isEmpty()) {
            elements.forEach(element -> {
                String imageSrc = element.attr("src");
                if (!imageSrc.contains("data:image")) {
                    element.attr("alt", imageSrc);
                }
            });
            return document.body().html();
        }
        return html;
    }
}

