/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker.knownissues.local;

import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectHavingStep;
import org.jooq.SelectSeekStep1;
import org.jooq.Table;
import org.jooq.TableLike;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.TestPlan;
import org.squashtest.tm.jooq.domain.tables.TestPlanItem;
import org.squashtest.tm.service.bugtracker.knownissues.local.LocalKnownIssue;
import org.squashtest.tm.service.bugtracker.knownissues.local.LocalKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.LocalKnownIssueFinderHelper;

public abstract class BaseLocalKnownIssueFinder<RECORD extends Record>
implements LocalKnownIssueFinder {
    protected final DSLContext dsl;

    protected BaseLocalKnownIssueFinder(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public int countKnownIssues(Long entityId) {
        return this.selectKnownIssues(entityId).fetch().size();
    }

    @Override
    public List<LocalKnownIssue> getPaginatedKnownIssues(Long entityId, PagingAndSorting paging) {
        SelectSeekStep1 nonPaginatedQuery = this.selectKnownIssues(entityId).orderBy(LocalKnownIssueFinderHelper.getOrderField(paging));
        Result records = paging.shouldDisplayAll() ? nonPaginatedQuery.fetch() : nonPaginatedQuery.limit((Number)paging.getFirstItemIndex(), (Number)paging.getPageSize()).fetch();
        return records.map(this::buildIssueFromRecord);
    }

    protected Table<?> getTable() {
        return BaseLocalKnownIssueFinder.getIssueToBugtrackerBindingJoin();
    }

    protected static Table<?> getIssueToBugtrackerBindingJoin() {
        return Tables.ISSUE.innerJoin((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.ISSUE.ISSUE_ID.eq((Field)Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID)).innerJoin((TableLike)TestPlanItem.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)TestPlanItem.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)TestPlan.TEST_PLAN).on(TestPlanItem.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)TestPlan.TEST_PLAN.TEST_PLAN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.CL_ID.eq((Field)TestPlan.TEST_PLAN.CL_ID));
    }

    protected abstract SelectHavingStep<RECORD> selectKnownIssues(long var1);

    protected abstract LocalKnownIssue buildIssueFromRecord(RECORD var1);
}

