/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.service.internal.batchimport.Batch;

public class Batches<T> {
    private final Map<Long, Batch<T>> batch = new HashMap<Long, Batch<T>>();

    public void addBatch(Long targetId, T entity) {
        this.batch.computeIfAbsent(targetId, k -> new Batch(targetId)).addEntity(entity);
    }

    public void addBatch(Long targetId, List<T> entities) {
        this.batch.computeIfAbsent(targetId, k -> new Batch(targetId)).addEntities(entities);
    }

    public List<T> getEntitiesByTargetId(Long parentId) {
        return this.batch.get(parentId).getEntities();
    }

    public Set<Long> getTargetIds() {
        return this.batch.keySet();
    }

    public boolean contains(Long targetId) {
        return this.batch.containsKey(targetId);
    }

    public boolean isEmpty() {
        return this.batch.isEmpty();
    }

    public List<List<Batch<T>>> partition(int partition) {
        return Lists.partition(this.batch.values().stream().toList(), (int)partition);
    }
}

