/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.IsScriptedTestCaseVisitor;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.exception.requirement.MilestoneForbidModificationException;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.testcase.parameter.TestCaseParameterOperationReport;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.ParameterDao;
import org.squashtest.tm.service.internal.repository.loaders.testcase.TestCaseLoader;
import org.squashtest.tm.service.internal.testcase.ParameterComparator;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testcase.DatasetCopierService;

@Transactional
@Service
public class DatasetCopierServiceImpl
implements DatasetCopierService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetCopierServiceImpl.class);
    private final PermissionEvaluationService permissionService;
    private final DatasetDao datasetDao;
    private final TestCaseLoader testCaseLoader;
    private final MessageSource messageSource;
    private final MilestoneDao milestoneDao;
    private final TestCaseDisplayService testCaseDisplayService;
    private final ParameterDao parameterDao;

    public DatasetCopierServiceImpl(PermissionEvaluationService permissionService, DatasetDao datasetDao, TestCaseLoader testCaseLoader, MessageSource messageSource, MilestoneDao milestoneDao, TestCaseDisplayService testCaseDisplayService, ParameterDao parameterDao) {
        this.permissionService = permissionService;
        this.datasetDao = datasetDao;
        this.testCaseLoader = testCaseLoader;
        this.messageSource = messageSource;
        this.milestoneDao = milestoneDao;
        this.testCaseDisplayService = testCaseDisplayService;
        this.parameterDao = parameterDao;
    }

    @Override
    public Map<Long, TestCaseParameterOperationReport> copyDataset(long sourceDatasetId, long sourceTestCaseId, List<Long> targetTestCasesIds) {
        ArrayList<Long> duplicationSuccessTCIds = new ArrayList<Long>();
        List<Long> filteredTargetTestCasesIds = this.checkAndFilterIdsByPermission(targetTestCasesIds);
        Map<Long, TestCase> testCases = this.loadTestCases(sourceTestCaseId, targetTestCasesIds);
        Source source = this.loadSource(testCases.get(sourceTestCaseId), sourceDatasetId);
        List blocked = this.milestoneDao.findTestCaseIdsBoundToBlockingMilestone(testCases.keySet());
        Map targetParameters = this.parameterDao.findAllParametersByTestCaseIds(filteredTargetTestCasesIds);
        for (Long targetTestCaseId : filteredTargetTestCasesIds) {
            try {
                TestCase targetTestCase = DatasetCopierServiceImpl.getTargetTestCase(targetTestCaseId, testCases, blocked);
                ArrayList<Parameter> parameters = new ArrayList<Parameter>(targetParameters.getOrDefault(targetTestCaseId, Collections.emptyList()));
                this.pasteParameters(source, targetTestCase, parameters);
                this.pasteDataset(source, targetTestCase, parameters);
                duplicationSuccessTCIds.add(targetTestCaseId);
            }
            catch (Exception e) {
                LOGGER.warn("The dataset {} could not be copied into the test case {}", new Object[]{sourceDatasetId, targetTestCaseId, e});
            }
        }
        return this.compileDatasetCopyReport(duplicationSuccessTCIds, sourceTestCaseId);
    }

    private Source loadSource(TestCase source, long sourceDatasetId) {
        Dataset sourceDataset = this.datasetDao.loadWithParams(sourceDatasetId);
        return new Source(source, sourceDataset);
    }

    private Map<Long, TestCase> loadTestCases(Long sourceTestCaseId, List<Long> targetTestCasesIds) {
        ArrayList<Long> all = new ArrayList<Long>(targetTestCasesIds);
        all.add(sourceTestCaseId);
        return this.testCaseLoader.load(all, EnumSet.of(TestCaseLoader.Options.FETCH_DATASETS, TestCaseLoader.Options.FETCH_PARAMETERS)).stream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
    }

    private static TestCase getTargetTestCase(Long targetTestCaseId, Map<Long, TestCase> testCases, List<Long> blocked) {
        TestCase testCase = testCases.get(targetTestCaseId);
        if (testCase == null) {
            throw new IllegalArgumentException("Cannot find test case with id " + String.valueOf(targetTestCaseId));
        }
        IsScriptedTestCaseVisitor testCaseVisitor = new IsScriptedTestCaseVisitor();
        if (testCaseVisitor.isScripted()) {
            throw new IllegalArgumentException("Cannot add dataset in a scripted test case.");
        }
        if (blocked.contains(targetTestCaseId)) {
            throw new MilestoneForbidModificationException("Cannot add dataset in a test case bound to a blocking milestone.");
        }
        return testCase;
    }

    private void pasteParameters(Source source, TestCase targetTestCase, List<Parameter> targetParameters) {
        List<String> targetParameterNames = targetTestCase.getParameters().stream().map(Parameter::getName).toList();
        this.checkTargetTestCaseHasValidParameters(source.getParametersNames(), targetParameterNames);
        if (!targetParameterNames.isEmpty()) {
            return;
        }
        for (Parameter parameter : source.getParameters()) {
            Parameter duplicatedParameter = new Parameter();
            duplicatedParameter.setName(parameter.getName());
            duplicatedParameter.setDescription(parameter.getDescription());
            duplicatedParameter.setTestCase(targetTestCase);
            targetParameters.add(duplicatedParameter);
        }
    }

    private void pasteDataset(Source source, TestCase targetTestCase, List<Parameter> targetParameters) {
        Dataset dataset = new Dataset();
        String name = this.resolveDatasetName(targetTestCase, source.getDatasetName());
        dataset.setName(name);
        dataset.setTestCase(targetTestCase);
        targetTestCase.addDataset(dataset);
        if (source.hasNoParameters()) {
            return;
        }
        for (Parameter parameter : targetParameters) {
            String parameterValue;
            DatasetParamValue targetDatasetParamValue = new DatasetParamValue(parameter, dataset);
            dataset.addParameterValue(targetDatasetParamValue);
            if (!parameter.getTestCase().getId().equals(targetTestCase.getId()) || (parameterValue = source.getDatasetParamValue(parameter)) == null) continue;
            targetDatasetParamValue.setParamValue(parameterValue);
        }
    }

    private List<Long> checkAndFilterIdsByPermission(List<Long> targetTestCasesIds) {
        return targetTestCasesIds.stream().filter(id -> this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.WRITE.name(), (Long)id, TestCase.class.getName())).toList();
    }

    private void checkTargetTestCaseHasValidParameters(List<String> sourceParameters, List<String> targetParameters) {
        boolean areMatching = ParameterComparator.checkHasMatchingParameters(sourceParameters, targetParameters);
        if (!areMatching) {
            throw new IllegalArgumentException("Illegal dataset duplication: target parameters are different from source parameters.");
        }
    }

    private Map<Long, TestCaseParameterOperationReport> compileDatasetCopyReport(List<Long> duplicationSuccessTCIds, Long sourceTestCaseId) {
        HashMap<Long, TestCaseParameterOperationReport> datasetCopyReport = new HashMap<Long, TestCaseParameterOperationReport>();
        duplicationSuccessTCIds.forEach(tcId -> {
            if (tcId.equals(sourceTestCaseId)) {
                TestCaseParameterOperationReport testCaseParameterOperationReport = this.testCaseDisplayService.findParametersData((Long)tcId);
                datasetCopyReport.put((Long)tcId, testCaseParameterOperationReport);
            } else {
                datasetCopyReport.put((Long)tcId, new TestCaseParameterOperationReport());
            }
        });
        return datasetCopyReport;
    }

    private String resolveDatasetName(TestCase targetTestCase, String sourceName) {
        List<String> datasetNames = targetTestCase.getDatasets().stream().map(Dataset::getName).toList();
        boolean isNameAlreadyExists = datasetNames.contains(sourceName);
        if (!isNameAlreadyExists) {
            return sourceName;
        }
        String sourceDatasetName = sourceName;
        int i = 0;
        String copySuffix = this.messageSource.getMessage("label.CopySuffix", null, LocaleContextHolder.getLocale());
        while (isNameAlreadyExists) {
            String testedName = sourceDatasetName + copySuffix + ++i;
            isNameAlreadyExists = datasetNames.contains(testedName);
        }
        return i == 0 ? sourceDatasetName : sourceDatasetName + copySuffix + i;
    }

    private static final class Source {
        private final Set<Parameter> parameters;
        private final List<String> parametersNames;
        private final Dataset sourceDataset;
        private final Map<String, String> parameterValueByParameterName;

        public Source(TestCase testCase, Dataset sourceDataset) {
            this.parameters = testCase.getParameters();
            this.parametersNames = this.parameters.stream().map(Parameter::getName).toList();
            this.sourceDataset = sourceDataset;
            this.parameterValueByParameterName = this.getParamValuesMap(sourceDataset);
        }

        private Map<String, String> getParamValuesMap(Dataset dataset) {
            return dataset.getParameterValues().stream().collect(Collectors.toMap(value -> value.getParameter().getName(), DatasetParamValue::getParamValue));
        }

        List<String> getParametersNames() {
            return this.parametersNames;
        }

        String getDatasetParamValue(Parameter parameter) {
            return this.parameterValueByParameterName.get(parameter.getName());
        }

        String getDatasetName() {
            return this.sourceDataset.getName();
        }

        boolean hasNoParameters() {
            return this.parameters.isEmpty();
        }

        Set<Parameter> getParameters() {
            return this.parameters;
        }
    }
}

