/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.jooq.CommonTableExpression;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectOrderByStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateConditionStep;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.TclnRelationshipClosure;
import org.squashtest.tm.jooq.domain.tables.TestCaseLibraryContent;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.repository.TestCaseDeletionDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.internal.repository.hibernate.AbstractHibernateDeletionDao;

@Repository
public class HibernateTestCaseDeletionDao
extends AbstractHibernateDeletionDao
implements TestCaseDeletionDao {
    private static final String FOLDER_IDS = "folderIds";
    private static final String NODE_IDS = "nodeIds";

    public HibernateTestCaseDeletionDao(DSLContext dsl) {
        super(dsl);
    }

    @Override
    public void removeEntities(List<Long> entityIds) {
        throw new UnsupportedOperationException();
    }

    private void softDeleteNodesUpdate(Collection<Long> nodeIds) {
        this.dsl.update((Table)Tables.TEST_CASE_LIBRARY_NODE).set((Field)Tables.TEST_CASE_LIBRARY_NODE.DELETED_BY, (Object)UserContextHolder.getUsername()).set((Field)Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON, (Object)Timestamp.valueOf(LocalDateTime.now())).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(nodeIds)).execute();
    }

    @Override
    public void setExecStepInboundReferencesToNull(List<Long> testStepIds) {
        if (testStepIds.isEmpty()) {
            return;
        }
        this.dsl.update((Table)Tables.EXECUTION_STEP).setNull((Field)Tables.EXECUTION_STEP.TEST_STEP_ID).where(Tables.EXECUTION_STEP.TEST_STEP_ID.in(testStepIds)).execute();
    }

    @Override
    public Map<String, List<Long>> separateFolderFromTestCaseIds(List<Long> originalIds) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        ArrayList<Long> testcaseIds = new ArrayList<Long>();
        List filteredFolderIds = this.dsl.select((SelectField)Tables.TEST_CASE_FOLDER.TCLN_ID).from((TableLike)Tables.TEST_CASE_FOLDER).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_FOLDER.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TEST_CASE_FOLDER.TCLN_ID.in(originalIds)).fetch((Field)Tables.TEST_CASE_FOLDER.TCLN_ID);
        for (Long oId : originalIds) {
            if (filteredFolderIds.contains(oId)) {
                folderIds.add(oId);
                continue;
            }
            testcaseIds.add(oId);
        }
        HashMap<String, List<Long>> idsMap = new HashMap<String, List<Long>>();
        idsMap.put(NODE_IDS, testcaseIds);
        idsMap.put(FOLDER_IDS, folderIds);
        return idsMap;
    }

    @Override
    public List<Long> findRemainingTestCaseIds(List<Long> originalIds) {
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE.TCLN_ID.in(originalIds).and(ConditionsConstants.TCLN_NOT_IN_BIN)).fetch((Field)Tables.TEST_CASE.TCLN_ID);
    }

    @Override
    public void unbindFromMilestone(List<Long> testCaseIds, Long milestoneId) {
        if (testCaseIds.isEmpty()) {
            return;
        }
        this.dsl.deleteFrom((Table)Tables.MILESTONE_TEST_CASE).where(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Object)milestoneId).and(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.in(testCaseIds))).execute();
    }

    @Override
    public List<Long> findTestCasesWhichMilestonesForbidsDeletion(List<Long> ids) {
        if (ids.isEmpty()) {
            return new ArrayList<Long>();
        }
        List<String> blockingStatuses = MilestoneStatus.MILESTONE_BLOCKING_STATUSES.stream().map(Enum::name).toList();
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.TEST_CASE.TCLN_ID.in(ids).and(Tables.MILESTONE.STATUS.in(blockingStatuses))).fetch((Field)Tables.TEST_CASE.TCLN_ID);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Long[]> findPairedNodeHierarchy(List<Long> nodeIds) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Long> findNodeHierarchy(List<Long> nodeIds) {
        return this.dsl.selectDistinct((SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(nodeIds).and(Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.notEqual((Object)0))).orderBy((OrderField)Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH).fetch((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID);
    }

    @Override
    public void transientlyRestoreNodes(NodeScope nodeScope, Consumer<List<Long>> action) {
        Select<Record1<Long>> restorableNodesQuery = this.getTransientRestorableNodeQuery(nodeScope);
        List restorableNodeIds = restorableNodesQuery.fetch((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID);
        if (!restorableNodeIds.isEmpty()) {
            this.buildUpdateQuery(restorableNodesQuery).execute();
        }
        action.accept(restorableNodeIds);
        this.softDeleteNodesUpdate(restorableNodeIds);
    }

    private Select<Record1<Long>> getTransientRestorableNodeQuery(NodeScope nodeScope) {
        Select query = this.getRestorableNodesQuery(nodeScope);
        if (nodeScope.hasLibraries()) {
            TestCaseLibraryContent content = Tables.TEST_CASE_LIBRARY_CONTENT.as("tcln_content");
            query = query.union((Select)DSL.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).join((TableLike)content).on(Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID.eq((Field)content.LIBRARY_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(content.CONTENT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(ConditionsConstants.TCLN_IN_BIN).and(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.in(nodeScope.getNodeIds())));
        }
        if (nodeScope.hasNodes()) {
            TclnRelationshipClosure closure = Tables.TCLN_RELATIONSHIP_CLOSURE.as("tcln_closure");
            query = query.union((Select)DSL.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).join((TableLike)closure).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)closure.ANCESTOR_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(closure.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(nodeScope.getNodeIds()).and(ConditionsConstants.TCLN_IN_BIN)));
        }
        return query;
    }

    private Select<Record1<Long>> getRestorableNodesQuery(NodeScope scope) {
        SelectConditionStep<Record1<Long>> query = null;
        if (scope.hasLibraries()) {
            query = this.getLibrariesDeletedContent(scope.getLibraryIds());
        }
        if (scope.hasNodes()) {
            Select folderQuery = this.getNodesDeletedContent(scope.getNodeIds());
            query = query == null ? folderQuery : query.union(folderQuery);
        }
        return query;
    }

    private SelectConditionStep<Record1<Long>> getLibrariesDeletedContent(Set<Long> libraryIds) {
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("TCLN_ID")).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.PROJECT.TCL_ID.in(libraryIds).and(ConditionsConstants.TCLN_IN_BIN));
    }

    private SelectOrderByStep<Record1<Long>> getNodesDeletedContent(Set<Long> nodeIds) {
        return this.dsl.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("TCLN_ID")).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(nodeIds).and(ConditionsConstants.TCLN_IN_BIN)).union((Select)DSL.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("TCLN_ID")).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(nodeIds).and(ConditionsConstants.TCLN_IN_BIN)));
    }

    private UpdateConditionStep<?> buildUpdateQuery(Select<Record1<Long>> restorableNodesQuery) {
        return switch (this.dsl.dialect()) {
            case SQLDialect.MARIADB -> this.dsl.update((Table)Tables.TEST_CASE_LIBRARY_NODE).setNull((Field)Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON).setNull((Field)Tables.TEST_CASE_LIBRARY_NODE.DELETED_BY).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(restorableNodesQuery));
            case SQLDialect.POSTGRES -> {
                CommonTableExpression cte = DSL.name((String)"restorable_nodes_table").fields("TCLN_ID").as(restorableNodesQuery);
                yield this.dsl.with(new CommonTableExpression[]{cte}).update((Table)Tables.TEST_CASE_LIBRARY_NODE).setNull((Field)Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON).setNull((Field)Tables.TEST_CASE_LIBRARY_NODE.DELETED_BY).from((TableLike)cte).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(cte.field("TCLN_ID", Long.class)));
            }
            default -> throw new UnsupportedOperationException("Dialect not supported: " + String.valueOf(this.dsl.dialect()));
        };
    }

    @Override
    public Optional<Long> getLibraryIdForEmptyingWorkspace(Long projectId) {
        return this.dsl.select((SelectField)Tables.PROJECT.TCL_ID).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId).and(DSL.exists((Select)DSL.selectOne().from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID))))).fetchOptional((Field)Tables.PROJECT.TCL_ID);
    }
}

