/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.CampaignDeletionDao;
import org.squashtest.tm.service.internal.repository.hibernate.AbstractHibernateDeletionDao;

@Repository
public class HibernateCampaignDeletionDao
extends AbstractHibernateDeletionDao
implements CampaignDeletionDao {
    private static final String CAMPAIGN_IDS = "campaignIds";
    private static final String NODE_IDS = "nodeIds";
    private static final String FOLDER_IDS = "folderIds";

    public HibernateCampaignDeletionDao(DSLContext dsl) {
        super(dsl);
    }

    @Override
    public void removeEntities(List<Long> entityIds) {
        if (!entityIds.isEmpty()) {
            for (Long entityId : entityIds) {
                CampaignLibraryNode node = (CampaignLibraryNode)this.em.getReference(CampaignLibraryNode.class, (Object)entityId);
                this.removeEntityFromParentLibraryIfExists(entityId, node);
                this.removeEntityFromParentFolderIfExists(entityId, node);
                if (node == null) continue;
                this.em.remove((Object)node);
                this.em.flush();
            }
        }
    }

    private void removeEntityFromParentLibraryIfExists(Long entityId, CampaignLibraryNode node) {
        CampaignLibrary library = (CampaignLibrary)this.em.createNamedQuery("campaignLibraryNode.findParentLibraryIfExists", CampaignLibrary.class).setParameter("libraryNodeId", (Object)entityId).getSingleResult();
        if (library != null) {
            for (CampaignLibraryNode tcln : library.getContent()) {
                if (!tcln.getId().equals(node.getId())) continue;
                library.removeContent(tcln);
                break;
            }
        }
    }

    private void removeEntityFromParentFolderIfExists(Long entityId, CampaignLibraryNode node) {
        TypedQuery query = this.em.createNamedQuery("campaignLibraryNode.findParentFolderIfExists", CampaignFolder.class);
        query.setParameter("libraryNodeId", (Object)entityId);
        CampaignFolder folder = (CampaignFolder)query.getSingleResult();
        if (folder != null) {
            for (CampaignLibraryNode tcln : folder.getContent()) {
                if (!tcln.getId().equals(node.getId())) continue;
                folder.removeContent(tcln);
                break;
            }
        }
    }

    @Override
    public Map<String, List<Long>> separateFolderFromCampaignIds(List<Long> originalIds) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        ArrayList<Long> campaignIds = new ArrayList<Long>();
        List filtredFolderIds = this.executeSelectSQLQuery("select folder.cln_id from CAMPAIGN_FOLDER folder where folder.cln_id in (:campaignIds)", CAMPAIGN_IDS, originalIds);
        for (Long oId : originalIds) {
            if (filtredFolderIds.contains(oId)) {
                folderIds.add(oId);
                continue;
            }
            campaignIds.add(oId);
        }
        return Map.of(FOLDER_IDS, folderIds, NODE_IDS, campaignIds);
    }

    @Override
    public void unbindFromMilestone(List<Long> campaignIds, Long milestoneId) {
        if (!campaignIds.isEmpty()) {
            this.em.createNativeQuery("delete from MILESTONE_CAMPAIGN where MILESTONE_ID = :milestoneId and CAMPAIGN_ID in (:campaignIds)").setParameter(CAMPAIGN_IDS, campaignIds).setParameter("milestoneId", (Object)milestoneId).executeUpdate();
        }
    }

    @Override
    public List<Long> findCampaignsWhichMilestonesForbidsDeletion(List<Long> originalId) {
        if (!originalId.isEmpty()) {
            MilestoneStatus[] blockingStatuses = new MilestoneStatus[MilestoneStatus.MILESTONE_BLOCKING_STATUSES.size()];
            MilestoneStatus.MILESTONE_BLOCKING_STATUSES.toArray(blockingStatuses);
            return this.em.createNamedQuery("campaign.findCampaignsWhichMilestonesForbidsDeletion", Long.class).setParameter(CAMPAIGN_IDS, originalId).setParameter("lockedStatuses", Arrays.asList(blockingStatuses)).getResultList();
        }
        return new ArrayList<Long>();
    }

    @Override
    public List<Long> findRemainingCampaignIds(List<Long> originalIds) {
        List rawids = this.executeSelectSQLQuery("select CLN_ID from CAMPAIGN where CLN_ID in (:allCampaignIds)", "allCampaignIds", originalIds);
        ArrayList<Long> cIds = new ArrayList<Long>(rawids.size());
        cIds.addAll(rawids);
        return cIds;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Long[]> findPairedNodeHierarchy(List<Long> nodeIds) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Long> findNodeHierarchy(List<Long> nodeIds) {
        return this.dsl.selectDistinct((SelectField)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH).from((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).where(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(nodeIds).and(Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH.notEqual((Object)0))).orderBy((OrderField)Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH).fetch((Field)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID);
    }

    @Override
    public Long countDeletableIterationAndTestSuite(List<Long> nodeIds) {
        Field iterationCount = this.dsl.selectCount().from((TableLike)Tables.CAMPAIGN_ITERATION).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.in(nodeIds)).asField();
        Field testSuiteCount = this.dsl.selectCount().from((TableLike)Tables.CAMPAIGN_ITERATION).innerJoin((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION_TEST_SUITE.ITERATION_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.in(nodeIds)).asField();
        return (Long)this.dsl.select((SelectField)iterationCount.plus(testSuiteCount)).fetchOneInto(Long.class);
    }
}

