/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.bdd.BddScriptLanguage;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CampaignLibrary;
import org.squashtest.tm.jooq.domain.tables.DisabledExecutionStatus;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.jooq.domain.tables.TestPlan;
import org.squashtest.tm.jooq.domain.tables.TestPlanItem;
import org.squashtest.tm.service.internal.display.dto.PivotFormatImportDto;
import org.squashtest.tm.service.internal.display.dto.ProjectDto;
import org.squashtest.tm.service.internal.display.dto.ProjectViewDto;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.display.ProjectDisplayDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.internal.repository.hibernate.ProjectDaoImpl;

@Repository
public class ProjectDisplayDaoImpl
implements ProjectDisplayDao {
    private static final Project PROJECT_TEMPLATE = Project.PROJECT.as("PROJECT_TEMPLATE");
    private static final String PROJECT_TEMPLATE_NAME_FIELD = "PROJECT_TEMPLATE.NAME";
    private static final String PROJECT_TEMPLATE_PROJECT_ID_FIELD = "PROJECT_TEMPLATE.PROJECT_ID";
    private final DSLContext dsl;

    public ProjectDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public ProjectViewDto getProjectOrTemplateById(Long projectId) {
        return (ProjectViewDto)this.dsl.select(this.getBaseRequestSelectField()).from((TableLike)Project.PROJECT).leftJoin((TableLike)PROJECT_TEMPLATE).on(ProjectDisplayDaoImpl.PROJECT_TEMPLATE.PROJECT_ID.eq((Field)Project.PROJECT.TEMPLATE_ID)).where(Project.PROJECT.PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Project.PROJECT.PROJECT_ID, ProjectDisplayDaoImpl.PROJECT_TEMPLATE.NAME, ProjectDisplayDaoImpl.PROJECT_TEMPLATE.PROJECT_ID}).fetchOneInto(ProjectViewDto.class);
    }

    @Override
    public List<ProjectDto> getActiveProjectsByIds(List<Long> projectIds) {
        return this.dsl.select(this.getBaseRequestSelectField()).from((TableLike)Project.PROJECT).leftJoin((TableLike)PROJECT_TEMPLATE).on(ProjectDisplayDaoImpl.PROJECT_TEMPLATE.PROJECT_ID.eq((Field)Project.PROJECT.TEMPLATE_ID)).where(Project.PROJECT.PROJECT_ID.in(projectIds)).and(Project.PROJECT.PROJECT_TYPE.eq((Object)"P")).groupBy(new GroupField[]{Project.PROJECT.PROJECT_ID, DSL.field((String)PROJECT_TEMPLATE_NAME_FIELD), DSL.field((String)PROJECT_TEMPLATE_PROJECT_ID_FIELD)}).fetchInto(ProjectDto.class);
    }

    @Override
    public List<ProjectDto> getActiveProjectsByIds(UserDto currentUser) {
        Table<Record1<Long>> readableProjectTable = ProjectDaoImpl.selectAllReadableProjectIdsQuery(currentUser);
        return this.dsl.select(this.getBaseRequestSelectField()).from(readableProjectTable).innerJoin((TableLike)Project.PROJECT).on(Project.PROJECT.PROJECT_ID.eq(readableProjectTable.field("PROJECT_ID", Long.class))).leftJoin((TableLike)PROJECT_TEMPLATE).on(ProjectDisplayDaoImpl.PROJECT_TEMPLATE.PROJECT_ID.eq((Field)Project.PROJECT.TEMPLATE_ID)).where(Project.PROJECT.PROJECT_TYPE.eq((Object)"P")).groupBy(new GroupField[]{Project.PROJECT.PROJECT_ID, DSL.field((String)PROJECT_TEMPLATE_NAME_FIELD), DSL.field((String)PROJECT_TEMPLATE_PROJECT_ID_FIELD)}).fetchInto(ProjectDto.class);
    }

    @Override
    public Map<Long, List<String>> getDisabledExecutionStatus(Set<Long> projectIds) {
        return this.dsl.select((SelectField)Project.PROJECT.PROJECT_ID, (SelectField)DisabledExecutionStatus.DISABLED_EXECUTION_STATUS.EXECUTION_STATUS).from((TableLike)Project.PROJECT).innerJoin((TableLike)CampaignLibrary.CAMPAIGN_LIBRARY).on(Project.PROJECT.CL_ID.eq((Field)CampaignLibrary.CAMPAIGN_LIBRARY.CL_ID)).innerJoin((TableLike)DisabledExecutionStatus.DISABLED_EXECUTION_STATUS).on(CampaignLibrary.CAMPAIGN_LIBRARY.CL_ID.eq((Field)DisabledExecutionStatus.DISABLED_EXECUTION_STATUS.CL_ID)).where(Project.PROJECT.PROJECT_ID.in(projectIds)).fetchGroups((Field)Project.PROJECT.PROJECT_ID, (Field)DisabledExecutionStatus.DISABLED_EXECUTION_STATUS.EXECUTION_STATUS);
    }

    @Override
    public Map<Long, List<String>> getDisabledExecutionStatus(UserDto currentUserDto) {
        Table<Record1<Long>> readableProjectTable = ProjectDaoImpl.selectAllReadableProjectIdsQuery(currentUserDto);
        return this.dsl.select((SelectField)Project.PROJECT.PROJECT_ID, (SelectField)DisabledExecutionStatus.DISABLED_EXECUTION_STATUS.EXECUTION_STATUS).from((TableLike)Project.PROJECT).join(readableProjectTable).on(Project.PROJECT.PROJECT_ID.eq(readableProjectTable.field("PROJECT_ID", Long.class))).join((TableLike)CampaignLibrary.CAMPAIGN_LIBRARY).on(Project.PROJECT.CL_ID.eq((Field)CampaignLibrary.CAMPAIGN_LIBRARY.CL_ID)).join((TableLike)DisabledExecutionStatus.DISABLED_EXECUTION_STATUS).on(CampaignLibrary.CAMPAIGN_LIBRARY.CL_ID.eq((Field)DisabledExecutionStatus.DISABLED_EXECUTION_STATUS.CL_ID)).fetchGroups((Field)Project.PROJECT.PROJECT_ID, (Field)DisabledExecutionStatus.DISABLED_EXECUTION_STATUS.EXECUTION_STATUS);
    }

    @Override
    public List<Long> getProjectsLinkedToTemplate(Long templateId) {
        return this.dsl.select((SelectField)Project.PROJECT.PROJECT_ID).from((TableLike)Project.PROJECT).where(Project.PROJECT.TEMPLATE_ID.eq((Object)templateId)).fetch().into(Long.class);
    }

    @Override
    public void appendActivatedPlugins(List<ProjectDto> projects) {
        if (Objects.nonNull(projects) && !projects.isEmpty()) {
            Map projectsMap = projects.stream().collect(Collectors.toMap(ProjectDto::getId, Function.identity()));
            Set projectIds = projects.stream().map(ProjectDto::getId).collect(Collectors.toSet());
            this.dsl.select((SelectField)Tables.LIBRARY_PLUGIN_BINDING.PLUGIN_ID, (SelectField)Tables.LIBRARY_PLUGIN_BINDING.LIBRARY_TYPE, (SelectField)Project.PROJECT.PROJECT_ID).from((TableLike)Tables.LIBRARY_PLUGIN_BINDING).leftJoin((TableLike)Project.PROJECT).on(Project.PROJECT.CL_ID.eq((Field)Tables.LIBRARY_PLUGIN_BINDING.LIBRARY_ID).and(Tables.LIBRARY_PLUGIN_BINDING.LIBRARY_TYPE.eq((Object)"C"))).or(Project.PROJECT.TCL_ID.eq((Field)Tables.LIBRARY_PLUGIN_BINDING.LIBRARY_ID).and(Tables.LIBRARY_PLUGIN_BINDING.LIBRARY_TYPE.eq((Object)"T"))).or(Project.PROJECT.RL_ID.eq((Field)Tables.LIBRARY_PLUGIN_BINDING.LIBRARY_ID).and(Tables.LIBRARY_PLUGIN_BINDING.LIBRARY_TYPE.eq((Object)"R"))).where(Project.PROJECT.PROJECT_ID.in(projectIds)).and(Tables.LIBRARY_PLUGIN_BINDING.ACTIVE.eq((Object)true)).orderBy((OrderField)Project.PROJECT.PROJECT_ID).fetch().forEach(record -> {
                ProjectDto projectDto = (ProjectDto)projectsMap.get(record.get((Field)Project.PROJECT.PROJECT_ID));
                WorkspaceType workspaceType = this.getWorkspaceType((String)record.get((Field)Tables.LIBRARY_PLUGIN_BINDING.LIBRARY_TYPE));
                projectDto.addActivatedPlugin((String)record.get((Field)Tables.LIBRARY_PLUGIN_BINDING.PLUGIN_ID), workspaceType);
            });
        }
    }

    @Override
    public Long getTaServerIdByProjectId(Long projectId) {
        return (Long)((Record1)this.dsl.select((SelectField)Project.PROJECT.TA_SERVER_ID).from((TableLike)Project.PROJECT).where(Project.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchOne()).into(Long.class);
    }

    @Override
    public List<NamedReference> findProjectsByTemplateId(Long templateId) {
        return this.dsl.select((SelectField)Project.PROJECT.PROJECT_ID, (SelectField)Project.PROJECT.NAME).from((TableLike)Project.PROJECT).where(Project.PROJECT.TEMPLATE_ID.eq((Object)templateId)).fetch().into(NamedReference.class);
    }

    @Override
    public List<NamedReference> findAllReferences() {
        return this.dsl.select((SelectField)Project.PROJECT.PROJECT_ID, (SelectField)Project.PROJECT.NAME).from((TableLike)Project.PROJECT).where(Project.PROJECT.PROJECT_TYPE.eq((Object)"T")).orderBy((OrderField)Project.PROJECT.NAME).fetchInto(NamedReference.class);
    }

    private WorkspaceType getWorkspaceType(String type) {
        return switch (type) {
            case "R" -> WorkspaceType.REQUIREMENT_WORKSPACE;
            case "C" -> WorkspaceType.CAMPAIGN_WORKSPACE;
            case "T" -> WorkspaceType.TEST_CASE_WORKSPACE;
            default -> throw new IllegalArgumentException("Unhandled workspace type: " + type);
        };
    }

    private List<Field<?>> getBaseRequestSelectField() {
        return List.of(Project.PROJECT.PROJECT_ID.as("ID"), Project.PROJECT.NAME, Project.PROJECT.LABEL, Project.PROJECT.TC_NATURES_LIST.as("TEST_CASE_NATURE_ID"), Project.PROJECT.TC_TYPES_LIST.as("TEST_CASE_TYPE_ID"), Project.PROJECT.REQ_CATEGORIES_LIST.as("REQUIREMENT_CATEGORY_ID"), Project.PROJECT.ALLOW_AUTOMATION_WORKFLOW, Project.PROJECT.TA_SERVER_ID, Project.PROJECT.AUTOMATION_WORKFLOW_TYPE, Project.PROJECT.ATTACHMENT_LIST_ID, Project.PROJECT.CREATED_ON, Project.PROJECT.CREATED_BY, Project.PROJECT.LAST_MODIFIED_ON, Project.PROJECT.LAST_MODIFIED_BY, Project.PROJECT.DESCRIPTION, ProjectDisplayDaoImpl.PROJECT_TEMPLATE.NAME.as("LINKED_TEMPLATE"), ProjectDisplayDaoImpl.PROJECT_TEMPLATE.PROJECT_ID.as("LINKED_TEMPLATE_ID"), DSL.field((Condition)Project.PROJECT.PROJECT_TYPE.eq((Object)"T")).as("TEMPLATE"), Project.PROJECT.SCM_REPOSITORY_ID, Project.PROJECT.USE_TREE_STRUCTURE_IN_SCM_REPO, DSL.selectCount().from((TableLike)Tables.TEST_AUTOMATION_PROJECT).where(Tables.TEST_AUTOMATION_PROJECT.TM_PROJECT_ID.eq((Field)Project.PROJECT.PROJECT_ID)).asField("TA_PROJECT_COUNT"), Project.PROJECT.BDD_SCRIPT_LANGUAGE, Project.PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY, Project.PROJECT.ALLOW_TC_MODIF_DURING_EXEC, Project.PROJECT.AUTOMATED_SUITES_LIFETIME, Project.PROJECT.AI_SERVER_ID.as("LEGACY_AI_SERVER_ID"), Project.PROJECT.BUGTRACKER_ID);
    }

    @Override
    public BddScriptLanguage findBddScriptLanguageByProjectId(long projectId) {
        String bddScriptLanguage = (String)this.dsl.select((SelectField)Project.PROJECT.BDD_SCRIPT_LANGUAGE).from((TableLike)Project.PROJECT).where(Project.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchOneInto(String.class);
        return BddScriptLanguage.valueOf((String)bddScriptLanguage);
    }

    @Override
    public Map<Long, Boolean> allowAutomationWorkflowByProjectId(List<Long> projectIds) {
        Result result = this.dsl.select((SelectField)Project.PROJECT.PROJECT_ID, (SelectField)Project.PROJECT.ALLOW_AUTOMATION_WORKFLOW).from((TableLike)Project.PROJECT).where(Project.PROJECT.PROJECT_ID.in(projectIds)).fetch();
        return result.stream().collect(Collectors.toMap(record -> (Long)record.get((Field)Project.PROJECT.PROJECT_ID), record -> (Boolean)record.get((Field)Project.PROJECT.ALLOW_AUTOMATION_WORKFLOW)));
    }

    @Override
    public List<String> fetchBugtrackerProjectNames(long projectId) {
        return this.dsl.select((SelectField)Tables.BUGTRACKER_PROJECT.BUGTRACKER_PROJECT_NAME).from((TableLike)Tables.BUGTRACKER_PROJECT).join((TableLike)Project.PROJECT).on(Tables.BUGTRACKER_PROJECT.PROJECT_ID.eq((Field)Project.PROJECT.PROJECT_ID)).where(Tables.BUGTRACKER_PROJECT.PROJECT_ID.eq((Object)projectId)).and(Project.PROJECT.BUGTRACKER_ID.isNotNull()).orderBy((OrderField)Tables.BUGTRACKER_PROJECT.BUGTRACKER_PROJECT_ORDER).fetchInto(String.class);
    }

    @Override
    public List<PivotFormatImportDto> getExistingImports(Long projectId) {
        return this.dsl.select((SelectField)Tables.PIVOT_FORMAT_IMPORT.PFI_ID.as("ID"), (SelectField)Tables.PIVOT_FORMAT_IMPORT.NAME, (SelectField)Tables.PIVOT_FORMAT_IMPORT.STATUS, (SelectField)Tables.PIVOT_FORMAT_IMPORT.IMPORT_TYPE.as("TYPE"), (SelectField)Tables.PIVOT_FORMAT_IMPORT.CREATED_ON, (SelectField)Tables.PIVOT_FORMAT_IMPORT.SUCCESSFULLY_IMPORTED_ON, (SelectField)Tables.CORE_USER.LOGIN.as("CREATED_BY")).from((TableLike)Tables.PIVOT_FORMAT_IMPORT).leftJoin((TableLike)Tables.CORE_USER).on(Tables.PIVOT_FORMAT_IMPORT.CREATED_BY.eq((Field)Tables.CORE_USER.PARTY_ID)).where(Tables.PIVOT_FORMAT_IMPORT.PROJECT_ID.eq((Object)projectId)).fetchInto(PivotFormatImportDto.class);
    }

    @Override
    public boolean findHasKnownIssuesByProjectIdAndBugtrackerId(long projectId, long bugtrackerId) {
        return this.dsl.fetchExists((Select)DSL.selectOne().from((TableLike)Tables.ISSUE).innerJoin((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.ISSUE.ISSUE_ID.eq((Field)Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID)).innerJoin((TableLike)TestPlanItem.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)TestPlanItem.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin((TableLike)TestPlan.TEST_PLAN).on(TestPlanItem.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)TestPlan.TEST_PLAN.TEST_PLAN_ID)).join((TableLike)Project.PROJECT).on(Project.PROJECT.CL_ID.eq((Field)TestPlan.TEST_PLAN.CL_ID).and(Tables.ISSUE.BUGTRACKER_ID.eq((Field)Project.PROJECT.BUGTRACKER_ID))).where(Project.PROJECT.PROJECT_ID.eq((Object)projectId)).and(Tables.ISSUE.BUGTRACKER_ID.eq((Object)bugtrackerId)).groupBy(new GroupField[]{Project.PROJECT.PROJECT_ID, Tables.ISSUE.BUGTRACKER_ID, Tables.ISSUE.REMOTE_ISSUE_ID}));
    }

    @Override
    public boolean hasElementsInBin(UserDto currentUserDto) {
        Table<Record1<Long>> readableProjectTable = ProjectDaoImpl.selectAllReadableProjectIdsQuery(currentUserDto);
        return this.dsl.fetchExists((Select)DSL.selectOne().from(readableProjectTable).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq(readableProjectTable.field("PROJECT_ID", Long.class)).and(ConditionsConstants.TCLN_IN_BIN)));
    }
}

