/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.restoration.testcase;

import jakarta.persistence.EntityManager;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record1;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.deletion.NodeRenaming;
import org.squashtest.tm.service.deletion.NodeRestoreNameResolver;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.deletion.helper.testcase.TestCaseNodeScopeQueryHelper;
import org.squashtest.tm.service.internal.deletion.restoration.jdbc.AbstractJdbcRestorationHandler;
import org.squashtest.tm.service.internal.helper.JooqUpdateHelper;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

public class JdbcTestCaseNodeRestorationHandler
extends AbstractJdbcRestorationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcTestCaseNodeRestorationHandler.class);
    private static final String TEST_CASE_NODE = "test-case";
    private static final String FOLDER_NODE = "folder";
    private final NodeScope scope;
    private final NodeRestoreNameResolver nodeRestoreNameResolver;

    public JdbcTestCaseNodeRestorationHandler(EntityManager entityManager, DSLContext dslContext, NodeRestoreNameResolver nodeRestoreNameResolver, NodeScope scope) {
        super(entityManager, dslContext);
        this.nodeRestoreNameResolver = nodeRestoreNameResolver;
        this.scope = scope;
    }

    public OperationReport restoreNodes() {
        this.logStartProcess();
        List<NodeRenaming> renameNodes = this.renameRestoredNodes();
        Table<Record1<Long>> restorableNodesTable = this.buildRestorableNodesQuery();
        OperationReport report = this.buildRestoreOperationReport(restorableNodesTable, renameNodes);
        this.executeNodeRestoration(restorableNodesTable);
        this.logEndProcess();
        return report;
    }

    private Table<Record1<Long>> buildRestorableNodesQuery() {
        Object query = TestCaseNodeScopeQueryHelper.buildDeletedTestCaseNodeScopeQuery(this.scope, DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID));
        if (this.scope.hasNodes()) {
            query = this.appendDeletedAncestorNodes((Select<Record1<Long>>)query);
        }
        return query.asTable("restorable_node");
    }

    private Select<Record1<Long>> appendDeletedAncestorNodes(Select<Record1<Long>> query) {
        return query.union((Select)DSL.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(this.scope.getNodeIds()).and(ConditionsConstants.TCLN_IN_BIN)));
    }

    private List<NodeRenaming> renameRestoredNodes() {
        Map<NodeType, List<NodeRenaming>> renamedNodes = this.nodeRestoreNameResolver.resolveDuplicateNamesInScope(this.scope);
        List<NodeRenaming> list = renamedNodes.values().stream().flatMap(Collection::stream).toList();
        if (list.isEmpty()) {
            return list;
        }
        BatchBindStep batch = this.dslContext.batch((Query)this.dslContext.update((Table)Tables.TEST_CASE_LIBRARY_NODE).set((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME, null).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(null)));
        list.forEach(node -> {
            BatchBindStep batchBindStep2 = batch.bind(new Object[]{node.getName(), node.getNodeId()});
        });
        batch.execute();
        return list;
    }

    private OperationReport buildRestoreOperationReport(Table<Record1<Long>> restorableNodesTable, List<NodeRenaming> renamedNodes) {
        OperationReport report = new OperationReport();
        SelectOnConditionStep query = this.dslContext.select((SelectField)restorableNodesTable.field("TCLN_ID", Long.class).as("TCLN_ID"), (SelectField)Tables.TEST_CASE_FOLDER.TCLN_ID.isNotNull().as("IS_FOLDER")).from(restorableNodesTable).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(restorableNodesTable.field("TCLN_ID", Long.class).eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID));
        Throwable throwable = null;
        Iterator<NodeRenaming> iterator = null;
        try (Stream stream = query.fetchStream();){
            Map partitioned = stream.collect(Collectors.partitioningBy(tuple -> (Boolean)tuple.get("IS_FOLDER", Boolean.class), Collectors.mapping(tuple -> (Long)tuple.get("TCLN_ID", Long.class), Collectors.toList())));
            report.addRestored(partitioned.getOrDefault(true, Collections.emptyList()), FOLDER_NODE);
            report.addRestored(partitioned.getOrDefault(false, Collections.emptyList()), TEST_CASE_NODE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        for (NodeRenaming renaming : renamedNodes) {
            report.addRenamed(renaming);
        }
        return report;
    }

    private void executeNodeRestoration(Table<Record1<Long>> restorableNodesTable) {
        JooqUpdateHelper.nullifyColumnsWithJoin(this.dslContext, restorableNodesTable, Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(restorableNodesTable.field("TCLN_ID", Long.class)), Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON, Tables.TEST_CASE_LIBRARY_NODE.DELETED_BY);
    }

    private void logStartProcess() {
        LOGGER.debug(String.format("Init restoration process of test case nodes. Scope %s. Operation:  %s", this.scope.summary(), this.operationId), new Object[0]);
    }

    private void logEndProcess() {
        LOGGER.info(String.format("Restored test case nodes in scope %s. Time elapsed %s", this.scope.summary(), this.startDate.until(LocalDateTime.now(), ChronoUnit.MILLIS)), new Object[0]);
    }
}

