/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.campaign.LockedTestCaseNodeDetectionService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.deletion.AbstractNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.JdbcTestCaseNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.JdbcTestCaseNodeDeletionHandlerFactory;
import org.squashtest.tm.service.internal.deletion.LockedNodeInferenceTree;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.deletion.NodeScopeType;
import org.squashtest.tm.service.internal.repository.TestCaseDeletionDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryNodeDao;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeDeletionHandler;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.testcase.CallStepManagerService;
import org.squashtest.tm.service.testcase.TestCaseImportanceManagerService;

@Component(value="squashtest.tm.service.deletion.TestCaseNodeDeletionHandler")
@Transactional
public class TestCaseNodeDeletionHandlerImpl
extends AbstractNodeDeletionHandler
implements TestCaseNodeDeletionHandler {
    private final LockedTestCaseNodeDetectionService lockedTestCaseNodeDetectionService;
    private final TestCaseLibraryNodeDao testCaseLibraryNodeDao;
    private final TestCaseDeletionDao deletionDao;
    private final TestCaseImportanceManagerService testCaseImportanceManagerService;
    private final PrivateCustomFieldValueService customValueService;
    private final ActiveMilestoneHolder activeMilestoneHolder;
    private final CallStepManagerService callStepManagerService;
    private final JdbcTestCaseNodeDeletionHandlerFactory testCaseDeletionHandler;
    private final PluginFinderService pluginFinderService;

    public TestCaseNodeDeletionHandlerImpl(LockedTestCaseNodeDetectionService lockedTestCaseNodeDetectionService, TestCaseLibraryNodeDao testCaseLibraryNodeDao, TestCaseDeletionDao deletionDao, TestCaseImportanceManagerService testCaseImportanceManagerService, PrivateCustomFieldValueService customValueService, ActiveMilestoneHolder activeMilestoneHolder, CallStepManagerService callStepManagerService, AttachmentManagerService attachmentManagerService, MessageSource messageSource, JdbcTestCaseNodeDeletionHandlerFactory testCaseDeletionHandler, PluginFinderService pluginFinderService) {
        super(attachmentManagerService, messageSource, deletionDao);
        this.lockedTestCaseNodeDetectionService = lockedTestCaseNodeDetectionService;
        this.testCaseLibraryNodeDao = testCaseLibraryNodeDao;
        this.deletionDao = deletionDao;
        this.testCaseImportanceManagerService = testCaseImportanceManagerService;
        this.customValueService = customValueService;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.callStepManagerService = callStepManagerService;
        this.testCaseDeletionHandler = testCaseDeletionHandler;
        this.pluginFinderService = pluginFinderService;
    }

    @Override
    public OperationReport deleteNodes(List<Long> nodesIds) {
        if (nodesIds.isEmpty()) {
            return new OperationReport();
        }
        LockedNodeInferenceTree tree = this.createLockedTree(nodesIds);
        List<Long> lockedIds = tree.collectLockedIds();
        NodeScope scope = NodeScope.forNodes(nodesIds);
        OperationReport deleteReport = this.processNodeDeletion(scope, lockedIds);
        if (this.isMilestoneMode()) {
            List<Long> candidateNodeIds = tree.collectIds();
            OperationReport unbindReport = this.batchUnbindFromMilestone(candidateNodeIds);
            deleteReport.mergeWith(unbindReport);
        }
        return deleteReport;
    }

    private OperationReport processNodeDeletion(NodeScope scope, List<Long> lockedIds) {
        JdbcTestCaseNodeDeletionHandler deletionHandler = this.testCaseDeletionHandler.build(scope, lockedIds);
        if (this.pluginFinderService.isPremiumPluginInstalled()) {
            return deletionHandler.softDeleteNodes();
        }
        return deletionHandler.delete();
    }

    @Override
    public void transientlyRestoreNodes(Map<NodeScopeType, Set<Long>> nodeIdsByType, Consumer<List<Long>> action) {
        this.deletionDao.transientlyRestoreNodes(new NodeScope(nodeIdsByType), action);
    }

    @Override
    public OperationReport hardDeleteNodes(NodeScope scope) {
        return this.testCaseDeletionHandler.buildForBin(scope).delete();
    }

    @Override
    public void cleanupAll(Long projectId) {
        this.deletionDao.getLibraryIdForEmptyingWorkspace(projectId).map(libraryId -> Set.of(new NodeReference(NodeType.TEST_CASE_LIBRARY, libraryId))).map(NodeScope::of).ifPresent(scope -> {
            OperationReport operationReport = this.testCaseDeletionHandler.buildForProjectDeletion((NodeScope)scope).delete();
        });
    }

    private LockedNodeInferenceTree createLockedTree(List<Long> targetIds) {
        Map<Long, List<Long>> descendantByAncestor = this.testCaseLibraryNodeDao.findContentIdsByNodeIds(targetIds);
        LockedNodeInferenceTree tree = new LockedNodeInferenceTree(descendantByAncestor, targetIds);
        List<Long> lockedNodeIds = this.detectLockedNodes(tree.collectIds());
        tree.markLockedNodes(lockedNodeIds);
        return tree;
    }

    @Override
    protected List<SuppressionPreviewReport> diagnoseSuppression(List<Long> nodeIds) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        reportList.addAll(this.lockedTestCaseNodeDetectionService.detectLockedByExecutedTestCases(nodeIds));
        reportList.addAll(this.lockedTestCaseNodeDetectionService.detectLockedByMilestone(nodeIds));
        reportList.addAll(this.lockedTestCaseNodeDetectionService.detectLockedWithActiveMilestone(nodeIds));
        reportList.addAll(this.lockedTestCaseNodeDetectionService.detectLockedByCallSteps(nodeIds, reportList));
        return reportList;
    }

    @Override
    protected OperationReport batchDeleteNodes(List<Long> ids) {
        throw new UnsupportedOperationException("");
    }

    @Override
    protected OperationReport batchUnbindFromMilestone(List<Long> ids) {
        List<Long> remainingIds = this.deletionDao.findRemainingTestCaseIds(ids);
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        List<Long> lockedIds = this.deletionDao.findTestCasesWhichMilestonesForbidsDeletion(remainingIds);
        remainingIds.removeAll(lockedIds);
        OperationReport report = new OperationReport();
        activeMilestone.ifPresent(milestone -> this.deletionDao.unbindFromMilestone(remainingIds, milestone.getId()));
        report.addRemoved(remainingIds, "test-case");
        return report;
    }

    @Override
    public void deleteStep(final TestCase owner, TestStep step) {
        int index = owner.getPositionOfStep(step.getId().longValue());
        if (index == -1) {
            return;
        }
        owner.getSteps().remove(index);
        LinkedList<Long> stepId = new LinkedList<Long>();
        stepId.add(step.getId());
        this.deletionDao.setExecStepInboundReferencesToNull(stepId);
        TestStepVisitor testStepVisitor = new TestStepVisitor(){

            public void visit(ActionTestStep visited) {
                TestCaseNodeDeletionHandlerImpl.this.customValueService.deleteAllCustomFieldValues((BoundEntity)visited);
                TestCaseNodeDeletionHandlerImpl.this.deleteActionStep(visited);
                TestCaseNodeDeletionHandlerImpl.this.customValueService.deleteAllCustomFieldValues((BoundEntity)visited);
            }

            public void visit(CallTestStep visited) {
                TestCaseNodeDeletionHandlerImpl.this.doDeleteTestStep((TestStep)visited);
                TestCaseNodeDeletionHandlerImpl.this.deleteOrphanDatasetParamValues(visited.isDelegateParameterValues(), owner.getId());
                TestCaseNodeDeletionHandlerImpl.this.testCaseImportanceManagerService.changeImportanceIfCallStepRemoved(visited.getCalledTestCase(), owner);
            }

            public void visit(KeywordTestStep visited) {
                TestCaseNodeDeletionHandlerImpl.this.doDeleteTestStep((TestStep)visited);
            }
        };
        step.accept(testStepVisitor);
    }

    private void deleteActionStep(ActionTestStep step) {
        AttachmentList attachmentList = step.getAttachmentList();
        List<ExternalContentCoordinates> listPairContenIDListID = this.getExternalAttachmentContentCoordinatesOfObject((AttachmentHolder)step);
        this.doDeleteTestStep((TestStep)step);
        this.attachmentManager.removeAttachmentsAndLists(this.makeListAttachmentListIdFordAttachmentList(attachmentList));
        this.attachmentManager.deleteContents(listPairContenIDListID);
    }

    private void doDeleteTestStep(TestStep step) {
        this.deletionDao.removeEntity(step);
    }

    private void deleteOrphanDatasetParamValues(boolean isDelegateParameterValues, Long testCaseCallerId) {
        if (isDelegateParameterValues) {
            this.callStepManagerService.deleteOrphanDatasetParamValuesByTestCaseCallerId(testCaseCallerId);
        }
    }

    @Override
    protected boolean isMilestoneMode() {
        return this.activeMilestoneHolder.getActiveMilestone().isPresent();
    }
}

