/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.artificialintelligence.AiUseName;
import org.squashtest.tm.domain.artificialintelligence.ProjectAiConfiguration;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.artificialintelligence.testcasegeneration.AiTestCaseGenerationPermissionService;
import org.squashtest.tm.service.internal.repository.AiUseDao;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.ProjectAiConfigurationDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.repository.display.AiTestCaseGenerationDisplayDao;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class AiTestCaseGenerationPermissionServiceImpl
implements AiTestCaseGenerationPermissionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiTestCaseGenerationPermissionService.class);
    private final AiUseDao aiUseDao;
    private final ProjectAiConfigurationDao projectAiConfigurationDao;
    private final GenericProjectDao projectDao;
    private final AiTestCaseGenerationDisplayDao aiTestCaseGenerationDisplayDao;
    private final UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService;
    private final PermissionEvaluationService permissionEvaluationService;
    private final UserDao userDao;
    private final RequirementVersionDao requirementVersionDao;

    public AiTestCaseGenerationPermissionServiceImpl(AiUseDao aiUseDao, ProjectAiConfigurationDao projectAiConfigurationDao, GenericProjectDao projectDao, AiTestCaseGenerationDisplayDao aiTestCaseGenerationDisplayDao, UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService, PermissionEvaluationService permissionEvaluationService, UserDao userDao, RequirementVersionDao requirementVersionDao) {
        this.aiUseDao = aiUseDao;
        this.projectAiConfigurationDao = projectAiConfigurationDao;
        this.projectDao = projectDao;
        this.aiTestCaseGenerationDisplayDao = aiTestCaseGenerationDisplayDao;
        this.ultimateLicenseAvailabilityService = ultimateLicenseAvailabilityService;
        this.permissionEvaluationService = permissionEvaluationService;
        this.userDao = userDao;
        this.requirementVersionDao = requirementVersionDao;
    }

    @Override
    public boolean canGenerateTestCases(Long requirementVersionId) {
        if (!this.ultimateLicenseAvailabilityService.isAvailable()) {
            return false;
        }
        if (this.isRequirementVersionIncorrect(requirementVersionId)) {
            return false;
        }
        if (!this.isUserAllowedToCreateTestCases()) {
            return false;
        }
        return this.isAiProjectConfigurationCorrect(requirementVersionId);
    }

    boolean isRequirementVersionIncorrect(Long requirementVersionId) {
        RequirementVersion requirementVersion = this.requirementVersionDao.findById(requirementVersionId).orElse(null);
        return requirementVersion == null || RequirementStatus.OBSOLETE.equals((Object)requirementVersion.getStatus()) || requirementVersion.getDescription().isBlank();
    }

    boolean isUserAllowedToCreateTestCases() {
        Long userId = this.userDao.findUserId(UserContextHolder.getUsername());
        return this.permissionEvaluationService.hasAtLeastOneTestCaseCreationPermissionOrAdmin(userId);
    }

    boolean isAiProjectConfigurationCorrect(Long requirementVersionId) {
        Long projectIdLinkedToRequirement = this.requirementVersionDao.findProjectIdByRequirementVersionId(requirementVersionId);
        Long aiUseId = this.aiUseDao.findAiUseIdByUse(AiUseName.CLASSIC_TEST_CASE_GENERATION);
        ProjectAiConfiguration configuration = this.projectAiConfigurationDao.findByProjectIdAndAiUseId(projectIdLinkedToRequirement, aiUseId);
        if (configuration == null) {
            return false;
        }
        if (configuration.getAiServer() == null) {
            return false;
        }
        if (configuration.getPromptSet() == null) {
            return false;
        }
        if (configuration.getPromptSet().getPrompts().isEmpty()) {
            return false;
        }
        return this.aiTestCaseGenerationDisplayDao.isProjectAiConfigurationOperational(configuration.getAiServer().getId(), aiUseId, projectIdLinkedToRequirement);
    }

    @Override
    public List<String> fetchProjectAiConfigurationErrors(Long projectId) {
        Long aiUseId = this.aiUseDao.findAiUseIdByUse(AiUseName.CLASSIC_TEST_CASE_GENERATION);
        ProjectAiConfiguration configuration = this.projectAiConfigurationDao.findByProjectIdAndAiUseId(projectId, aiUseId);
        if (configuration == null) {
            return this.validateLegacyConfiguration(projectId);
        }
        return this.validateProjectAiConfiguration(configuration, aiUseId, projectId);
    }

    private List<String> validateLegacyConfiguration(Long projectId) {
        Long aiServerId = this.projectDao.findAiServerIdByProjectId(projectId);
        ArrayList<String> errors = new ArrayList<String>();
        if (aiServerId == null) {
            LOGGER.warn("No AI server configured for classic test case generation in project {}", new Object[]{projectId});
            errors.add("sqtm-core.artificial-intelligence.dialog.bad-project-ai-configuration.error.no-ai-server");
            return errors;
        }
        if (!this.aiTestCaseGenerationDisplayDao.isLegacyAiServerOperational(aiServerId)) {
            LOGGER.warn("The AI server declared for classic test case generation in project {} is not properly configured.", new Object[]{projectId});
            errors.add("sqtm-core.artificial-intelligence.dialog.bad-project-ai-configuration.error.server-badly-configured");
        }
        return errors;
    }

    private List<String> validateProjectAiConfiguration(ProjectAiConfiguration configuration, Long aiUseId, Long projectId) {
        return Stream.of(this.validateAiServer(configuration, aiUseId, projectId), this.validatePromptSet(configuration, projectId)).flatMap(Collection::stream).toList();
    }

    private List<String> validateAiServer(ProjectAiConfiguration configuration, Long aiUseId, Long projectId) {
        if (configuration.getAiServer() == null) {
            LOGGER.warn("No AI server configured for classic test case generation in project {}.", new Object[]{projectId});
            return List.of("sqtm-core.artificial-intelligence.dialog.bad-project-ai-configuration.error.no-ai-server");
        }
        if (!this.aiTestCaseGenerationDisplayDao.isProjectAiConfigurationOperational(configuration.getAiServer().getId(), aiUseId, projectId)) {
            LOGGER.warn("The AI server declared for classic test case generation in project {} is not properly configured.", new Object[]{projectId});
            return List.of("sqtm-core.artificial-intelligence.dialog.bad-project-ai-configuration.error.server-badly-configured");
        }
        return List.of();
    }

    private List<String> validatePromptSet(ProjectAiConfiguration configuration, Long projectId) {
        if (configuration.getPromptSet() == null) {
            LOGGER.warn("No prompt set configured for classic test case generation in project {}", new Object[]{projectId});
            return List.of("sqtm-core.artificial-intelligence.dialog.bad-project-ai-configuration.error.no-prompt-set");
        }
        if (configuration.getPromptSet().getPrompts().isEmpty()) {
            LOGGER.warn("The prompt set declared for classic test case generation in project {} has no prompt.", new Object[]{projectId});
            return List.of("sqtm-core.artificial-intelligence.dialog.bad-project-ai-configuration.error.no-prompt");
        }
        return List.of();
    }
}

