/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service;

import jakarta.inject.Inject;
import org.aspectj.lang.Aspects;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.aspectj.EnableSpringConfigured;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.event.RequirementCreationEventPublisherAspect;
import org.squashtest.tm.domain.event.RequirementModificationEventPublisherAspect;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.event.RequirementAuditor;
import org.squashtest.tm.service.internal.library.GenericFolderModificationService;
import org.squashtest.tm.service.internal.library.GenericNodeManagementService;
import org.squashtest.tm.service.internal.library.PasteStrategy;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.CampaignFolderDao;
import org.squashtest.tm.service.internal.repository.CampaignLibraryDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.RequirementLibraryDao;
import org.squashtest.tm.service.internal.repository.SprintDao;
import org.squashtest.tm.service.internal.repository.SprintGroupDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Configuration
@EnableSpringConfigured
@DependsOn(value={"org.springframework.transaction.config.internalTransactionAspect"})
public class TmServiceConfig {
    @Inject
    private TestCaseLibraryDao testCaseLibraryDao;
    @Inject
    private RequirementLibraryDao requirementLibraryDao;
    @Inject
    private CampaignLibraryDao campaignLibraryDao;
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private RequirementDao requirementDao;
    @Inject
    private CampaignDao campaignDao;
    @Inject
    private SprintDao sprintDao;
    @Inject
    private SprintGroupDao sprintGroupDao;
    @Inject
    private IterationDao iterationDao;
    @Inject
    private TestCaseFolderDao testCaseFolderDao;
    @Inject
    private RequirementFolderDao requirementFolderDao;
    @Inject
    private CampaignFolderDao campaignFolderDao;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private RequirementAuditor statusBasedRequirementAuditor;

    @Bean
    public RequirementCreationEventPublisherAspect requirementCreationEventPublisherAspect() {
        RequirementCreationEventPublisherAspect aspect = (RequirementCreationEventPublisherAspect)Aspects.aspectOf(RequirementCreationEventPublisherAspect.class);
        aspect.setAuditor(this.statusBasedRequirementAuditor);
        return aspect;
    }

    @Bean
    public RequirementModificationEventPublisherAspect requirementModificationEventPublisherAspect() {
        RequirementModificationEventPublisherAspect aspect = (RequirementModificationEventPublisherAspect)Aspects.aspectOf(RequirementModificationEventPublisherAspect.class);
        aspect.setAuditor(this.statusBasedRequirementAuditor);
        return aspect;
    }

    @Bean(name={"squashtest.tm.service.TestCaseFolderModificationService"})
    public GenericFolderModificationService<TestCaseFolder, TestCaseLibraryNode> testCaseFolderManager() {
        return new GenericFolderModificationService<TestCaseFolder, TestCaseLibraryNode>(this.permissionEvaluationService, this.testCaseFolderDao, this.testCaseLibraryDao);
    }

    @Bean(name={"squashtest.tm.service.RequirementFolderModificationService"})
    public GenericFolderModificationService<RequirementFolder, RequirementLibraryNode> requirementFolderManager() {
        return new GenericFolderModificationService<RequirementFolder, RequirementLibraryNode>(this.permissionEvaluationService, this.requirementFolderDao, this.requirementLibraryDao);
    }

    @Bean(name={"squashtest.tm.service.CampaignFolderModificationService"})
    public GenericFolderModificationService<CampaignFolder, CampaignLibraryNode> campaignFolderManager() {
        return new GenericFolderModificationService<CampaignFolder, CampaignLibraryNode>(this.permissionEvaluationService, this.campaignFolderDao, this.campaignLibraryDao);
    }

    @Bean(name={"squashtest.tm.service.internal.TestCaseManagementService"})
    public GenericNodeManagementService<TestCase, TestCaseLibraryNode, TestCaseFolder> testCaseManager() {
        return new GenericNodeManagementService<TestCase, TestCaseLibraryNode, TestCaseFolder>(this.permissionEvaluationService, this.testCaseDao, this.testCaseFolderDao, this.testCaseLibraryDao);
    }

    @Bean(name={"squashtest.tm.service.internal.RequirementManagementService"})
    public GenericNodeManagementService<Requirement, RequirementLibraryNode, RequirementFolder> requirementManager() {
        return new GenericNodeManagementService<Requirement, RequirementLibraryNode, RequirementFolder>(this.permissionEvaluationService, this.requirementDao, this.requirementFolderDao, this.requirementLibraryDao);
    }

    @Bean(name={"squashtest.tm.service.internal.CampaignManagementService"})
    public GenericNodeManagementService<Campaign, CampaignLibraryNode, CampaignFolder> campaignManager() {
        return new GenericNodeManagementService<Campaign, CampaignLibraryNode, CampaignFolder>(this.permissionEvaluationService, this.campaignDao, this.campaignFolderDao, this.campaignLibraryDao);
    }

    @Bean(name={"squashtest.tm.service.internal.SprintManagementService"})
    public GenericNodeManagementService<Sprint, CampaignLibraryNode, CampaignFolder> sprintManager() {
        return new GenericNodeManagementService<Sprint, CampaignLibraryNode, CampaignFolder>(this.permissionEvaluationService, this.sprintDao, this.campaignFolderDao, this.campaignLibraryDao);
    }

    @Bean(name={"squashtest.tm.service.internal.SprintGroupManagementService"})
    public GenericNodeManagementService<SprintGroup, CampaignLibraryNode, CampaignFolder> sprintGroupManager() {
        return new GenericNodeManagementService<SprintGroup, CampaignLibraryNode, CampaignFolder>(this.permissionEvaluationService, this.sprintGroupDao, this.campaignFolderDao, this.campaignLibraryDao);
    }

    @Bean(name={"squashtest.tm.service.internal.PasteToTestCaseFolderStrategy"})
    @Scope(value="prototype")
    public PasteStrategy<TestCaseFolder, TestCaseLibraryNode> pasteToTestCaseFolderStrategy() {
        PasteStrategy<TestCaseFolder, TestCaseLibraryNode> paster = new PasteStrategy<TestCaseFolder, TestCaseLibraryNode>();
        paster.setContainerDao(this.testCaseFolderDao);
        paster.setNodeType(TestCaseLibraryNode.class);
        return paster;
    }

    @Bean(name={"squashtest.tm.service.internal.PasteToTestCaseLibraryStrategy"})
    @Scope(value="prototype")
    public PasteStrategy<TestCaseLibrary, TestCaseLibraryNode> pasteToTestCaseLibraryStrategy() {
        PasteStrategy<TestCaseLibrary, TestCaseLibraryNode> paster = new PasteStrategy<TestCaseLibrary, TestCaseLibraryNode>();
        paster.setContainerDao(this.testCaseLibraryDao);
        paster.setNodeType(TestCaseLibraryNode.class);
        return paster;
    }

    @Bean(name={"squashtest.tm.service.internal.PasteToRequirementFolderStrategy"})
    @Scope(value="prototype")
    public PasteStrategy<RequirementFolder, RequirementLibraryNode> pasteToRequirementFolderStrategy() {
        PasteStrategy<RequirementFolder, RequirementLibraryNode> paster = new PasteStrategy<RequirementFolder, RequirementLibraryNode>();
        paster.setContainerDao(this.requirementFolderDao);
        paster.setNodeType(RequirementLibraryNode.class);
        return paster;
    }

    @Bean(name={"squashtest.tm.service.internal.PasteToRequirementLibraryStrategy"})
    @Scope(value="prototype")
    public PasteStrategy<RequirementLibrary, RequirementLibraryNode> pasteToRequirementLibraryStrategy() {
        PasteStrategy<RequirementLibrary, RequirementLibraryNode> paster = new PasteStrategy<RequirementLibrary, RequirementLibraryNode>();
        paster.setContainerDao(this.requirementLibraryDao);
        paster.setNodeType(RequirementLibraryNode.class);
        return paster;
    }

    @Bean(name={"squashtest.tm.service.internal.PasteToRequirementStrategy"})
    @Scope(value="prototype")
    public PasteStrategy<Requirement, Requirement> pasteToRequirementStrategy() {
        PasteStrategy<Requirement, Requirement> paster = new PasteStrategy<Requirement, Requirement>();
        paster.setContainerDao(this.requirementDao);
        paster.setNodeType(Requirement.class);
        return paster;
    }

    @Bean(name={"squashtest.tm.service.internal.PasteToCampaignFolderStrategy"})
    @Scope(value="prototype")
    public PasteStrategy<CampaignFolder, CampaignLibraryNode> pasteToCampaignFolderStrategy() {
        PasteStrategy<CampaignFolder, CampaignLibraryNode> paster = new PasteStrategy<CampaignFolder, CampaignLibraryNode>();
        paster.setContainerDao(this.campaignFolderDao);
        paster.setNodeType(CampaignLibraryNode.class);
        return paster;
    }

    @Bean(name={"squashtest.tm.service.internal.PasteToSprintGroupStrategy"})
    @Scope(value="prototype")
    public PasteStrategy<SprintGroup, CampaignLibraryNode> pasteToSprintGroupStrategy() {
        PasteStrategy<SprintGroup, CampaignLibraryNode> paster = new PasteStrategy<SprintGroup, CampaignLibraryNode>();
        paster.setContainerDao(this.sprintGroupDao);
        paster.setNodeType(CampaignLibraryNode.class);
        return paster;
    }

    @Bean(name={"squashtest.tm.service.internal.PasteToCampaignLibraryStrategy"})
    @Scope(value="prototype")
    public PasteStrategy<CampaignLibrary, CampaignLibraryNode> pasteToCampaignLibraryStrategy() {
        PasteStrategy<CampaignLibrary, CampaignLibraryNode> paster = new PasteStrategy<CampaignLibrary, CampaignLibraryNode>();
        paster.setContainerDao(this.campaignLibraryDao);
        paster.setNodeType(CampaignLibraryNode.class);
        return paster;
    }

    @Bean(name={"squashtest.tm.service.internal.PasteToCampaignStrategy"})
    @Scope(value="prototype")
    public PasteStrategy<Campaign, Iteration> pasteToCampaignStrategy() {
        PasteStrategy<Campaign, Iteration> paster = new PasteStrategy<Campaign, Iteration>();
        paster.setContainerDao(this.campaignDao);
        paster.setNodeType(Iteration.class);
        return paster;
    }

    @Bean(name={"squashtest.tm.service.internal.PasteToIterationStrategy"})
    @Scope(value="prototype")
    public PasteStrategy<Iteration, TestSuite> pasteToIterationStrategy() {
        PasteStrategy<Iteration, TestSuite> paster = new PasteStrategy<Iteration, TestSuite>();
        paster.setContainerDao(this.iterationDao);
        paster.setNodeType(TestSuite.class);
        return paster;
    }
}

