/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.jooq;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Record4;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectSeekStep2;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.TestCaseBinTreeDao;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.TestCaseCollector;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

@Repository
public class TestCaseBinTreeDaoImpl
implements TestCaseBinTreeDao {
    private final DSLContext dsl;
    private final TestCaseCollector testCaseCollector;

    public TestCaseBinTreeDaoImpl(DSLContext dsl, TestCaseCollector testCaseCollector) {
        this.dsl = dsl;
        this.testCaseCollector = testCaseCollector;
    }

    @Override
    public List<Long> findLibraryIdsWithDeletedNodesByProject(Collection<Long> projectIds) {
        return this.findLibraryIdsWithDeletedNodes(Tables.PROJECT.PROJECT_ID.in(projectIds));
    }

    @Override
    public List<Long> filterLibraryIdsWithDeletedNodes(Collection<Long> libraryIds) {
        return this.findLibraryIdsWithDeletedNodes(Tables.PROJECT.TCL_ID.in(libraryIds));
    }

    private List<Long> findLibraryIdsWithDeletedNodes(Condition filterCondition) {
        return this.dsl.selectDistinct((SelectField)Tables.PROJECT.TCL_ID).from((TableLike)Tables.PROJECT).where(filterCondition).and(DSL.exists((Select)DSL.selectOne().from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).and(ConditionsConstants.TCLN_IN_BIN))).fetch((Field)Tables.PROJECT.TCL_ID);
    }

    @Override
    public Map<NodeReference, List<NodeReference>> findLibrariesChildren(List<NodeReference> libraryReferences) {
        if (libraryReferences.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, NodeReference> referenceById = libraryReferences.stream().collect(Collectors.toMap(NodeReference::getId, Function.identity()));
        SelectSeekStep2 query = this.dsl.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID, (SelectField)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID, (SelectField)Tables.TEST_CASE_FOLDER.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ORDER).from((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).innerJoin((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID.in(referenceById.keySet()).and(ConditionsConstants.TCLN_IN_BIN)).orderBy((OrderField)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID, (OrderField)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ORDER);
        return this.fetchChildren(referenceById, (Select<Record4<Long, Long, Long, Integer>>)query);
    }

    @Override
    public Map<NodeReference, List<NodeReference>> findFoldersChildren(List<NodeReference> folderReferences) {
        if (folderReferences.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, NodeReference> referenceById = folderReferences.stream().collect(Collectors.toMap(NodeReference::getId, Function.identity()));
        SelectSeekStep2 query = this.dsl.selectDistinct((SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID, (SelectField)Tables.TEST_CASE_FOLDER.TCLN_ID, (SelectField)Tables.TCLN_RELATIONSHIP.CONTENT_ORDER).from((TableLike)Tables.TCLN_RELATIONSHIP).innerJoin((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.in(referenceById.keySet()).and(ConditionsConstants.TCLN_IN_BIN)).orderBy((OrderField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (OrderField)Tables.TCLN_RELATIONSHIP.CONTENT_ORDER);
        return this.fetchChildren(referenceById, (Select<Record4<Long, Long, Long, Integer>>)query);
    }

    private Map<NodeReference, List<NodeReference>> fetchChildren(Map<Long, NodeReference> referenceById, Select<Record4<Long, Long, Long, Integer>> query) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream stream = query.fetchStream();){
            return stream.collect(Collectors.groupingBy(tuple -> (NodeReference)referenceById.get(tuple.value1()), LinkedHashMap::new, Collectors.mapping(tuple -> {
                Long contentId = (Long)tuple.value2();
                boolean isFolder = tuple.value3() != null;
                return new NodeReference(isFolder ? NodeType.TEST_CASE_FOLDER : NodeType.TEST_CASE, contentId);
            }, Collectors.toList())));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Map<NodeReference, DataRow> getLibrariesDataRows(Collection<Long> libraryIds) {
        if (libraryIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Table<Record2<Long, Integer>> libraryContentCount = TestCaseBinTreeDaoImpl.getLibraryContentCountTable(libraryIds);
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY.TCL_ID, (SelectField)Tables.PROJECT.PROJECT_ID.as("PROJECT_ID"), (SelectField)DSL.coalesce((Field)libraryContentCount.field("CHILDREN_COUNT", Integer.class), (Object)0).as("CHILDREN_COUNT"), (SelectField)Tables.PROJECT.NAME).from((TableLike)Tables.TEST_CASE_LIBRARY).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY.TCL_ID.eq((Field)Tables.PROJECT.TCL_ID)).leftJoin(libraryContentCount).on(Tables.TEST_CASE_LIBRARY.TCL_ID.eq(libraryContentCount.field("LIBRARY_ID", Long.class))).where(Tables.PROJECT.TCL_ID.in(libraryIds)).orderBy((OrderField)Tables.TEST_CASE_LIBRARY.TCL_ID).fetchStream().map(tuple -> {
            NodeReference reference = new NodeReference(NodeType.TEST_CASE_LIBRARY, (Long)tuple.value1());
            DataRow dataRow = this.createDataRowFromTuple(reference, (Long)tuple.value2(), (Integer)tuple.value3(), tuple.intoMap());
            return Map.entry(reference, dataRow);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> existing, LinkedHashMap::new));
    }

    private static Table<Record2<Long, Integer>> getLibraryContentCountTable(Collection<Long> projectIds) {
        return DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID.as("LIBRARY_ID"), (SelectField)DSL.countDistinct((Field)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID).as("CHILDREN_COUNT")).from((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).innerJoin((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.in(projectIds).and(ConditionsConstants.TCLN_IN_BIN)).groupBy(new GroupField[]{Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID}).asTable("test_case_library_content_count");
    }

    @Override
    public Map<NodeReference, DataRow> getFoldersDataRows(Collection<Long> folderIds) {
        if (folderIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Table<Record2<Long, Integer>> folderContentCount = TestCaseBinTreeDaoImpl.getFolderContentCountTable(folderIds);
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.as("PROJECT_ID"), (SelectField)DSL.coalesce((Field)folderContentCount.field("CHILDREN_COUNT", Integer.class), (Object)0).as("CHILDREN_COUNT"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)ConditionsConstants.TCLN_IN_BIN.as("DELETED")).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin(folderContentCount).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(folderContentCount.field("ANCESTOR_ID", Long.class))).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(folderIds)).fetchStream().map(tuple -> {
            NodeReference reference = new NodeReference(NodeType.TEST_CASE_FOLDER, (Long)tuple.value1());
            DataRow dataRow = this.createDataRowFromTuple(reference, (Long)tuple.value2(), (Integer)tuple.value3(), tuple.intoMap());
            return Map.entry(reference, dataRow);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private DataRow createDataRowFromTuple(NodeReference reference, Long projectId, Integer childrenCount, Map<String, Object> data) {
        DataRow dataRow = new DataRow();
        dataRow.setId(reference.toNodeId());
        dataRow.setProjectId(projectId);
        dataRow.setState(childrenCount > 0 ? DataRow.State.closed : DataRow.State.leaf);
        dataRow.setData(data);
        return dataRow;
    }

    private static Table<Record2<Long, Integer>> getFolderContentCountTable(Collection<Long> folderIds) {
        return DSL.select((SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)DSL.countDistinct((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).as("CHILDREN_COUNT")).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).innerJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID)).where(Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.in(folderIds).and(ConditionsConstants.TCLN_IN_BIN)).groupBy(new GroupField[]{Tables.TCLN_RELATIONSHIP.ANCESTOR_ID}).asTable("test_case_folder_content_count");
    }

    @Override
    public Map<NodeReference, DataRow> getTestCasesDataRows(List<Long> testCaseIds) {
        if (testCaseIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.testCaseCollector.collectDeletedNodes(testCaseIds).entrySet().stream().map(entry -> {
            DataRow dataRow = (DataRow)entry.getValue();
            dataRow.addData("DELETED", true);
            return Map.entry((Long)entry.getKey(), dataRow);
        }).collect(Collectors.toMap(entry -> new NodeReference(NodeType.TEST_CASE, (Long)entry.getKey()), Map.Entry::getValue));
    }

    @Override
    public List<Long> retrieveProjectIdsByNodes(Map<NodeType, List<NodeReference>> nodes) {
        Set<Long> libraries = nodes.getOrDefault(NodeType.TEST_CASE_LIBRARY, Collections.emptyList()).stream().map(NodeReference::getId).collect(Collectors.toSet());
        Set<Long> folders = nodes.getOrDefault(NodeType.TEST_CASE_FOLDER, Collections.emptyList()).stream().map(NodeReference::getId).collect(Collectors.toSet());
        if (libraries.isEmpty() && folders.isEmpty()) {
            return Collections.emptyList();
        }
        if (folders.isEmpty()) {
            return this.getLibrariesProjectIdsQuery(libraries).fetchInto(Long.class);
        }
        if (libraries.isEmpty()) {
            return this.getFoldersProjectIdsQuery(folders).fetchInto(Long.class);
        }
        return this.getLibrariesProjectIdsQuery(libraries).union(this.getFoldersProjectIdsQuery(folders)).fetchInto(Long.class);
    }

    private SelectConditionStep<Record1<Long>> getFoldersProjectIdsQuery(Set<Long> folders) {
        return this.dsl.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(folders));
    }

    private SelectConditionStep<Record1<Long>> getLibrariesProjectIdsQuery(Set<Long> libraries) {
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.TCL_ID.in(libraries));
    }

    @Override
    public long countDeletedNodesByProjects(List<Long> projectIds) {
        return this.dsl.fetchCount((Select)DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.in(projectIds).and(ConditionsConstants.TCLN_IN_BIN)));
    }

    @Override
    public long countDeletedNodesByLibraries(List<Long> libraryIds) {
        return this.dsl.fetchCount((Select)DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).where(Tables.PROJECT.TCL_ID.in(libraryIds).and(ConditionsConstants.TCLN_IN_BIN)));
    }
}

