/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.Session;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.users.QUser;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.domain.users.UsersGroup;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.MilestonePossibleOwnerDto;
import org.squashtest.tm.service.internal.repository.CustomUserDao;

@Repository(value="userDaoImpl")
public class UserDaoImpl
implements CustomUserDao {
    private static final String FIND_ALL_ADMIN = "SELECT  member.PARTY_ID FROM  CORE_GROUP_MEMBER member inner join CORE_GROUP_AUTHORITY cga on cga.GROUP_ID=member.GROUP_ID WHERE cga.AUTHORITY = 'ROLE_ADMIN' ";
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private DSLContext dsl;

    @Override
    public List<MilestonePossibleOwnerDto> findAllAdminOrManager() {
        return this.dsl.selectDistinct((SelectField)Tables.CORE_USER.PARTY_ID.as("ID"), (SelectField)Tables.CORE_USER.LOGIN, (SelectField)Tables.CORE_USER.FIRST_NAME, (SelectField)Tables.CORE_USER.LAST_NAME).from((TableLike)Tables.CORE_USER).where(Tables.CORE_USER.PARTY_ID.in((Select)this.dsl.select((SelectField)Tables.CORE_GROUP_MEMBER.PARTY_ID).from((TableLike)Tables.CORE_GROUP_MEMBER).join((TableLike)Tables.CORE_GROUP_AUTHORITY).on(Tables.CORE_GROUP_MEMBER.GROUP_ID.eq((Field)Tables.CORE_GROUP_AUTHORITY.GROUP_ID)).where(Tables.CORE_GROUP_AUTHORITY.AUTHORITY.eq((Object)"ROLE_ADMIN")).union((Select)this.dsl.select((SelectField)Tables.CORE_USER.PARTY_ID).from((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).join((TableLike)Tables.CORE_USER).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.eq((Field)Tables.CORE_USER.PARTY_ID)).join((TableLike)Tables.ACL_GROUP_PERMISSION).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.eq((Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID)).where(Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK.eq((Object)Permissions.MANAGE_MILESTONE.getMask()))).union((Select)this.dsl.select((SelectField)Tables.CORE_TEAM_MEMBER.USER_ID).from((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).join((TableLike)Tables.CORE_TEAM).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.eq((Field)Tables.CORE_TEAM.PARTY_ID)).join((TableLike)Tables.CORE_TEAM_MEMBER).on(Tables.CORE_TEAM.PARTY_ID.eq((Field)Tables.CORE_TEAM_MEMBER.TEAM_ID)).join((TableLike)Tables.ACL_GROUP_PERMISSION).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.eq((Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID)).where(Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK.eq((Object)Permissions.MANAGE_MILESTONE.getMask()))))).fetchInto(MilestonePossibleOwnerDto.class);
    }

    @Override
    public List<User> findAllAdmin() {
        List ids = ((Session)this.entityManager.unwrap(Session.class)).createNativeQuery(FIND_ALL_ADMIN, Long.class).setTupleTransformer((tuple, aliases) -> tuple[0] == null ? null : (Long)tuple[0]).list();
        return ((JPAQuery)new JPAQueryFactory(this.entityManager).selectFrom((EntityPath)QUser.user).where((Predicate)QUser.user.id.in((Collection)ids))).fetch();
    }

    @Override
    public Long findUserId(String login) {
        return (Long)this.dsl.select((SelectField)Tables.CORE_USER.PARTY_ID).from((TableLike)Tables.CORE_USER).where(Tables.CORE_USER.LOGIN.eq((Object)login)).fetchOne((Field)Tables.CORE_USER.PARTY_ID);
    }

    @Override
    public int countAllActiveUsers() {
        return (Integer)this.dsl.selectCount().from((TableLike)Tables.CORE_USER).join((TableLike)Tables.CORE_GROUP_MEMBER).on(Tables.CORE_USER.PARTY_ID.eq((Field)Tables.CORE_GROUP_MEMBER.PARTY_ID)).join((TableLike)Tables.CORE_GROUP).on(Tables.CORE_GROUP_MEMBER.GROUP_ID.eq((Field)Tables.CORE_GROUP.ID)).where(Tables.CORE_USER.ACTIVE.isTrue()).and(Tables.CORE_GROUP.QUALIFIED_NAME.notIn((Collection)UsersGroup.TECHNICAL_USER_GROUPS)).fetchOne(0, Integer.TYPE);
    }

    @Override
    public String findUserLoginById(long userId) {
        return (String)this.dsl.select((SelectField)Tables.CORE_USER.LOGIN).from((TableLike)Tables.CORE_USER).where(Tables.CORE_USER.PARTY_ID.eq((Object)userId)).fetchOneInto(String.class);
    }

    @Override
    public Set<Long> findAllUserIdsFromInfrastructureAdminGroup() {
        return new HashSet<Long>(this.dsl.select((SelectField)Tables.CORE_GROUP_MEMBER.PARTY_ID).from((TableLike)Tables.CORE_GROUP_MEMBER).join((TableLike)Tables.CORE_GROUP).on(Tables.CORE_GROUP.ID.eq((Field)Tables.CORE_GROUP_MEMBER.GROUP_ID)).where(Tables.CORE_GROUP.QUALIFIED_NAME.eq((Object)"squashtest.authz.group.tm.InfrastructureAdmin")).fetchInto(Long.class));
    }

    @Override
    public List<String> filterActiveUserLogins(Collection<String> logins) {
        return this.dsl.select((SelectField)Tables.CORE_USER.LOGIN).from((TableLike)Tables.CORE_USER).where(Tables.CORE_USER.LOGIN.in(logins).and(Tables.CORE_USER.ACTIVE.eq((Object)Boolean.TRUE))).fetchInto(String.class);
    }

    @Override
    public String findUserGroupQualifiedName(@NotNull String login) {
        String string = login;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        return (String)this.dsl.select((SelectField)Tables.CORE_GROUP.QUALIFIED_NAME).from((TableLike)Tables.CORE_USER).join((TableLike)Tables.CORE_GROUP_MEMBER).on(Tables.CORE_USER.PARTY_ID.eq((Field)Tables.CORE_GROUP_MEMBER.PARTY_ID)).join((TableLike)Tables.CORE_GROUP).on(Tables.CORE_GROUP_MEMBER.GROUP_ID.eq((Field)Tables.CORE_GROUP.ID)).where(Tables.CORE_USER.LOGIN.eq((Object)login)).fetchOneInto(String.class);
    }

    @Override
    public String findUserGroupQualifiedName(@NotNull long userId) {
        long l = userId;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(Conversions.longObject((long)l));
        return (String)this.dsl.select((SelectField)Tables.CORE_GROUP.QUALIFIED_NAME).from((TableLike)Tables.CORE_USER).join((TableLike)Tables.CORE_GROUP_MEMBER).on(Tables.CORE_USER.PARTY_ID.eq((Field)Tables.CORE_GROUP_MEMBER.PARTY_ID)).join((TableLike)Tables.CORE_GROUP).on(Tables.CORE_GROUP_MEMBER.GROUP_ID.eq((Field)Tables.CORE_GROUP.ID)).where(Tables.CORE_USER.PARTY_ID.eq((Object)userId)).fetchOneInto(String.class);
    }
}

